/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.QuotedIDImpl;
import java.io.IOException;

public class RelationIDImpl
implements RelationID {
    private final QuotedID schema;
    private final QuotedID table;

    RelationIDImpl(QuotedID schema, QuotedID table) {
        this.schema = schema;
        this.table = table;
    }

    @Override
    @JsonIgnore
    public ImmutableList<RelationID> getWithSchemalessID() {
        return this.schema.getName() == null ? ImmutableList.of((Object)this) : ImmutableList.of((Object)new RelationIDImpl(QuotedIDImpl.EMPTY_ID, this.table), (Object)this);
    }

    @Override
    @JsonProperty(value="name")
    public QuotedID getTableID() {
        return this.table;
    }

    @Override
    @JsonProperty(value="schema")
    public QuotedID getSchemaID() {
        return this.schema;
    }

    @Override
    @JsonIgnore
    public String getSQLRendering() {
        String s = this.schema.getSQLRendering();
        if (s == null) {
            return this.table.getSQLRendering();
        }
        return s + "." + this.table.getSQLRendering();
    }

    public String toString() {
        return this.getSQLRendering();
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RelationIDImpl) {
            RelationIDImpl other = (RelationIDImpl)obj;
            return this.schema.equals(other.schema) && this.table.equals(other.table);
        }
        return false;
    }

    public static class RelationIDSerializer
    extends JsonSerializer<RelationID> {
        public void serialize(RelationID value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.getSQLRendering());
        }
    }
}

