/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.function.Function;

public class ImmutableMetadataLookup
implements MetadataLookup {
    protected final QuotedIDFactory idFactory;
    protected final ImmutableMap<RelationID, DatabaseRelationDefinition> map;

    ImmutableMetadataLookup(QuotedIDFactory idFactory, ImmutableMap<RelationID, DatabaseRelationDefinition> map) {
        this.idFactory = idFactory;
        this.map = map;
    }

    @Override
    public DatabaseRelationDefinition getRelation(RelationID id) throws MetadataExtractionException {
        DatabaseRelationDefinition relation = (DatabaseRelationDefinition)this.map.get((Object)id);
        if (relation == null) {
            throw new MetadataExtractionException("Relation " + id + " not found");
        }
        return relation;
    }

    @Override
    public QuotedIDFactory getQuotedIDFactory() {
        return this.idFactory;
    }

    protected ImmutableList<DatabaseRelationDefinition> getRelations() {
        return (ImmutableList)this.map.values().stream().collect(ImmutableCollectors.toMultimap(DatabaseRelationDefinition::getAllIDs, Function.identity())).asMap().values().stream().map(s -> (DatabaseRelationDefinition)s.iterator().next()).collect(ImmutableCollectors.toList());
    }
}

