/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.ImmutableMetadata;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;

public class ImmutableMetadataImpl
implements ImmutableMetadata {
    private final DBParameters dbParameters;
    private final ImmutableList<DatabaseRelationDefinition> relations;

    ImmutableMetadataImpl(DBParameters dbParameters, ImmutableList<DatabaseRelationDefinition> relations) {
        this.dbParameters = dbParameters;
        this.relations = relations;
    }

    @Override
    @JsonProperty(value="relations")
    public ImmutableList<DatabaseRelationDefinition> getAllRelations() {
        return this.relations;
    }

    @Override
    @JsonIgnore
    public DBParameters getDBParameters() {
        return this.dbParameters;
    }

    @JsonProperty(value="metadata")
    Map<String, String> getMetadataForJsonExport() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String extractionTime = dateFormat.format(Calendar.getInstance().getTime());
        return ImmutableMap.builder().put((Object)"dbmsProductName", (Object)this.getDBParameters().getDbmsProductName()).put((Object)"dbmsVersion", (Object)this.getDBParameters().getDbmsVersion()).put((Object)"driverName", (Object)this.getDBParameters().getDriverName()).put((Object)"driverVersion", (Object)this.getDBParameters().getDriverVersion()).put((Object)"quotationString", (Object)this.getDBParameters().getQuotedIDFactory().getIDQuotationString()).put((Object)"extractionTime", (Object)extractionTime).build();
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        for (DatabaseRelationDefinition r : this.relations) {
            bf.append(r.getAllIDs()).append("=").append(r).append("\n");
        }
        bf.append("\n====== constraints ==========\n");
        for (DatabaseRelationDefinition r : this.relations) {
            for (UniqueConstraint uc : r.getUniqueConstraints()) {
                bf.append(uc).append(";\n");
            }
            bf.append("\n");
            for (ForeignKeyConstraint fk : r.getForeignKeys()) {
                bf.append(fk).append(";\n");
            }
            bf.append("\n");
        }
        return bf.toString();
    }
}

