/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.QuotedID;

public class FunctionalDependencyImpl
implements FunctionalDependency {
    private final ImmutableSet<Attribute> determinants;
    private final ImmutableSet<Attribute> dependents;

    private FunctionalDependencyImpl(ImmutableSet<Attribute> determinants, ImmutableSet<Attribute> dependents) {
        this.determinants = determinants;
        this.dependents = dependents;
    }

    @Override
    public ImmutableSet<Attribute> getDeterminants() {
        return this.determinants;
    }

    @Override
    public ImmutableSet<Attribute> getDependents() {
        return this.dependents;
    }

    public static FunctionalDependency.Builder builder(DatabaseRelationDefinition relation) {
        return new BuilderImpl(relation);
    }

    private static class BuilderImpl
    implements FunctionalDependency.Builder {
        private final ImmutableSet.Builder<Attribute> determinants = ImmutableSet.builder();
        private final ImmutableSet.Builder<Attribute> dependents = ImmutableSet.builder();
        private final DatabaseRelationDefinition relation;

        private BuilderImpl(DatabaseRelationDefinition relation) {
            this.relation = relation;
        }

        @Override
        public FunctionalDependency.Builder addDeterminant(int determinantIndex) {
            this.determinants.add((Object)this.relation.getAttribute(determinantIndex));
            return this;
        }

        @Override
        public FunctionalDependency.Builder addDeterminant(QuotedID determinantId) throws AttributeNotFoundException {
            this.determinants.add((Object)this.relation.getAttribute(determinantId));
            return this;
        }

        @Override
        public FunctionalDependency.Builder addDependent(int dependentIndex) {
            this.dependents.add((Object)this.relation.getAttribute(dependentIndex));
            return this;
        }

        @Override
        public FunctionalDependency.Builder addDependent(QuotedID dependentId) throws AttributeNotFoundException {
            this.dependents.add((Object)this.relation.getAttribute(dependentId));
            return this;
        }

        @Override
        public void build() {
            this.relation.addFunctionalDependency(new FunctionalDependencyImpl(this.determinants.build(), this.dependents.build()));
        }
    }
}

