/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.constraints;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableCollection;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.constraints.ImmutableHomomorphism;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class ImmutableHomomorphismIterator<P extends AtomPredicate>
implements Iterator<ImmutableHomomorphism> {
    private final ListIterator<DataAtom<P>> iterator;
    private final Deque<State> stack;
    private boolean movedToNext;
    private ImmutableHomomorphism next;
    private final ImmutableCollection<DataAtom<P>> to;

    public ImmutableHomomorphismIterator(ImmutableHomomorphism baseHomomorphism, ImmutableList<DataAtom<P>> from, ImmutableCollection<DataAtom<P>> to) {
        this.iterator = from.listIterator();
        this.stack = new ArrayDeque<State>(from.size());
        this.to = to;
        if (this.iterator.hasNext()) {
            this.movedToNext = false;
            this.stack.push(new State(this.iterator.next(), baseHomomorphism));
        } else {
            this.movedToNext = true;
            this.next = baseHomomorphism;
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.movedToNext) {
            this.next = this.shift();
            this.movedToNext = true;
        }
        return this.next != null;
    }

    @Override
    public ImmutableHomomorphism next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.movedToNext = false;
        return this.next;
    }

    private ImmutableHomomorphism shift() {
        while (!this.stack.isEmpty()) {
            State state = this.stack.peek();
            DataAtom candidateAtom = state.remainingChoices.poll();
            if (candidateAtom != null) {
                ImmutableHomomorphism.Builder builder;
                if (!state.atom.getPredicate().equals(candidateAtom.getPredicate()) || !(builder = ImmutableHomomorphism.builder(state.homomorphism)).extend(state.atom.getArguments(), candidateAtom.getArguments()).isValid()) continue;
                ImmutableHomomorphism homomorphism = builder.build();
                if (this.iterator.hasNext()) {
                    this.stack.push(new State(this.iterator.next(), homomorphism));
                    continue;
                }
                return homomorphism;
            }
            this.stack.pop();
            this.iterator.previous();
        }
        return null;
    }

    private final class State {
        final ImmutableHomomorphism homomorphism;
        final Queue<DataAtom<P>> remainingChoices;
        final DataAtom<P> atom;

        State(DataAtom<P> atom, ImmutableHomomorphism homomorphism) {
            this.atom = atom;
            this.homomorphism = homomorphism;
            this.remainingChoices = new ArrayDeque(ImmutableHomomorphismIterator.this.to);
        }
    }
}

