/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.ObjectStringTemplateFunctionSymbol;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class Templates {
    private static final String PLACE_HOLDER = "{}";
    private static final int PLACE_HOLDER_LENGTH = "{}".length();

    public static String format(String uriTemplate, Collection<?> args) {
        StringBuilder sb = new StringBuilder();
        int beginIndex = 0;
        for (Object arg : args) {
            int endIndex = uriTemplate.indexOf(PLACE_HOLDER, beginIndex);
            sb.append(uriTemplate.subSequence(beginIndex, endIndex)).append(arg);
            beginIndex = endIndex + PLACE_HOLDER_LENGTH;
        }
        sb.append(uriTemplate.substring(beginIndex));
        return sb.toString();
    }

    public static int getArity(String template) {
        int count = 0;
        int currentIndex = template.indexOf(PLACE_HOLDER);
        while (currentIndex >= 0) {
            currentIndex = template.indexOf(PLACE_HOLDER, currentIndex + 1);
            ++count;
        }
        return count;
    }

    public static String format(String uriTemplate, Object ... args) {
        return Templates.format(uriTemplate, Arrays.asList(args));
    }

    public static String getTemplateString(ImmutableFunctionalTerm lexicalFunctionalTerm) {
        if (!(lexicalFunctionalTerm.getFunctionSymbol() instanceof ObjectStringTemplateFunctionSymbol)) {
            throw new IllegalArgumentException("The lexical term was expected to have a ObjectStringTemplateFunctionSymbol: " + lexicalFunctionalTerm);
        }
        String template = ((ObjectStringTemplateFunctionSymbol)lexicalFunctionalTerm.getFunctionSymbol()).getTemplate();
        ImmutableList<? extends ImmutableTerm> subTerms = lexicalFunctionalTerm.getTerms();
        List splitParts = Splitter.on((String)PLACE_HOLDER).splitToList((CharSequence)template);
        StringBuilder templateWithVars = new StringBuilder();
        int numVars = subTerms.size();
        int numParts = splitParts.size();
        if (numParts != numVars + 1 && numParts != numVars) {
            throw new IllegalArgumentException("the number of place holders should be equal to the number of other terms.");
        }
        for (int i = 0; i < numVars; ++i) {
            templateWithVars.append((String)splitParts.get(i)).append("{").append(subTerms.get(i)).append("}");
        }
        if (numParts == numVars + 1) {
            templateWithVars.append((String)splitParts.get(numVars));
        }
        return templateWithVars.toString();
    }

    public static String getDBConcatTemplateString(ImmutableFunctionalTerm lexicalTerm) {
        if (!(lexicalTerm.getFunctionSymbol() instanceof DBConcatFunctionSymbol)) {
            throw new IllegalArgumentException("The lexical term was expected to have a DBConcatFunctionSymbol");
        }
        return lexicalTerm.getTerms().stream().map(t -> "{" + t + "}").collect(Collectors.joining());
    }
}

