/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.impl.DBTermTypeImpl;
import java.util.Optional;
import javax.annotation.Nullable;

public class NumberDBTermType
extends DBTermTypeImpl {
    private final String castName;
    @Nullable
    private final RDFDatatype rdfDatatype;
    private final DBTermType.Category category;

    protected NumberDBTermType(String name, String castName, TermTypeAncestry parentAncestry, RDFDatatype rdfDatatype, DBTermType.Category category) {
        super(name, parentAncestry, false);
        this.castName = castName;
        this.rdfDatatype = rdfDatatype;
        this.category = category;
    }

    protected NumberDBTermType(String name, TermTypeAncestry parentAncestry, RDFDatatype rdfDatatype, DBTermType.Category category) {
        super(name, parentAncestry, false);
        this.rdfDatatype = rdfDatatype;
        this.castName = name;
        this.category = category;
    }

    @Override
    public DBTermType.Category getCategory() {
        return this.category;
    }

    @Override
    public Optional<RDFDatatype> getNaturalRDFDatatype() {
        return Optional.ofNullable(this.rdfDatatype);
    }

    @Override
    public boolean isNeedingIRISafeEncoding() {
        return false;
    }

    @Override
    public boolean areEqualitiesStrict() {
        return this.category == DBTermType.Category.INTEGER;
    }

    @Override
    public Optional<Boolean> areEqualitiesStrict(DBTermType otherType) {
        return Optional.of(otherType.getCategory() == DBTermType.Category.INTEGER);
    }

    @Override
    public boolean areEqualitiesBetweenTwoDBAttributesStrict() {
        return true;
    }

    @Override
    public String getCastName() {
        return this.castName;
    }
}

