/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.tools.TypeConstantDictionary;
import it.unibz.inf.ontop.model.term.BNode;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonGroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.InequalityLabel;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.IRIStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.impl.BNodeConstantImpl;
import it.unibz.inf.ontop.model.term.impl.DBConstantImpl;
import it.unibz.inf.ontop.model.term.impl.FunctionalTermDecompositionImpl;
import it.unibz.inf.ontop.model.term.impl.GroundExpressionImpl;
import it.unibz.inf.ontop.model.term.impl.GroundFunctionalTermImpl;
import it.unibz.inf.ontop.model.term.impl.GroundTermTools;
import it.unibz.inf.ontop.model.term.impl.IRIConstantImpl;
import it.unibz.inf.ontop.model.term.impl.ImmutableExpressionImpl;
import it.unibz.inf.ontop.model.term.impl.NonGroundExpressionImpl;
import it.unibz.inf.ontop.model.term.impl.NonGroundFunctionalTermImpl;
import it.unibz.inf.ontop.model.term.impl.NullConstantImpl;
import it.unibz.inf.ontop.model.term.impl.RDFLiteralConstantImpl;
import it.unibz.inf.ontop.model.term.impl.RDFTermTypeConstantImpl;
import it.unibz.inf.ontop.model.term.impl.SimpleProtoSubstitutionImpl;
import it.unibz.inf.ontop.model.term.impl.VariableImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.ProtoSubstitution;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;

@Singleton
public class TermFactoryImpl
implements TermFactory {
    private final TypeFactory typeFactory;
    private final FunctionSymbolFactory functionSymbolFactory;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;
    private final CoreUtilsFactory coreUtilsFactory;
    private final DBConstant valueTrue;
    private final DBConstant valueFalse;
    private final DBConstant lexicalTrue;
    private final DBConstant lexicalFalse;
    private final Constant valueNull;
    @Nullable
    private final DBConstant doubleNaN;
    private final DBConstant provenanceConstant;
    private final Map<RDFTermType, RDFTermTypeConstant> termTypeConstantMap;
    private final RDFTermTypeConstant iriTypeConstant;
    private final RDFTermTypeConstant bnodeTypeConstant;
    private final RDF rdfFactory;
    private final ImmutableExpression.Evaluation positiveEvaluation;
    private final ImmutableExpression.Evaluation negativeEvaluation;
    private final ImmutableExpression.Evaluation nullEvaluation;

    @Inject
    private TermFactoryImpl(TypeFactory typeFactory, FunctionSymbolFactory functionSymbolFactory, DBFunctionSymbolFactory dbFunctionSymbolFactory, CoreUtilsFactory coreUtilsFactory, OntopModelSettings settings, RDF rdfFactory) {
        this.typeFactory = typeFactory;
        this.functionSymbolFactory = functionSymbolFactory;
        this.dbFunctionSymbolFactory = dbFunctionSymbolFactory;
        this.coreUtilsFactory = coreUtilsFactory;
        this.rdfFactory = rdfFactory;
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType dbBooleanType = dbTypeFactory.getDBBooleanType();
        this.valueTrue = new DBConstantImpl(dbTypeFactory.getDBTrueLexicalValue(), dbBooleanType);
        this.valueFalse = new DBConstantImpl(dbTypeFactory.getDBFalseLexicalValue(), dbBooleanType);
        this.lexicalTrue = this.getDBStringConstant("true");
        this.lexicalFalse = this.getDBStringConstant("false");
        this.valueNull = new NullConstantImpl(dbTypeFactory.getNullLexicalValue());
        this.doubleNaN = dbTypeFactory.getDBNaNLexicalValue().map(v -> new DBConstantImpl((String)v, dbTypeFactory.getDBDoubleType())).orElse(null);
        this.provenanceConstant = new DBConstantImpl("ontop-provenance-constant", dbTypeFactory.getDBStringType());
        this.termTypeConstantMap = new HashMap<RDFTermType, RDFTermTypeConstant>();
        this.iriTypeConstant = this.getRDFTermTypeConstant(typeFactory.getIRITermType());
        this.bnodeTypeConstant = this.getRDFTermTypeConstant(typeFactory.getBlankNodeType());
        this.positiveEvaluation = new ImmutableExpressionImpl.ValueEvaluationImpl(ImmutableExpression.Evaluation.BooleanValue.TRUE, this.valueTrue);
        this.negativeEvaluation = new ImmutableExpressionImpl.ValueEvaluationImpl(ImmutableExpression.Evaluation.BooleanValue.FALSE, this.valueFalse);
        this.nullEvaluation = new ImmutableExpressionImpl.ValueEvaluationImpl(ImmutableExpression.Evaluation.BooleanValue.NULL, this.valueNull);
    }

    @Override
    public IRIConstant getConstantIRI(IRI iri) {
        return new IRIConstantImpl(iri, this.typeFactory);
    }

    @Override
    public RDFLiteralConstant getRDFLiteralConstant(String value, RDFDatatype type) {
        return new RDFLiteralConstantImpl(value, type);
    }

    @Override
    public RDFLiteralConstant getRDFLiteralConstant(String value, IRI type) {
        return this.getRDFLiteralConstant(value, this.typeFactory.getDatatype(type));
    }

    @Override
    public RDFLiteralConstant getRDFLiteralConstant(String value, String language) {
        return new RDFLiteralConstantImpl(value, language.toLowerCase(), this.typeFactory);
    }

    @Override
    public RDFConstant getRDFConstant(String lexicalValue, RDFTermType termType) {
        if (termType.isAbstract()) {
            throw new IllegalArgumentException("Cannot create an RDFConstant out of a abstract term type");
        }
        if (termType instanceof RDFDatatype) {
            return this.getRDFLiteralConstant(lexicalValue, (RDFDatatype)termType);
        }
        if (termType.equals(this.typeFactory.getIRITermType())) {
            return this.getConstantIRI(this.rdfFactory.createIRI(lexicalValue));
        }
        if (termType.equals(this.typeFactory.getBlankNodeType())) {
            return this.getConstantBNode(lexicalValue);
        }
        throw new MinorOntopInternalBugException("Unexpected RDF term type: " + termType);
    }

    @Override
    public ImmutableFunctionalTerm getRDFLiteralFunctionalTerm(ImmutableTerm lexicalTerm, RDFDatatype type) {
        return this.getRDFFunctionalTerm(lexicalTerm, this.getRDFTermTypeConstant(type));
    }

    @Override
    public ImmutableFunctionalTerm getRDFLiteralFunctionalTerm(ImmutableTerm lexicalTerm, IRI datatypeIRI) {
        return this.getRDFLiteralFunctionalTerm(lexicalTerm, this.typeFactory.getDatatype(datatypeIRI));
    }

    @Override
    public DBConstant getDBConstant(String value, DBTermType termType) {
        return new DBConstantImpl(value, termType);
    }

    @Override
    public DBConstant getDBStringConstant(String value) {
        return this.getDBConstant(value, this.typeFactory.getDBTypeFactory().getDBStringType());
    }

    @Override
    public ImmutableFunctionalTerm getRDFLiteralFunctionalTerm(ImmutableTerm lexicalTerm, String language) {
        return this.getRDFLiteralFunctionalTerm(lexicalTerm, this.typeFactory.getLangTermType(language));
    }

    @Override
    public Variable getVariable(String name) {
        return new VariableImpl(name);
    }

    @Override
    public RDFTermTypeConstant getRDFTermTypeConstant(RDFTermType type) {
        return this.termTypeConstantMap.computeIfAbsent(type, t -> new RDFTermTypeConstantImpl((RDFTermType)t, this.typeFactory.getMetaRDFTermType()));
    }

    @Override
    public ImmutableFunctionalTerm getRDFTermTypeFunctionalTerm(ImmutableTerm term, TypeConstantDictionary dictionary, ImmutableSet<RDFTermTypeConstant> possibleConstants, boolean isSimplifiable) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.functionSymbolFactory.getRDFTermTypeFunctionSymbol(dictionary, possibleConstants, isSimplifiable), term);
    }

    @Override
    public ImmutableExpression getImmutableExpression(BooleanFunctionSymbol functor, ImmutableTerm ... arguments) {
        return this.getImmutableExpression(functor, (ImmutableList<? extends ImmutableTerm>)ImmutableList.copyOf((Object[])arguments));
    }

    @Override
    public ImmutableExpression getImmutableExpression(BooleanFunctionSymbol functor, ImmutableList<? extends ImmutableTerm> arguments) {
        if (GroundTermTools.areGroundTerms(arguments)) {
            return new GroundExpressionImpl(functor, (ImmutableList<? extends GroundTerm>)arguments, (TermFactory)this);
        }
        return new NonGroundExpressionImpl(functor, arguments, (TermFactory)this);
    }

    @Override
    public ImmutableExpression getConjunction(ImmutableList<ImmutableExpression> conjunctionOfExpressions) {
        int size = conjunctionOfExpressions.size();
        switch (size) {
            case 0: {
                throw new IllegalArgumentException("conjunctionOfExpressions must be non-empty");
            }
            case 1: {
                return (ImmutableExpression)conjunctionOfExpressions.get(0);
            }
        }
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBAnd(size), conjunctionOfExpressions);
    }

    @Override
    public ImmutableExpression getConjunction(ImmutableExpression expression, ImmutableExpression ... otherExpressions) {
        return this.getConjunction((ImmutableList<ImmutableExpression>)((ImmutableList)Stream.concat(Stream.of(expression), Stream.of(otherExpressions)).collect(ImmutableCollectors.toList())));
    }

    @Override
    public Optional<ImmutableExpression> getConjunction(Stream<ImmutableExpression> expressionStream) {
        ImmutableList conjuncts = (ImmutableList)expressionStream.flatMap(ImmutableExpression::flattenAND).distinct().collect(ImmutableCollectors.toList());
        return Optional.of(conjuncts).filter(c -> !c.isEmpty()).map(this::getConjunction);
    }

    @Override
    public ImmutableExpression getDisjunction(ImmutableList<ImmutableExpression> disjunctionOfExpressions) {
        int size = disjunctionOfExpressions.size();
        switch (size) {
            case 0: {
                throw new IllegalArgumentException("disjunctionOfExpressions must be non-empty");
            }
            case 1: {
                return (ImmutableExpression)disjunctionOfExpressions.get(0);
            }
        }
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBOr(size), disjunctionOfExpressions);
    }

    @Override
    public ImmutableExpression getDisjunction(ImmutableExpression expression, ImmutableExpression ... otherExpressions) {
        return this.getDisjunction((ImmutableList<ImmutableExpression>)((ImmutableList)Stream.concat(Stream.of(expression), Stream.of(otherExpressions)).collect(ImmutableCollectors.toList())));
    }

    @Override
    public Optional<ImmutableExpression> getDisjunction(Stream<ImmutableExpression> expressionStream) {
        ImmutableList disjuncts = (ImmutableList)expressionStream.flatMap(ImmutableExpression::flattenOR).distinct().collect(ImmutableCollectors.toList());
        return Optional.of(disjuncts).filter(c -> !c.isEmpty()).map(this::getDisjunction);
    }

    @Override
    public ImmutableExpression getDBNot(ImmutableExpression expression) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBNot(), expression);
    }

    @Override
    public ImmutableExpression getFalseOrNullFunctionalTerm(ImmutableList<ImmutableExpression> arguments) {
        if (arguments.isEmpty()) {
            throw new IllegalArgumentException("Arity must be >= 1");
        }
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getFalseOrNullFunctionSymbol(arguments.size()), arguments);
    }

    @Override
    public ImmutableExpression getTrueOrNullFunctionalTerm(ImmutableList<ImmutableExpression> arguments) {
        if (arguments.isEmpty()) {
            throw new IllegalArgumentException("Arity must be >= 1");
        }
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getTrueOrNullFunctionSymbol(arguments.size()), arguments);
    }

    @Override
    public ImmutableExpression getIsAExpression(ImmutableTerm termTypeTerm, RDFTermType baseType) {
        return this.getImmutableExpression(this.functionSymbolFactory.getIsARDFTermTypeFunctionSymbol(baseType), termTypeTerm);
    }

    @Override
    public ImmutableExpression getAreCompatibleRDFStringExpression(ImmutableTerm typeTerm1, ImmutableTerm typeTerm2) {
        return this.getImmutableExpression(this.functionSymbolFactory.getAreCompatibleRDFStringFunctionSymbol(), typeTerm1, typeTerm2);
    }

    @Override
    public ImmutableExpression.Evaluation getEvaluation(ImmutableExpression expression) {
        return new ImmutableExpressionImpl.ExpressionEvaluationImpl(expression);
    }

    @Override
    public ImmutableExpression.Evaluation getPositiveEvaluation() {
        return this.positiveEvaluation;
    }

    @Override
    public ImmutableExpression.Evaluation getNegativeEvaluation() {
        return this.negativeEvaluation;
    }

    @Override
    public ImmutableExpression.Evaluation getNullEvaluation() {
        return this.nullEvaluation;
    }

    @Override
    public ImmutableFunctionalTerm.FunctionalTermDecomposition getFunctionalTermDecomposition(ImmutableTerm liftableTerm) {
        return new FunctionalTermDecompositionImpl(liftableTerm);
    }

    @Override
    public ImmutableFunctionalTerm.FunctionalTermDecomposition getFunctionalTermDecomposition(ImmutableTerm liftableTerm, ImmutableMap<Variable, ImmutableFunctionalTerm> subTermSubstitutionMap) {
        return subTermSubstitutionMap.isEmpty() ? this.getFunctionalTermDecomposition(liftableTerm) : new FunctionalTermDecompositionImpl(liftableTerm, subTermSubstitutionMap);
    }

    @Override
    public ImmutableFunctionalTerm getImmutableFunctionalTerm(FunctionSymbol functor, ImmutableList<? extends ImmutableTerm> terms) {
        if (functor instanceof BooleanFunctionSymbol) {
            return this.getImmutableExpression((BooleanFunctionSymbol)functor, terms);
        }
        if (GroundTermTools.areGroundTerms(terms)) {
            return new GroundFunctionalTermImpl(terms, functor, (TermFactory)this);
        }
        return new NonGroundFunctionalTermImpl(functor, terms, this);
    }

    @Override
    public ImmutableFunctionalTerm getImmutableFunctionalTerm(FunctionSymbol functor, ImmutableTerm ... terms) {
        return this.getImmutableFunctionalTerm(functor, (ImmutableList<? extends ImmutableTerm>)ImmutableList.copyOf((Object[])terms));
    }

    @Override
    public NonGroundFunctionalTerm getNonGroundFunctionalTerm(FunctionSymbol functor, ImmutableTerm ... terms) {
        return new NonGroundFunctionalTermImpl(this, functor, terms);
    }

    @Override
    public NonGroundFunctionalTerm getNonGroundFunctionalTerm(FunctionSymbol functor, ImmutableList<ImmutableTerm> terms) {
        return new NonGroundFunctionalTermImpl(functor, terms, this);
    }

    @Override
    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public VariableNullability createDummyVariableNullability(ImmutableFunctionalTerm functionalTerm) {
        return this.coreUtilsFactory.createDummyVariableNullability(functionalTerm);
    }

    @Override
    public ImmutableFunctionalTerm getRDFDatatypeStringFunctionalTerm(ImmutableTerm rdfTypeTerm) {
        return this.getImmutableFunctionalTerm(this.functionSymbolFactory.getRDFDatatypeStringFunctionSymbol(), rdfTypeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBUUID(UUID uuid) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBUUID(uuid), new ImmutableTerm[0]);
    }

    @Override
    public ImmutableFunctionalTerm getDBStrBefore(ImmutableTerm arg1, ImmutableTerm arg2) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBStrBefore(), arg1, arg2);
    }

    @Override
    public ImmutableFunctionalTerm getDBStrAfter(ImmutableTerm arg1, ImmutableTerm arg2) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBStrAfter(), arg1, arg2);
    }

    @Override
    public ImmutableFunctionalTerm getDBCharLength(ImmutableTerm stringTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBCharLength(), stringTerm);
    }

    @Override
    public ImmutableExpression getDBIsNull(ImmutableTerm immutableTerm) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBIsNull(), immutableTerm);
    }

    @Override
    public ImmutableExpression getDBIsNotNull(ImmutableTerm immutableTerm) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBIsNotNull(), immutableTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBMd5(ImmutableTerm stringTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBMd5(), stringTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBSha1(ImmutableTerm stringTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBSha1(), stringTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBSha256(ImmutableTerm stringTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBSha256(), stringTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBSha512(ImmutableTerm stringTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBSha512(), stringTerm);
    }

    @Override
    public ImmutableFunctionalTerm getCommonPropagatedOrSubstitutedNumericType(ImmutableTerm rdfTypeTerm1, ImmutableTerm rdfTypeTerm2) {
        return this.getImmutableFunctionalTerm(this.functionSymbolFactory.getCommonPropagatedOrSubstitutedNumericTypeFunctionSymbol(), rdfTypeTerm1, rdfTypeTerm2);
    }

    @Override
    public DBFunctionSymbolFactory getDBFunctionSymbolFactory() {
        return this.dbFunctionSymbolFactory;
    }

    @Override
    public <T extends ImmutableTerm> ProtoSubstitution<T> getProtoSubstitution(ImmutableMap<Variable, T> map) {
        return new SimpleProtoSubstitutionImpl<T>(map, this);
    }

    @Override
    public ImmutableFunctionalTerm getBinaryNumericLexicalFunctionalTerm(String dbNumericOperationName, ImmutableTerm lexicalTerm1, ImmutableTerm lexicalTerm2, ImmutableTerm rdfTypeTerm) {
        return this.getImmutableFunctionalTerm(this.functionSymbolFactory.getBinaryNumericLexicalFunctionSymbol(dbNumericOperationName), lexicalTerm1, lexicalTerm2, rdfTypeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBBinaryNumericFunctionalTerm(String dbNumericOperationName, DBTermType dbNumericType, ImmutableTerm dbTerm1, ImmutableTerm dbTerm2) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBMathBinaryOperator(dbNumericOperationName, dbNumericType), dbTerm1, dbTerm2);
    }

    @Override
    public ImmutableFunctionalTerm getUnaryLatelyTypedFunctionalTerm(ImmutableTerm lexicalTerm, ImmutableTerm inputRDFTypeTerm, DBTermType targetType, Function<DBTermType, DBFunctionSymbol> dbFunctionSymbolFct) {
        return this.getImmutableFunctionalTerm(this.functionSymbolFactory.getUnaryLatelyTypedFunctionSymbol(dbFunctionSymbolFct, targetType), lexicalTerm, inputRDFTypeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getUnaryLexicalFunctionalTerm(ImmutableTerm lexicalTerm, ImmutableTerm rdfDatatypeTerm, Function<DBTermType, DBFunctionSymbol> dbFunctionSymbolFct) {
        return this.getImmutableFunctionalTerm(this.functionSymbolFactory.getUnaryLexicalFunctionSymbol(dbFunctionSymbolFct), lexicalTerm, rdfDatatypeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getSPARQLNonStrictEquality(ImmutableTerm rdfTerm1, ImmutableTerm rdfTerm2) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.functionSymbolFactory.getRequiredSPARQLFunctionSymbol("=", 2), rdfTerm1, rdfTerm2);
    }

    @Override
    public ImmutableFunctionalTerm getSPARQLEffectiveBooleanValue(ImmutableTerm rdfTerm) {
        return this.getImmutableFunctionalTerm(this.functionSymbolFactory.getSPARQLEffectiveBooleanValueFunctionSymbol(), rdfTerm);
    }

    @Override
    public ImmutableExpression getLexicalEffectiveBooleanValue(ImmutableTerm lexicalTerm, ImmutableTerm rdfDatatypeTerm) {
        return this.getImmutableExpression(this.functionSymbolFactory.getLexicalEBVFunctionSymbol(), lexicalTerm, rdfDatatypeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBRand(UUID uuid) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBRand(uuid), new ImmutableTerm[0]);
    }

    @Override
    public ImmutableFunctionalTerm getDBYearFromDatetime(ImmutableTerm dbDatetimeTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBYearFromDatetime(), dbDatetimeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBMonthFromDatetime(ImmutableTerm dbDatetimeTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBMonthFromDatetime(), dbDatetimeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBDayFromDatetime(ImmutableTerm dbDatetimeTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBDayFromDatetime(), dbDatetimeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBHours(ImmutableTerm dbDatetimeTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBHours(), dbDatetimeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBMinutes(ImmutableTerm dbDatetimeTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBMinutes(), dbDatetimeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBSeconds(ImmutableTerm dbDatetimeTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBSeconds(), dbDatetimeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBTz(ImmutableTerm dbDatetimeTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBTz(), dbDatetimeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBNow() {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBNow(), new ImmutableTerm[0]);
    }

    @Override
    public ImmutableFunctionalTerm getDBCount(boolean isDistinct) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBCount(0, isDistinct), new ImmutableTerm[0]);
    }

    @Override
    public ImmutableFunctionalTerm getDBCount(ImmutableTerm term, boolean isDistinct) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBCount(1, isDistinct), term);
    }

    @Override
    public ImmutableFunctionalTerm getDBSum(ImmutableTerm subTerm, DBTermType dbType, boolean isDistinct) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getNullIgnoringDBSum(dbType, isDistinct), subTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBAvg(ImmutableTerm subTerm, DBTermType dbType, boolean isDistinct) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getNullIgnoringDBAvg(dbType, isDistinct), subTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBMin(ImmutableTerm subTerm, DBTermType dbType) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBMin(dbType), subTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBMax(ImmutableTerm subTerm, DBTermType dbType) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBMax(dbType), subTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBGroupConcat(ImmutableTerm subTerm, String separator, boolean isDistinct) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getNullIgnoringDBGroupConcat(isDistinct), subTerm, this.getDBStringConstant(separator));
    }

    @Override
    public ImmutableExpression getNotYetTypedEquality(ImmutableTerm t1, ImmutableTerm t2) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.functionSymbolFactory.getNotYetTypedEquality(), t1, t2);
    }

    @Override
    public ImmutableExpression getLexicalNonStrictEquality(ImmutableTerm lexicalTerm1, ImmutableTerm typeTerm1, ImmutableTerm lexicalTerm2, ImmutableTerm typeTerm2) {
        return this.getImmutableExpression(this.functionSymbolFactory.getLexicalNonStrictEqualityFunctionSymbol(), lexicalTerm1, typeTerm1, lexicalTerm2, typeTerm2);
    }

    @Override
    public ImmutableExpression getLexicalInequality(InequalityLabel inequalityLabel, ImmutableTerm lexicalTerm1, ImmutableTerm typeTerm1, ImmutableTerm lexicalTerm2, ImmutableTerm typeTerm2) {
        return this.getImmutableExpression(this.functionSymbolFactory.getLexicalInequalityFunctionSymbol(inequalityLabel), lexicalTerm1, typeTerm1, lexicalTerm2, typeTerm2);
    }

    @Override
    public ImmutableExpression getDBNonStrictNumericEquality(ImmutableTerm dbNumericTerm1, ImmutableTerm dbNumericTerm2) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBNonStrictNumericEquality(), dbNumericTerm1, dbNumericTerm2);
    }

    @Override
    public ImmutableExpression getDBNonStrictStringEquality(ImmutableTerm dbStringTerm1, ImmutableTerm dbStringTerm2) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBNonStrictStringEquality(), dbStringTerm1, dbStringTerm2);
    }

    @Override
    public ImmutableExpression getDBNonStrictDatetimeEquality(ImmutableTerm dbDatetimeTerm1, ImmutableTerm dbDatetimeTerm2) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBNonStrictDatetimeEquality(), dbDatetimeTerm1, dbDatetimeTerm2);
    }

    @Override
    public ImmutableExpression getDBNonStrictDateEquality(ImmutableTerm dbTerm1, ImmutableTerm dbTerm2) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBNonStrictDateEquality(), dbTerm1, dbTerm2);
    }

    @Override
    public ImmutableExpression getDBNonStrictDefaultEquality(ImmutableTerm term1, ImmutableTerm term2) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBNonStrictDefaultEquality(), term1, term2);
    }

    @Override
    public ImmutableExpression getDBNumericInequality(InequalityLabel inequalityLabel, ImmutableTerm dbNumericTerm1, ImmutableTerm dbNumericTerm2) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBNumericInequality(inequalityLabel), dbNumericTerm1, dbNumericTerm2);
    }

    @Override
    public ImmutableExpression getDBBooleanInequality(InequalityLabel inequalityLabel, ImmutableTerm dbBooleanTerm1, ImmutableTerm dbBooleanTerm2) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBBooleanInequality(inequalityLabel), dbBooleanTerm1, dbBooleanTerm2);
    }

    @Override
    public ImmutableExpression getDBStringInequality(InequalityLabel inequalityLabel, ImmutableTerm dbStringTerm1, ImmutableTerm dbStringTerm2) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBStringInequality(inequalityLabel), dbStringTerm1, dbStringTerm2);
    }

    @Override
    public ImmutableExpression getDBDatetimeInequality(InequalityLabel inequalityLabel, ImmutableTerm dbDatetimeTerm1, ImmutableTerm dbDatetimeTerm2) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBDatetimeInequality(inequalityLabel), dbDatetimeTerm1, dbDatetimeTerm2);
    }

    @Override
    public ImmutableExpression getDBDateInequality(InequalityLabel inequalityLabel, ImmutableTerm dbDateTerm1, ImmutableTerm dbDateTerm2) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBDateInequality(inequalityLabel), dbDateTerm1, dbDateTerm2);
    }

    @Override
    public ImmutableExpression getDBDefaultInequality(InequalityLabel inequalityLabel, ImmutableTerm dbTerm1, ImmutableTerm dbTerm2) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBDefaultInequality(inequalityLabel), dbTerm1, dbTerm2);
    }

    @Override
    public BNode getConstantBNode(String name) {
        return new BNodeConstantImpl(name, this.typeFactory);
    }

    @Override
    public DBConstant getDBBooleanConstant(boolean value) {
        return value ? this.valueTrue : this.valueFalse;
    }

    @Override
    public DBConstant getXsdBooleanLexicalConstant(boolean value) {
        return value ? this.lexicalTrue : this.lexicalFalse;
    }

    @Override
    public Constant getNullConstant() {
        return this.valueNull;
    }

    @Override
    public ImmutableFunctionalTerm getTypedNull(DBTermType termType) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getTypedNullFunctionSymbol(termType), new ImmutableTerm[0]);
    }

    @Override
    public DBConstant getDBIntegerConstant(int value) {
        return this.getDBConstant(String.format("%d", value), this.typeFactory.getDBTypeFactory().getDBLargeIntegerType());
    }

    @Override
    public Optional<DBConstant> getDoubleNaN() {
        return Optional.ofNullable(this.doubleNaN);
    }

    @Override
    public DBConstant getProvenanceSpecialConstant() {
        return this.provenanceConstant;
    }

    @Override
    public ImmutableFunctionalTerm getRDFFunctionalTerm(ImmutableTerm lexicalTerm, ImmutableTerm typeTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.functionSymbolFactory.getRDFTermFunctionSymbol(), lexicalTerm, typeTerm);
    }

    @Override
    public ImmutableFunctionalTerm getIRIFunctionalTerm(Variable variable, boolean temporaryCastToString) {
        Variable lexicalTerm = temporaryCastToString ? this.getPartiallyDefinedToStringCast(variable) : variable;
        return this.getRDFFunctionalTerm(lexicalTerm, this.iriTypeConstant);
    }

    @Override
    public ImmutableFunctionalTerm getIRIFunctionalTerm(String iriTemplate, ImmutableList<? extends ImmutableTerm> arguments) {
        if (arguments.isEmpty()) {
            throw new IllegalArgumentException("At least one argument for the IRI functional term with an IRI template is required");
        }
        IRIStringTemplateFunctionSymbol templateFunctionSymbol = this.dbFunctionSymbolFactory.getIRIStringTemplateFunctionSymbol(iriTemplate);
        ImmutableFunctionalTerm templateFunctionalTerm = this.getImmutableFunctionalTerm((FunctionSymbol)templateFunctionSymbol, arguments);
        return this.getRDFFunctionalTerm(templateFunctionalTerm, this.iriTypeConstant);
    }

    @Override
    public ImmutableFunctionalTerm getIRIFunctionalTerm(IRIStringTemplateFunctionSymbol templateSymbol, ImmutableList<DBConstant> arguments) {
        ImmutableFunctionalTerm lexicalTerm = this.getImmutableFunctionalTerm((FunctionSymbol)templateSymbol, arguments);
        return this.getRDFFunctionalTerm(lexicalTerm, this.iriTypeConstant);
    }

    @Override
    public ImmutableFunctionalTerm getBnodeFunctionalTerm(String bnodeTemplate, ImmutableList<? extends ImmutableTerm> arguments) {
        ImmutableFunctionalTerm lexicalTerm = this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getBnodeStringTemplateFunctionSymbol(bnodeTemplate), arguments);
        return this.getRDFFunctionalTerm(lexicalTerm, this.bnodeTypeConstant);
    }

    @Override
    public ImmutableFunctionalTerm getFreshBnodeFunctionalTerm(ImmutableList<ImmutableTerm> arguments) {
        ImmutableFunctionalTerm lexicalTerm = this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getFreshBnodeStringTemplateFunctionSymbol(arguments.size()), arguments);
        return this.getRDFFunctionalTerm(lexicalTerm, this.bnodeTypeConstant);
    }

    @Override
    public ImmutableFunctionalTerm getDBCastFunctionalTerm(DBTermType targetType, ImmutableTerm term) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBCastFunctionSymbol(targetType), term);
    }

    @Override
    public ImmutableFunctionalTerm getDBCastFunctionalTerm(DBTermType inputType, DBTermType targetType, ImmutableTerm term) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBCastFunctionSymbol(inputType, targetType), term);
    }

    @Override
    public ImmutableFunctionalTerm getDBIntIndex(ImmutableTerm idTerm, ImmutableTerm ... possibleValues) {
        ImmutableList.Builder argumentBuilder = ImmutableList.builder();
        argumentBuilder.add((Object)idTerm);
        argumentBuilder.addAll((Iterable)ImmutableList.copyOf((Object[])possibleValues));
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBIntIndex(possibleValues.length), (ImmutableList<? extends ImmutableTerm>)argumentBuilder.build());
    }

    @Override
    public ImmutableFunctionalTerm getDBIntIndex(ImmutableTerm idTerm, ImmutableList<ImmutableTerm> possibleValues) {
        ImmutableList.Builder argumentBuilder = ImmutableList.builder();
        argumentBuilder.add((Object)idTerm);
        argumentBuilder.addAll(possibleValues);
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBIntIndex(possibleValues.size()), (ImmutableList<? extends ImmutableTerm>)argumentBuilder.build());
    }

    @Override
    public ImmutableFunctionalTerm getConversion2RDFLexical(DBTermType inputType, ImmutableTerm term, RDFTermType rdfTermType) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getConversion2RDFLexicalFunctionSymbol(inputType, rdfTermType), term);
    }

    @Override
    public ImmutableFunctionalTerm getConversion2RDFLexical(ImmutableTerm dbTerm, RDFTermType rdfType) {
        return this.getConversion2RDFLexical(rdfType.getClosestDBType(this.typeFactory.getDBTypeFactory()), dbTerm, rdfType);
    }

    @Override
    public ImmutableFunctionalTerm getConversionFromRDFLexical2DB(DBTermType targetDBType, ImmutableTerm dbTerm, RDFTermType rdfType) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getConversionFromRDFLexical2DBFunctionSymbol(targetDBType, rdfType), dbTerm);
    }

    @Override
    public ImmutableFunctionalTerm getConversionFromRDFLexical2DB(ImmutableTerm dbTerm, RDFTermType rdfType) {
        return this.getConversionFromRDFLexical2DB(rdfType.getClosestDBType(this.typeFactory.getDBTypeFactory()), dbTerm, rdfType);
    }

    @Override
    public ImmutableFunctionalTerm getPartiallyDefinedToStringCast(Variable variable) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getTemporaryConversionToDBStringFunctionSymbol(), variable);
    }

    @Override
    public ImmutableExpression getRDF2DBBooleanFunctionalTerm(ImmutableTerm xsdBooleanTerm) {
        return this.getImmutableExpression(this.functionSymbolFactory.getRDF2DBBooleanFunctionSymbol(), xsdBooleanTerm);
    }

    @Override
    public ImmutableFunctionalTerm getIfElseNull(ImmutableExpression condition, ImmutableTerm term) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBIfElseNull(), condition, term);
    }

    @Override
    public ImmutableExpression getBooleanIfElseNull(ImmutableExpression condition, ImmutableExpression thenExpression) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBBooleanIfElseNull(), condition, thenExpression);
    }

    @Override
    public ImmutableFunctionalTerm getIfThenElse(ImmutableExpression condition, ImmutableTerm thenTerm, ImmutableTerm elseTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBIfThenElse(), condition, thenTerm, elseTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBCase(Stream<? extends Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> whenPairs, ImmutableTerm defaultTerm, boolean doOrderingMatter) {
        ImmutableList terms = (ImmutableList)Stream.concat(whenPairs.flatMap(e -> Stream.of((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue())), Stream.of(defaultTerm)).collect(ImmutableCollectors.toList());
        int arity = terms.size();
        if (arity < 3) {
            throw new IllegalArgumentException("whenPairs must be non-empty");
        }
        if (arity == 3) {
            return defaultTerm.equals(this.valueNull) ? this.getIfElseNull((ImmutableExpression)terms.get(0), (ImmutableTerm)terms.get(1)) : this.getIfThenElse((ImmutableExpression)terms.get(0), (ImmutableTerm)terms.get(1), defaultTerm);
        }
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBCase(arity, doOrderingMatter), (ImmutableList<? extends ImmutableTerm>)terms);
    }

    @Override
    public ImmutableFunctionalTerm getDBCaseElseNull(Stream<? extends Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> whenPairs, boolean doOrderingMatter) {
        return this.getDBCase(whenPairs, this.valueNull, doOrderingMatter);
    }

    @Override
    public ImmutableExpression getDBBooleanCase(Stream<Map.Entry<ImmutableExpression, ImmutableExpression>> whenPairs, ImmutableExpression defaultExpression, boolean doOrderingMatter) {
        ImmutableList terms = (ImmutableList)Stream.concat(whenPairs.flatMap(e -> Stream.of((ImmutableExpression)e.getKey(), (ImmutableExpression)e.getValue())), Stream.of(defaultExpression)).collect(ImmutableCollectors.toList());
        int arity = terms.size();
        if (arity < 3) {
            throw new IllegalArgumentException("whenPairs must be non-empty");
        }
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBBooleanCase(arity, doOrderingMatter), (ImmutableList<? extends ImmutableTerm>)terms);
    }

    @Override
    public ImmutableFunctionalTerm getDBCoalesce(ImmutableTerm term1, ImmutableTerm term2, ImmutableTerm ... terms) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)term1);
        builder.add((Object)term2);
        builder.addAll((Iterable)ImmutableList.copyOf((Object[])terms));
        return this.getDBCoalesce((ImmutableList<ImmutableTerm>)builder.build());
    }

    @Override
    public ImmutableFunctionalTerm getDBCoalesce(ImmutableList<ImmutableTerm> terms) {
        if (terms.size() < 1) {
            throw new IllegalArgumentException("At least one argument is expected");
        }
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBCoalesce(terms.size()), terms);
    }

    @Override
    public ImmutableFunctionalTerm getDBReplace(ImmutableTerm text, ImmutableTerm from, ImmutableTerm to) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBReplace(), text, from, to);
    }

    @Override
    public ImmutableFunctionalTerm getDBRegexpReplace(ImmutableTerm text, ImmutableTerm from, ImmutableTerm to) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBRegexpReplace3(), text, from, to);
    }

    @Override
    public ImmutableFunctionalTerm getDBRegexpReplace(ImmutableTerm arg, ImmutableTerm pattern, ImmutableTerm replacement, ImmutableTerm flags) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBRegexpReplace4(), arg, pattern, replacement, flags);
    }

    @Override
    public ImmutableExpression getDBStartsWith(ImmutableList<ImmutableTerm> terms) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBStartsWith(), terms);
    }

    @Override
    public ImmutableExpression getDBEndsWith(ImmutableList<? extends ImmutableTerm> terms) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBEndsWith(), terms);
    }

    @Override
    public ImmutableExpression getDBContains(ImmutableList<? extends ImmutableTerm> terms) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBContains(), terms);
    }

    @Override
    public ImmutableExpression getDBRegexpMatches(ImmutableList<ImmutableTerm> terms) {
        int arity = terms.size();
        if (arity < 2 || arity > 3) {
            throw new IllegalArgumentException("Arity must be 2 or 3");
        }
        DBBooleanFunctionSymbol functionSymbol = arity == 2 ? this.dbFunctionSymbolFactory.getDBRegexpMatches2() : this.dbFunctionSymbolFactory.getDBRegexpMatches3();
        return this.getImmutableExpression((BooleanFunctionSymbol)functionSymbol, terms);
    }

    @Override
    public ImmutableFunctionalTerm getR2RMLIRISafeEncodeFunctionalTerm(ImmutableTerm term) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getR2RMLIRISafeEncode(), term);
    }

    @Override
    public ImmutableFunctionalTerm getNullRejectingDBConcatFunctionalTerm(ImmutableList<? extends ImmutableTerm> terms) {
        int arity = terms.size();
        if (arity < 2) {
            throw new IllegalArgumentException("String concatenation needs at least two arguments");
        }
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getNullRejectingDBConcat(arity), terms);
    }

    @Override
    public ImmutableFunctionalTerm getCommonDenominatorFunctionalTerm(ImmutableList<ImmutableTerm> typeTerms) {
        int arity = typeTerms.size();
        if (arity < 2) {
            throw new IllegalArgumentException("Expected arity >= 2 for a common denominator");
        }
        return this.getImmutableFunctionalTerm(this.functionSymbolFactory.getCommonDenominatorFunctionSymbol(arity), typeTerms);
    }

    @Override
    public ImmutableExpression getStrictEquality(ImmutableSet<ImmutableTerm> terms) {
        if (terms.size() < 2) {
            throw new IllegalArgumentException("At least two distinct values where expected in " + terms);
        }
        return this.getStrictEquality((ImmutableList<? extends ImmutableTerm>)ImmutableList.copyOf(terms));
    }

    @Override
    public ImmutableExpression getStrictEquality(ImmutableList<? extends ImmutableTerm> terms) {
        if (terms.size() < 2) {
            throw new IllegalArgumentException("At least two values where expected in " + terms);
        }
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBStrictEquality(terms.size()), terms);
    }

    @Override
    public ImmutableExpression getStrictEquality(ImmutableTerm term1, ImmutableTerm term2, ImmutableTerm ... otherTerms) {
        return this.getStrictEquality((ImmutableList<? extends ImmutableTerm>)((ImmutableList)Stream.concat(Stream.of(term1, term2), Stream.of(otherTerms)).collect(ImmutableCollectors.toList())));
    }

    @Override
    public ImmutableExpression getStrictNEquality(ImmutableSet<ImmutableTerm> terms) {
        if (terms.size() < 2) {
            throw new IllegalArgumentException("At least two distinct values where expected in " + terms);
        }
        return this.getStrictNEquality((ImmutableList<? extends ImmutableTerm>)ImmutableList.copyOf(terms));
    }

    @Override
    public ImmutableExpression getDBIsStringEmpty(ImmutableTerm stringTerm) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBIsStringEmpty(), stringTerm);
    }

    @Override
    public ImmutableExpression getStrictNEquality(ImmutableList<? extends ImmutableTerm> terms) {
        if (terms.size() < 2) {
            throw new IllegalArgumentException("At least two values where expected in " + terms);
        }
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getDBStrictNEquality(terms.size()), terms);
    }

    @Override
    public ImmutableExpression getStrictNEquality(ImmutableTerm term1, ImmutableTerm term2, ImmutableTerm ... otherTerms) {
        return this.getStrictNEquality((ImmutableList<? extends ImmutableTerm>)((ImmutableList)Stream.concat(Stream.of(term1, term2), Stream.of(otherTerms)).collect(ImmutableCollectors.toList())));
    }

    @Override
    public ImmutableExpression getIsTrue(NonFunctionalTerm dbBooleanTerm) {
        return this.getImmutableExpression((BooleanFunctionSymbol)this.dbFunctionSymbolFactory.getIsTrue(), dbBooleanTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBSubString2(ImmutableTerm stringTerm, ImmutableTerm from) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBSubString2(), stringTerm, from);
    }

    @Override
    public ImmutableFunctionalTerm getDBSubString3(ImmutableTerm stringTerm, ImmutableTerm from, ImmutableTerm to) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBSubString3(), stringTerm, from, to);
    }

    @Override
    public ImmutableFunctionalTerm getDBRight(ImmutableTerm stringTerm, ImmutableTerm lengthTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBRight(), stringTerm, lengthTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBUpper(ImmutableTerm stringTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBUpper(), stringTerm);
    }

    @Override
    public ImmutableFunctionalTerm getDBLower(ImmutableTerm stringTerm) {
        return this.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFactory.getDBLower(), stringTerm);
    }

    @Override
    public ImmutableFunctionalTerm getLangTypeFunctionalTerm(ImmutableTerm rdfTypeTerm) {
        return this.getImmutableFunctionalTerm(this.functionSymbolFactory.getLangTagFunctionSymbol(), rdfTypeTerm);
    }

    @Override
    public ImmutableExpression getLexicalLangMatches(ImmutableTerm langTagTerm, ImmutableTerm langRangeTerm) {
        return this.getImmutableExpression(this.functionSymbolFactory.getLexicalLangMatches(), langTagTerm, langRangeTerm);
    }
}

