/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.impl.AbstractProtoSubstitution;

public class SimpleProtoSubstitutionImpl<T extends ImmutableTerm>
extends AbstractProtoSubstitution<T> {
    private final ImmutableMap<Variable, T> map;

    protected SimpleProtoSubstitutionImpl(ImmutableMap<Variable, ? extends T> substitutionMap, TermFactory termFactory) {
        super(termFactory);
        this.map = substitutionMap;
        if (substitutionMap.entrySet().stream().anyMatch(e -> ((Variable)e.getKey()).equals(e.getValue()))) {
            throw new IllegalArgumentException("Please do not insert entries like t/t in your substitution (for efficiency reasons)\n. Proto-substitution: " + substitutionMap);
        }
    }

    @Override
    public T get(Variable var) {
        return (T)((ImmutableTerm)this.map.get((Object)var));
    }

    @Override
    public ImmutableMap<Variable, T> getImmutableMap() {
        return this.map;
    }

    @Override
    public boolean isDefining(Variable variable) {
        return this.map.containsKey((Object)variable);
    }

    @Override
    public ImmutableSet<Variable> getDomain() {
        return this.map.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public ImmutableTerm applyToVariable(Variable variable) {
        ImmutableTerm v = (ImmutableTerm)this.map.get((Object)variable);
        return v == null ? variable : v;
    }
}

