/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.request.DefinitionPushDownRequest;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.SPARQLAggregationFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;

public abstract class UnaryNumericSPARQLAggregationFunctionSymbolImpl
extends SPARQLFunctionSymbolImpl
implements SPARQLAggregationFunctionSymbol {
    private final boolean isDistinct;
    private final String defaultAggVariableName;

    public UnaryNumericSPARQLAggregationFunctionSymbolImpl(String name, String officialName, boolean isDistinct, RDFTermType rootRdfTermType, String defaultAggVariableName) {
        super(name, officialName, (ImmutableList<TermType>)ImmutableList.of((Object)rootRdfTermType));
        this.isDistinct = isDistinct;
        this.defaultAggVariableName = defaultAggVariableName;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public boolean isAggregation() {
        return true;
    }

    @Override
    protected boolean tolerateNulls() {
        return true;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.empty();
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    public boolean isNullable(ImmutableSet<Integer> nullableIndexes) {
        return true;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm newTerm = (ImmutableTerm)newTerms.get(0);
        return newTerm.isNull() ? this.evaluateEmptyBag(termFactory) : super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability);
    }

    @Override
    public Optional<SPARQLAggregationFunctionSymbol.AggregationSimplification> decomposeIntoDBAggregation(ImmutableList<? extends ImmutableTerm> subTerms, ImmutableList<ImmutableSet<RDFTermType>> possibleRDFTypes, boolean hasGroupBy, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        if (possibleRDFTypes.size() != this.getArity()) {
            throw new IllegalArgumentException("The size of possibleRDFTypes is expected to match the arity of the function symbol");
        }
        ImmutableTerm subTerm = (ImmutableTerm)subTerms.get(0);
        ImmutableSet subTermPossibleTypes = (ImmutableSet)possibleRDFTypes.get(0);
        switch (subTermPossibleTypes.size()) {
            case 0: {
                throw new MinorOntopInternalBugException("At least one RDF type was expected to be inferred for the first sub-term");
            }
            case 1: {
                return Optional.of(this.decomposeUnityped(subTerm, (RDFTermType)subTermPossibleTypes.iterator().next(), hasGroupBy, variableNullability, variableGenerator, termFactory));
            }
        }
        return Optional.of(this.decomposeMultityped(subTerm, (ImmutableSet<RDFTermType>)subTermPossibleTypes, hasGroupBy, variableNullability, variableGenerator, termFactory));
    }

    protected SPARQLAggregationFunctionSymbol.AggregationSimplification decomposeUnityped(ImmutableTerm subTerm, RDFTermType subTermType, boolean hasGroupBy, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        if (!(subTermType instanceof ConcreteNumericRDFDatatype)) {
            return this.decomposeMultityped(subTerm, (ImmutableSet<RDFTermType>)ImmutableSet.of((Object)subTermType), hasGroupBy, variableNullability, variableGenerator, termFactory);
        }
        ConcreteNumericRDFDatatype inputNumericDatatype = (ConcreteNumericRDFDatatype)subTermType;
        ImmutableTerm subTermLexicalTerm = this.extractLexicalTerm(subTerm, termFactory);
        TypeFactory typeFactory = termFactory.getTypeFactory();
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        ImmutableFunctionalTerm dbAggTerm = this.createAggregate(inputNumericDatatype, termFactory.getConversionFromRDFLexical2DB(subTermLexicalTerm, inputNumericDatatype), termFactory);
        ConcreteNumericRDFDatatype inferredTypeWhenNonEmpty = this.inferTypeWhenNonEmpty(inputNumericDatatype, typeFactory);
        RDFTermTypeConstant inferredTypeTermWhenNonEmpty = termFactory.getRDFTermTypeConstant(inferredTypeWhenNonEmpty);
        Variable dbAggregationVariable = variableGenerator.generateNewVariable(this.defaultAggVariableName);
        boolean isSubTermNullable = subTermLexicalTerm.isNullable(variableNullability.getNullableVariables());
        DBConstant zero = termFactory.getDBConstant("0", dbTypeFactory.getDBLargeIntegerType());
        boolean dbAggMayReturnNull = !hasGroupBy || isSubTermNullable;
        Variable nonNullDBAggregate = dbAggMayReturnNull ? termFactory.getDBCoalesce(dbAggregationVariable, zero, new ImmutableTerm[0]) : dbAggregationVariable;
        RDFTermTypeConstant inferredType = dbAggMayReturnNull ? termFactory.getIfThenElse(termFactory.getDBIsNotNull(dbAggregationVariable), inferredTypeTermWhenNonEmpty, termFactory.getRDFTermTypeConstant(typeFactory.getXsdIntegerDatatype())) : inferredTypeTermWhenNonEmpty;
        ImmutableFunctionalTerm liftedTerm = termFactory.getRDFFunctionalTerm(termFactory.getConversion2RDFLexical(nonNullDBAggregate, inferredTypeWhenNonEmpty), inferredType);
        ImmutableFunctionalTerm.FunctionalTermDecomposition decomposition = termFactory.getFunctionalTermDecomposition(liftedTerm, (ImmutableMap<Variable, ImmutableFunctionalTerm>)ImmutableMap.of((Object)dbAggregationVariable, (Object)dbAggTerm));
        return SPARQLAggregationFunctionSymbol.AggregationSimplification.create(decomposition);
    }

    protected abstract ConcreteNumericRDFDatatype inferTypeWhenNonEmpty(ConcreteNumericRDFDatatype var1, TypeFactory var2);

    protected abstract SPARQLAggregationFunctionSymbol.AggregationSimplification decomposeMultityped(ImmutableTerm var1, ImmutableSet<RDFTermType> var2, boolean var3, VariableNullability var4, VariableGenerator var5, TermFactory var6);

    protected abstract ImmutableFunctionalTerm createAggregate(ConcreteNumericRDFDatatype var1, ImmutableTerm var2, TermFactory var3);

    protected DefinitionPushDownRequest createNonNumericRequest(ImmutableTerm subTermTypeTerm, Variable nonNumericVariable, ImmutableSet<RDFTermType> nonNumericTypes, TermFactory termFactory) {
        DBConstant definition = termFactory.getDBBooleanConstant(true);
        ImmutableExpression condition = termFactory.getDisjunction(nonNumericTypes.stream().map(t -> termFactory.getStrictEquality(subTermTypeTerm, termFactory.getRDFTermTypeConstant((RDFTermType)t), new ImmutableTerm[0]))).orElseThrow(() -> new MinorOntopInternalBugException("At least one type was expected"));
        return DefinitionPushDownRequest.create(nonNumericVariable, definition, condition);
    }

    protected ImmutableSet<RDFTermType> extractNonNumericTypes(ImmutableSet<RDFTermType> subTermPossibleTypes) {
        return (ImmutableSet)subTermPossibleTypes.stream().filter(t -> !(t instanceof ConcreteNumericRDFDatatype)).collect(ImmutableCollectors.toSet());
    }
}

