/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.BooleanFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;

public class IsARDFTermTypeFunctionSymbolImpl
extends BooleanFunctionSymbolImpl {
    private final RDFTermType baseType;

    protected IsARDFTermTypeFunctionSymbolImpl(MetaRDFTermType metaRDFTermType, DBTermType dbBooleanTermType, RDFTermType baseType) {
        super("IS_A_" + baseType.toString().toUpperCase(), (ImmutableList<TermType>)ImmutableList.of((Object)metaRDFTermType), dbBooleanTermType);
        this.baseType = baseType;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm subTerm = (ImmutableTerm)newTerms.get(0);
        if (subTerm instanceof RDFTermTypeConstant) {
            RDFTermType firstType = ((RDFTermTypeConstant)subTerm).getRDFTermType();
            return termFactory.getDBBooleanConstant(firstType.isA(this.baseType));
        }
        if (subTerm instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)subTerm).getFunctionSymbol() instanceof RDFTermTypeFunctionSymbol) {
            ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)subTerm;
            ImmutableBiMap<DBConstant, RDFTermTypeConstant> conversionMap = ((RDFTermTypeFunctionSymbol)functionalTerm.getFunctionSymbol()).getConversionMap();
            return this.simplifyIntoConjunction((ImmutableMap<DBConstant, RDFTermTypeConstant>)conversionMap, functionalTerm.getTerm(0), termFactory, variableNullability);
        }
        return super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability);
    }

    private ImmutableTerm simplifyIntoConjunction(ImmutableMap<DBConstant, RDFTermTypeConstant> conversionMap, ImmutableTerm term, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableSet excludedMagicNumbers = (ImmutableSet)conversionMap.entrySet().stream().filter(e -> !((RDFTermTypeConstant)e.getValue()).getRDFTermType().isA(this.baseType)).map(Map.Entry::getKey).map(n -> termFactory.getStrictNEquality(term, (ImmutableTerm)n, new ImmutableTerm[0])).collect(ImmutableCollectors.toSet());
        if (excludedMagicNumbers.size() == conversionMap.size()) {
            return termFactory.getFalseOrNullFunctionalTerm((ImmutableList<ImmutableExpression>)ImmutableList.of((Object)termFactory.getDBIsNull(term))).simplify(variableNullability);
        }
        if (excludedMagicNumbers.isEmpty()) {
            return termFactory.getTrueOrNullFunctionalTerm((ImmutableList<ImmutableExpression>)ImmutableList.of((Object)termFactory.getDBIsNotNull(term))).simplify(variableNullability);
        }
        return termFactory.getConjunction(excludedMagicNumbers.stream()).orElseThrow(() -> new MinorOntopInternalBugException("The empty case should have already captured")).simplify(variableNullability);
    }

    @Override
    public boolean blocksNegation() {
        return true;
    }

    @Override
    public ImmutableExpression negate(ImmutableList<? extends ImmutableTerm> subTerms, TermFactory termFactory) {
        return termFactory.getDBNot(termFactory.getImmutableExpression((BooleanFunctionSymbol)this, subTerms));
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }
}

