/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.SPARQLAggregationFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;

public class CountSPARQLFunctionSymbolImpl
extends SPARQLFunctionSymbolImpl
implements SPARQLAggregationFunctionSymbol {
    private final RDFDatatype xsdIntegerType;
    private final boolean isDistinct;

    protected CountSPARQLFunctionSymbolImpl(RDFTermType rootRdfTermType, RDFDatatype xsdIntegerType, boolean isDistinct) {
        super("SP_COUNT_1" + (isDistinct ? "_DISTINCT" : ""), "COUNT", (ImmutableList<TermType>)ImmutableList.of((Object)rootRdfTermType));
        this.xsdIntegerType = xsdIntegerType;
        this.isDistinct = isDistinct;
    }

    protected CountSPARQLFunctionSymbolImpl(RDFDatatype xsdIntegerType, boolean isDistinct) {
        super("SP_COUNT_0" + (isDistinct ? "_DISTINCT" : ""), "COUNT", (ImmutableList<TermType>)ImmutableList.of());
        this.xsdIntegerType = xsdIntegerType;
        this.isDistinct = isDistinct;
    }

    @Override
    protected boolean tolerateNulls() {
        return true;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.xsdIntegerType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    public boolean isNullable(ImmutableSet<Integer> nullableIndexes) {
        return false;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        if (this.getArity() == 0) {
            return termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)termFactory.getConversion2RDFLexical(termFactory.getDBCount(this.isDistinct), this.xsdIntegerType), this.xsdIntegerType);
        }
        ImmutableTerm newTerm = (ImmutableTerm)newTerms.get(0);
        if (this.isRDFFunctionalTerm(newTerm) || newTerm instanceof RDFConstant) {
            ImmutableTerm lexicalTerm = this.extractLexicalTerm(newTerm, termFactory);
            ImmutableFunctionalTerm dbCountTerm = termFactory.getDBCount(lexicalTerm, this.isDistinct);
            return termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)termFactory.getConversion2RDFLexical(dbCountTerm, this.xsdIntegerType), this.xsdIntegerType).simplify(variableNullability);
        }
        if (newTerm.isNull()) {
            return termFactory.getRDFLiteralConstant("0", XSD.INTEGER);
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    @Override
    public boolean isAggregation() {
        return true;
    }

    @Override
    public Optional<SPARQLAggregationFunctionSymbol.AggregationSimplification> decomposeIntoDBAggregation(ImmutableList<? extends ImmutableTerm> subTerms, ImmutableList<ImmutableSet<RDFTermType>> possibleRDFTypes, boolean hasGroupBy, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        return Optional.empty();
    }

    @Override
    public Constant evaluateEmptyBag(TermFactory termFactory) {
        return termFactory.getRDFLiteralConstant("0", XSD.INTEGER);
    }
}

