/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBAndFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractDBBooleanConnectorFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.substitution.ProtoSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DefaultDBAndFunctionSymbol
extends AbstractDBBooleanConnectorFunctionSymbol
implements DBAndFunctionSymbol {
    private final String argumentSeparator;

    protected DefaultDBAndFunctionSymbol(String nameInDialect, int arity, DBTermType dbBooleanTermType) {
        super(nameInDialect, arity, dbBooleanTermType);
        if (arity < 2) {
            throw new IllegalArgumentException("Arity must be >= 2");
        }
        this.argumentSeparator = String.format(" %s ", nameInDialect);
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableList<ImmutableTerm> simplifiedTerms = this.simplifyInteractions(newTerms, termFactory, variableNullability);
        DBConstant falseValue = termFactory.getDBBooleanConstant(false);
        if (simplifiedTerms.stream().anyMatch(falseValue::equals)) {
            return falseValue;
        }
        Optional<ImmutableTerm> optionalNull = simplifiedTerms.stream().filter(t -> t instanceof Constant && t.isNull()).findFirst();
        ImmutableList others = (ImmutableList)simplifiedTerms.stream().map(t -> t instanceof Variable ? termFactory.getIsTrue((Variable)t) : t).filter(t -> t instanceof ImmutableExpression).map(t -> (ImmutableExpression)t).flatMap(t -> t.getFunctionSymbol() instanceof DBAndFunctionSymbol ? t.getTerms().stream().map(s -> (ImmutableExpression)s) : Stream.of(t)).distinct().collect(ImmutableCollectors.toList());
        return others.isEmpty() ? optionalNull.orElseGet(() -> termFactory.getDBBooleanConstant(true)) : optionalNull.map(n -> termFactory.getFalseOrNullFunctionalTerm((ImmutableList<ImmutableExpression>)others)).orElseGet(() -> others.size() == 1 ? (ImmutableTerm)others.get(0) : termFactory.getConjunction((ImmutableList<ImmutableExpression>)others));
    }

    protected ImmutableList<ImmutableTerm> simplifyInteractions(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return this.simplifyIsNullOrIsNotNull(newTerms, termFactory, variableNullability, true);
    }

    @Override
    protected ImmutableList<ImmutableTerm> simplify2VLInteractions(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return this.simplifyStrictEqConstants(newTerms, termFactory, variableNullability);
    }

    private ImmutableList<ImmutableTerm> simplifyStrictEqConstants(ImmutableList<ImmutableTerm> initialTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return IntStream.range(0, initialTerms.size()).boxed().reduce(initialTerms, (ts, i) -> this.simplifyStrictEqConstant((ImmutableList<ImmutableTerm>)ts, (int)i, termFactory, variableNullability), (ts1, ts2) -> {
            throw new MinorOntopInternalBugException("No merge expected");
        });
    }

    private ImmutableList<ImmutableTerm> simplifyStrictEqConstant(ImmutableList<ImmutableTerm> terms, int i, TermFactory termFactory, VariableNullability variableNullability) {
        Optional<ProtoSubstitution> substitution = Optional.of(terms.get(i)).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBStrictEqFunctionSymbol).map(ImmutableFunctionalTerm::getTerms).filter(eqTerms -> eqTerms.stream().anyMatch(t -> t instanceof Variable)).filter(eqTerms -> eqTerms.stream().anyMatch(t -> t instanceof NonNullConstant)).map(eqTerms -> ImmutableMap.of((Object)eqTerms.stream().filter(t -> t instanceof Variable).map(t -> (Variable)t).findAny().get(), (Object)eqTerms.stream().filter(t -> t instanceof NonNullConstant).map(t -> (NonNullConstant)t).findAny().get())).map(termFactory::getProtoSubstitution);
        return substitution.map(s -> (ImmutableList)IntStream.range(0, terms.size()).boxed().map(j -> i == j ? (ImmutableTerm)terms.get(i) : s.apply((ImmutableTerm)terms.get(j.intValue())).simplify(variableNullability)).collect(ImmutableCollectors.toList())).orElse(terms);
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.inBrackets(terms.stream().map(termConverter).collect(Collectors.joining(this.argumentSeparator)));
    }

    @Override
    public boolean blocksNegation() {
        return false;
    }

    @Override
    public ImmutableExpression negate(ImmutableList<? extends ImmutableTerm> subTerms, TermFactory termFactory) {
        return termFactory.getDisjunction((ImmutableList<ImmutableExpression>)((ImmutableList)subTerms.stream().map(t -> (ImmutableExpression)t).map(t -> t.negate(termFactory)).collect(ImmutableCollectors.toList())));
    }
}

