/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.atom.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class AbstractDataAtomImpl<P extends AtomPredicate>
implements DataAtom<P> {
    private final P predicate;
    private final ImmutableList<? extends VariableOrGroundTerm> arguments;
    @Nullable
    private String string;

    protected AbstractDataAtomImpl(P predicate, ImmutableList<? extends VariableOrGroundTerm> variableOrGroundTerms) {
        this.predicate = predicate;
        this.arguments = variableOrGroundTerms;
        this.string = null;
        if (predicate.getArity() != this.arguments.size()) {
            throw new IllegalArgumentException("Arity violation: " + predicate + " was expecting " + predicate.getArity() + ", not " + this.arguments.size());
        }
    }

    protected AbstractDataAtomImpl(P predicate, VariableOrGroundTerm ... variableOrGroundTerms) {
        this.predicate = predicate;
        this.arguments = ImmutableList.copyOf((Object[])variableOrGroundTerms);
    }

    @Override
    public P getPredicate() {
        return this.predicate;
    }

    @Override
    public int getArity() {
        return this.predicate.getArity();
    }

    @Override
    public int getEffectiveArity() {
        return this.arguments.size();
    }

    @Override
    public ImmutableList<? extends VariableOrGroundTerm> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean containsGroundTerms() {
        for (ImmutableTerm term : this.getArguments()) {
            if (!term.isGround()) continue;
            return true;
        }
        return false;
    }

    @Override
    public VariableOrGroundTerm getTerm(int index) {
        return (VariableOrGroundTerm)this.arguments.get(index);
    }

    @Override
    public ImmutableSet<Variable> getVariables() {
        return (ImmutableSet)this.arguments.stream().flatMap(ImmutableTerm::getVariableStream).collect(ImmutableCollectors.toSet());
    }

    protected static boolean hasDuplicates(DataAtom atom) {
        ImmutableList<VariableOrGroundTerm> termList = atom.getArguments();
        HashSet<VariableOrGroundTerm> termSet = new HashSet<VariableOrGroundTerm>((Collection<VariableOrGroundTerm>)termList);
        return termSet.size() < termList.size();
    }

    public boolean equals(Object other) {
        if (other instanceof DataAtom) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.predicate.toString());
            sb.append("(");
            List argumentStrings = this.arguments.stream().map(Object::toString).collect(Collectors.toList());
            sb.append(String.join((CharSequence)",", argumentStrings));
            sb.append(")");
            this.string = sb.toString();
        }
        return this.string;
    }
}

