/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.transform.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.impl.ChildTransformer;

public final class CompositeIQTreeTransformer
implements IQTreeTransformer {
    private final ImmutableList<IQTreeTransformer> preTransformers;
    private final ImmutableList<IQTreeTransformer> postTransformers;
    private final IQTreeTransformer childTransformer;

    public CompositeIQTreeTransformer(ImmutableList<IQTreeTransformer> preTransformers, ImmutableList<IQTreeTransformer> postTransformers, IntermediateQueryFactory iqFactory) {
        this.preTransformers = preTransformers;
        this.postTransformers = postTransformers;
        this.childTransformer = new ChildTransformer(iqFactory, this);
    }

    @Override
    public IQTree transform(IQTree initialTree) {
        IQTree currentTree = initialTree;
        for (IQTreeTransformer transformer : this.preTransformers) {
            currentTree = transformer.transform(currentTree);
        }
        currentTree = this.childTransformer.transform(currentTree);
        for (IQTreeTransformer transformer : this.postTransformers) {
            currentTree = transformer.transform(currentTree);
        }
        return currentTree;
    }
}

