/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@Singleton
public class JoinLikeChildBindingLifter {
    private final ConditionSimplifier conditionSimplifier;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    private JoinLikeChildBindingLifter(ConditionSimplifier conditionSimplifier, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.conditionSimplifier = conditionSimplifier;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
    }

    public <R> R liftRegularChildBinding(ConstructionNode selectedChildConstructionNode, int selectedChildPosition, IQTree selectedGrandChild, ImmutableList<IQTree> children, ImmutableSet<Variable> nonLiftableVariables, Optional<ImmutableExpression> initialJoiningCondition, VariableGenerator variableGenerator, VariableNullability variableNullability, BindingLiftConverter<R> bindingLiftConverter) throws UnsatisfiableConditionException {
        ImmutableSubstitution<ImmutableTerm> selectedChildSubstitution = selectedChildConstructionNode.getSubstitution();
        ImmutableSubstitution<VariableOrGroundTerm> downPropagableFragment = selectedChildSubstitution.getVariableOrGroundTermFragment();
        ImmutableSubstitution<ImmutableFunctionalTerm> nonDownPropagableFragment = selectedChildSubstitution.getFunctionalTermFragment();
        ImmutableSet otherChildrenVariables = (ImmutableSet)IntStream.range(0, children.size()).filter(i -> i != selectedChildPosition).boxed().map(arg_0 -> children.get(arg_0)).flatMap(iq -> iq.getVariables().stream()).collect(ImmutableCollectors.toSet());
        InjectiveVar2VarSubstitution freshRenaming = this.computeOtherChildrenRenaming(nonDownPropagableFragment, (ImmutableSet<Variable>)otherChildrenVariables, variableGenerator);
        ConditionSimplifier.ExpressionAndSubstitution expressionResults = this.conditionSimplifier.simplifyCondition(this.computeNonOptimizedCondition(initialJoiningCondition, selectedChildSubstitution, freshRenaming), nonLiftableVariables, variableNullability);
        Optional<ImmutableExpression> newCondition = expressionResults.getOptionalExpression();
        ImmutableSubstitution<ImmutableTerm> naiveAscendingSubstitution = expressionResults.getSubstitution().composeWith(selectedChildSubstitution);
        ImmutableSubstitution<VariableOrGroundTerm> descendingSubstitution = expressionResults.getSubstitution().composeWith2(freshRenaming).composeWith2(downPropagableFragment);
        return bindingLiftConverter.convert(children, selectedGrandChild, selectedChildPosition, newCondition, naiveAscendingSubstitution, descendingSubstitution);
    }

    private Optional<ImmutableExpression> computeNonOptimizedCondition(Optional<ImmutableExpression> initialJoiningCondition, ImmutableSubstitution<? extends ImmutableTerm> substitution, InjectiveVar2VarSubstitution freshRenaming) {
        Stream<ImmutableExpression> expressions = Stream.concat(initialJoiningCondition.map(substitution::applyToBooleanExpression).map(ImmutableExpression::flattenAND).orElseGet(Stream::empty), freshRenaming.getImmutableMap().entrySet().stream().map(r -> this.termFactory.getStrictEquality(substitution.applyToVariable((Variable)r.getKey()), (ImmutableTerm)r.getValue(), new ImmutableTerm[0])));
        return this.termFactory.getConjunction(expressions);
    }

    private InjectiveVar2VarSubstitution computeOtherChildrenRenaming(ImmutableSubstitution<ImmutableFunctionalTerm> nonDownPropagatedFragment, ImmutableSet<Variable> otherChildrenVariables, VariableGenerator variableGenerator) {
        ImmutableMap<Variable, Variable> substitutionMap = nonDownPropagatedFragment.getImmutableMap().keySet().stream().filter(arg_0 -> otherChildrenVariables.contains(arg_0)).collect(ImmutableCollectors.toMap(v -> v, variableGenerator::generateNewVariableFromVar));
        return this.substitutionFactory.getInjectiveVar2VarSubstitution((Map<Variable, Variable>)substitutionMap);
    }

    @FunctionalInterface
    public static interface BindingLiftConverter<R> {
        public R convert(ImmutableList<IQTree> var1, IQTree var2, int var3, Optional<ImmutableExpression> var4, ImmutableSubstitution<ImmutableTerm> var5, ImmutableSubstitution<? extends VariableOrGroundTerm> var6);
    }
}

