/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtendedProjectionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InjectiveBindingLiftState {
    private final ImmutableList<ConstructionNode> ancestors;
    private final IQTree grandChildTree;
    @Nullable
    private final ConstructionNode childConstructionNode;
    private final VariableGenerator variableGenerator;
    private final CoreSingletons coreSingletons;

    protected InjectiveBindingLiftState(@Nonnull ConstructionNode childConstructionNode, IQTree grandChildTree, VariableGenerator variableGenerator, CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
        this.ancestors = ImmutableList.of();
        this.grandChildTree = grandChildTree;
        this.childConstructionNode = childConstructionNode;
        this.variableGenerator = variableGenerator;
    }

    private InjectiveBindingLiftState(ImmutableList<ConstructionNode> ancestors, IQTree grandChildTree, VariableGenerator variableGenerator, CoreSingletons coreSingletons) {
        this.ancestors = ancestors;
        this.grandChildTree = grandChildTree;
        this.coreSingletons = coreSingletons;
        this.childConstructionNode = null;
        this.variableGenerator = variableGenerator;
    }

    private InjectiveBindingLiftState(ImmutableList<ConstructionNode> ancestors, IQTree grandChildTree, VariableGenerator variableGenerator, @Nonnull ConstructionNode childConstructionNode, CoreSingletons coreSingletons) {
        this.ancestors = ancestors;
        this.grandChildTree = grandChildTree;
        this.childConstructionNode = childConstructionNode;
        this.variableGenerator = variableGenerator;
        this.coreSingletons = coreSingletons;
    }

    public IQTree getGrandChildTree() {
        return this.grandChildTree;
    }

    public Optional<ConstructionNode> getChildConstructionNode() {
        return Optional.ofNullable(this.childConstructionNode);
    }

    public ImmutableList<ConstructionNode> getAncestors() {
        return this.ancestors;
    }

    public InjectiveBindingLiftState liftBindings() {
        if (this.childConstructionNode == null) {
            return this;
        }
        ImmutableSubstitution<ImmutableTerm> childSubstitution = this.childConstructionNode.getSubstitution();
        if (childSubstitution.isEmpty()) {
            return this;
        }
        VariableNullability grandChildVariableNullability = this.grandChildTree.getVariableNullability();
        ImmutableSet<Variable> nonFreeVariables = this.childConstructionNode.getVariables();
        ImmutableMap<Variable, Optional> injectivityDecompositionMap = childSubstitution.getImmutableMap().entrySet().stream().filter(e -> e.getValue() instanceof ImmutableFunctionalTerm).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> ((ImmutableFunctionalTerm)e.getValue()).analyzeInjectivity(nonFreeVariables, grandChildVariableNullability, this.variableGenerator)));
        ImmutableMap liftedSubstitutionMap = Stream.concat(childSubstitution.getImmutableMap().entrySet().stream().filter(e -> e.getValue() instanceof NonFunctionalTerm), injectivityDecompositionMap.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).map(e -> Maps.immutableEntry(e.getKey(), (Object)((ImmutableFunctionalTerm.FunctionalTermDecomposition)((Optional)e.getValue()).get()).getLiftableTerm()))).collect(ImmutableCollectors.toMap());
        SubstitutionFactory substitutionFactory = this.coreSingletons.getSubstitutionFactory();
        IntermediateQueryFactory iqFactory = this.coreSingletons.getIQFactory();
        Optional<ConstructionNode> liftedConstructionNode = Optional.of(liftedSubstitutionMap).filter(m -> !m.isEmpty()).map(substitutionFactory::getSubstitution).map(s -> iqFactory.createConstructionNode(this.childConstructionNode.getVariables(), (ImmutableSubstitution<ImmutableTerm>)s));
        ImmutableSet newChildVariables = liftedConstructionNode.map(ExtendedProjectionNode::getChildVariables).orElseGet(this.childConstructionNode::getVariables);
        ImmutableMap newChildSubstitutionMap = injectivityDecompositionMap.entrySet().stream().flatMap(e -> ((Optional)e.getValue()).map(d -> d.getSubTermSubstitutionMap().map(s -> s.entrySet().stream().map(subE -> subE)).orElseGet(Stream::empty)).orElseGet(() -> Stream.of(Maps.immutableEntry(e.getKey(), childSubstitution.get((Variable)e.getKey()))))).collect(ImmutableCollectors.toMap());
        Optional newChildConstructionNode = Optional.of(newChildSubstitutionMap).filter(m -> !m.isEmpty()).map(substitutionFactory::getSubstitution).map(s -> iqFactory.createConstructionNode((ImmutableSet<Variable>)newChildVariables, (ImmutableSubstitution<ImmutableTerm>)s)).map(Optional::of).orElseGet(() -> newChildVariables.equals(this.grandChildTree.getVariables()) ? Optional.empty() : Optional.of(iqFactory.createConstructionNode((ImmutableSet<Variable>)newChildVariables)));
        if (newChildConstructionNode.filter(n -> n.isEquivalentTo(this.childConstructionNode)).isPresent()) {
            if (liftedConstructionNode.isPresent()) {
                throw new MinorOntopInternalBugException("Unexpected lifted construction node");
            }
            return this;
        }
        ImmutableList newAncestors = liftedConstructionNode.map(n -> (ImmutableList)Stream.concat(this.ancestors.stream(), Stream.of(n)).collect(ImmutableCollectors.toList())).orElseThrow(() -> new MinorOntopInternalBugException("A lifted construction node was expected"));
        return newChildConstructionNode.map(c -> new InjectiveBindingLiftState((ImmutableList<ConstructionNode>)newAncestors, this.grandChildTree, this.variableGenerator, (ConstructionNode)c, this.coreSingletons)).orElseGet(() -> new InjectiveBindingLiftState((ImmutableList<ConstructionNode>)newAncestors, this.grandChildTree, this.variableGenerator, this.coreSingletons));
    }
}

