/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl.tree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.iq.exception.IllegalTreeUpdateException;
import it.unibz.inf.ontop.iq.node.BinaryOrderedOperatorNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public interface QueryTree {
    public QueryNode getRootNode();

    public void addChild(QueryNode var1, QueryNode var2, Optional<BinaryOrderedOperatorNode.ArgumentPosition> var3, boolean var4, boolean var5) throws IllegalTreeUpdateException;

    public ImmutableList<QueryNode> getChildren(QueryNode var1);

    public Stream<QueryNode> getChildrenStream(QueryNode var1);

    public boolean contains(QueryNode var1);

    public ImmutableList<QueryNode> getNodesInBottomUpOrder();

    public ImmutableList<QueryNode> getNodesInTopDownOrder();

    public void replaceNode(QueryNode var1, QueryNode var2);

    public void removeSubTree(QueryNode var1);

    public ImmutableList<QueryNode> getSubTreeNodesInTopDownOrder(QueryNode var1);

    public Optional<QueryNode> getParent(QueryNode var1);

    public QueryNode removeOrReplaceNodeByUniqueChild(QueryNode var1) throws IllegalTreeUpdateException;

    public void replaceNodesByOneNode(ImmutableList<QueryNode> var1, QueryNode var2, QueryNode var3, Optional<BinaryOrderedOperatorNode.ArgumentPosition> var4) throws IllegalTreeUpdateException;

    public Optional<BinaryOrderedOperatorNode.ArgumentPosition> getOptionalPosition(QueryNode var1, QueryNode var2);

    public void insertParent(QueryNode var1, QueryNode var2, Optional<BinaryOrderedOperatorNode.ArgumentPosition> var3) throws IllegalTreeUpdateException;

    public ImmutableSet<TrueNode> getTrueNodes();

    public QueryNode replaceNodeByChild(QueryNode var1, Optional<BinaryOrderedOperatorNode.ArgumentPosition> var2);

    public ImmutableSet<IntensionalDataNode> getIntensionalNodes();

    public QueryTree createSnapshot();

    public void transferChild(QueryNode var1, QueryNode var2, QueryNode var3, Optional<BinaryOrderedOperatorNode.ArgumentPosition> var4);

    public UUID getVersionNumber();
}

