/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.impl.AbstractCompositeIQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;

public class NaryIQTreeImpl
extends AbstractCompositeIQTree<NaryOperatorNode>
implements NaryIQTree {
    @AssistedInject
    private NaryIQTreeImpl(@Assisted NaryOperatorNode rootNode, @Assisted ImmutableList<IQTree> children, @Assisted IQProperties iqProperties, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, TermFactory termFactory, OntopModelSettings settings) {
        super(rootNode, children, iqProperties, iqTreeTools, iqFactory, termFactory);
        if (children.size() < 2) {
            throw new IllegalArgumentException("At least two children are required for a n-ary node");
        }
        if (settings.isTestModeEnabled()) {
            this.validate();
        }
    }

    @AssistedInject
    private NaryIQTreeImpl(@Assisted NaryOperatorNode rootNode, @Assisted ImmutableList<IQTree> children, @Assisted IQTreeCache treeCache, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, TermFactory termFactory, OntopModelSettings settings) {
        super(rootNode, children, treeCache, iqTreeTools, iqFactory, termFactory);
        if (children.size() < 2) {
            throw new IllegalArgumentException("At least two children are required for a n-ary node");
        }
        if (settings.isTestModeEnabled()) {
            this.validate();
        }
    }

    @AssistedInject
    private NaryIQTreeImpl(@Assisted NaryOperatorNode rootNode, @Assisted ImmutableList<IQTree> children, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, TermFactory termFactory, OntopModelSettings settings, IQTreeCache freshTreeCache) {
        this(rootNode, children, freshTreeCache, iqTreeTools, iqFactory, termFactory, settings);
    }

    @Override
    protected void validateNode() throws InvalidIntermediateQueryException {
        ((NaryOperatorNode)this.getRootNode()).validateNode(this.getChildren());
    }

    @Override
    protected VariableNullability computeVariableNullability() {
        return ((NaryOperatorNode)this.getRootNode()).getVariableNullability(this.getChildren());
    }

    @Override
    public IQTree acceptTransformer(IQTreeVisitingTransformer transformer) {
        return ((NaryOperatorNode)this.getRootNode()).acceptTransformer(this, transformer, this.getChildren());
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor) {
        return ((NaryOperatorNode)this.getRootNode()).acceptVisitor(visitor, this.getChildren());
    }

    @Override
    public IQTree normalizeForOptimization(VariableGenerator variableGenerator) {
        return this.getProperties().isNormalizedForOptimization() ? this : ((NaryOperatorNode)this.getRootNode()).normalizeForOptimization(this.getChildren(), variableGenerator, this.getProperties());
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, VariableGenerator variableGenerator) {
        return ((NaryOperatorNode)this.getRootNode()).liftIncompatibleDefinitions(variable, this.getChildren(), variableGenerator);
    }

    @Override
    protected IQTree applyFreshRenaming(InjectiveVar2VarSubstitution renamingSubstitution, boolean alreadyNormalized) {
        InjectiveVar2VarSubstitution selectedSubstitution = alreadyNormalized ? renamingSubstitution : renamingSubstitution.reduceDomainToIntersectionWith((ImmutableSet)this.getVariables());
        return selectedSubstitution.isEmpty() ? this : ((NaryOperatorNode)this.getRootNode()).applyFreshRenaming(renamingSubstitution, this.getChildren(), this.getTreeCache());
    }

    @Override
    protected IQTree applyRegularDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint) {
        return ((NaryOperatorNode)this.getRootNode()).applyDescendingSubstitution(descendingSubstitution, constraint, this.getChildren());
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution) {
        try {
            return this.normalizeDescendingSubstitution(descendingSubstitution).map(s -> ((NaryOperatorNode)this.getRootNode()).applyDescendingSubstitutionWithoutOptimizing((ImmutableSubstitution<? extends VariableOrGroundTerm>)s, this.getChildren())).orElse(this);
        }
        catch (IQTreeTools.UnsatisfiableDescendingSubstitutionException e) {
            return this.iqFactory.createEmptyNode(this.iqTreeTools.computeNewProjectedVariables(descendingSubstitution, this.getVariables()));
        }
    }

    @Override
    public boolean isConstructed(Variable variable) {
        return this.getVariables().contains((Object)variable) && ((NaryOperatorNode)this.getRootNode()).isConstructed(variable, this.getChildren());
    }

    @Override
    protected boolean computeIsDistinct() {
        return ((NaryOperatorNode)this.getRootNode()).isDistinct(this, this.getChildren());
    }

    @Override
    public boolean isDeclaredAsEmpty() {
        return false;
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint) {
        IQTree newTree = ((NaryOperatorNode)this.getRootNode()).propagateDownConstraint(constraint, this.getChildren());
        return newTree.equals(this) ? this : newTree;
    }

    @Override
    public IQTree replaceSubTree(IQTree subTreeToReplace, IQTree newSubTree) {
        if (this.equals(subTreeToReplace)) {
            return newSubTree;
        }
        ImmutableList newChildren = (ImmutableList)this.getChildren().stream().map(c -> c.replaceSubTree(subTreeToReplace, newSubTree)).collect(ImmutableCollectors.toList());
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)this.getRootNode(), (ImmutableList<IQTree>)newChildren);
    }

    @Override
    protected ImmutableSet<ImmutableSubstitution<NonVariableTerm>> computePossibleVariableDefinitions() {
        return ((NaryOperatorNode)this.getRootNode()).getPossibleVariableDefinitions(this.getChildren());
    }

    @Override
    public IQTree removeDistincts() {
        IQProperties properties = this.getProperties();
        return properties.areDistinctAlreadyRemoved() ? this : ((NaryOperatorNode)this.getRootNode()).removeDistincts(this.getChildren(), properties);
    }

    @Override
    protected ImmutableSet<ImmutableSet<Variable>> computeUniqueConstraints() {
        return ((NaryOperatorNode)this.getRootNode()).inferUniqueConstraints(this.getChildren());
    }

    @Override
    protected ImmutableSet<Variable> computeNotInternallyRequiredVariables() {
        return ((NaryOperatorNode)this.getRootNode()).computeNotInternallyRequiredVariables(this.getChildren());
    }
}

