/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl;

import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTreeCache;

public class IQPropertiesImpl
implements IQProperties {
    private final boolean isNormalized;
    private final boolean areDistinctAlreadyRemoved;
    private final IQTreeCache emptyTreeCache;

    @AssistedInject
    private IQPropertiesImpl(IQTreeCache emptyTreeCache) {
        this.emptyTreeCache = emptyTreeCache;
        this.isNormalized = false;
        this.areDistinctAlreadyRemoved = false;
    }

    private IQPropertiesImpl(IQTreeCache emptyTreeCache, boolean isNormalized, boolean areDistinctAlreadyRemoved) {
        this.emptyTreeCache = emptyTreeCache;
        this.isNormalized = isNormalized;
        this.areDistinctAlreadyRemoved = areDistinctAlreadyRemoved;
    }

    @Override
    public boolean isNormalizedForOptimization() {
        return this.isNormalized;
    }

    @Override
    public boolean areDistinctAlreadyRemoved() {
        return this.areDistinctAlreadyRemoved;
    }

    @Override
    public IQProperties declareNormalizedForOptimization() {
        return new IQPropertiesImpl(this.emptyTreeCache, true, this.areDistinctAlreadyRemoved);
    }

    @Override
    public IQProperties declareDistinctRemovalWithoutEffect() {
        return new IQPropertiesImpl(this.emptyTreeCache, this.isNormalized, true);
    }

    @Override
    public IQProperties declareDistinctRemovalWithEffect() {
        return new IQPropertiesImpl(this.emptyTreeCache, false, true);
    }

    @Override
    public IQTreeCache convertIQTreeCache() {
        IQTreeCache treeCache = this.emptyTreeCache;
        if (this.isNormalized) {
            treeCache = treeCache.declareAsNormalizedForOptimizationWithoutEffect();
        }
        if (this.areDistinctAlreadyRemoved) {
            treeCache = treeCache.declareDistinctRemovalWithoutEffect();
        }
        return treeCache;
    }
}

