/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.AttributeImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Collectors;

public class UniqueConstraintImpl
implements UniqueConstraint {
    private final String name;
    private final ImmutableList<Attribute> attributes;
    private final boolean isPrimaryKey;

    public static FunctionalDependency.Builder builder(DatabaseRelationDefinition relation, String name) {
        return new UniqueConstraintBuilder(relation, name);
    }

    public static FunctionalDependency.Builder primaryKeyBuilder(DatabaseRelationDefinition relation, String name) {
        return new PrimaryKeyBuilder(relation, name);
    }

    private UniqueConstraintImpl(String name, boolean isPrimaryKey, ImmutableList<Attribute> attributes) {
        this.name = name;
        this.isPrimaryKey = isPrimaryKey;
        this.attributes = attributes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="isPrimaryKey")
    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    @Override
    @JsonProperty(value="determinants")
    @JsonSerialize(contentUsing=AttributeImpl.AttributeSerializer.class)
    public ImmutableList<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    @JsonIgnore
    public ImmutableSet<Attribute> getDeterminants() {
        return ImmutableSet.copyOf(this.attributes);
    }

    @Override
    @JsonIgnore
    public ImmutableSet<Attribute> getDependents() {
        return (ImmutableSet)((Attribute)this.attributes.get(0)).getRelation().getAttributes().stream().filter(a -> !this.attributes.contains(a)).collect(ImmutableCollectors.toSet());
    }

    public String toString() {
        return "ALTER TABLE " + ((DatabaseRelationDefinition)((Attribute)this.attributes.get(0)).getRelation()).getID() + " ADD CONSTRAINT " + this.name + (this.isPrimaryKey ? " PRIMARY KEY " : " UNIQUE ") + "(" + this.attributes.stream().map(Attribute::getID).map(Object::toString).collect(Collectors.joining(", ")) + ")";
    }

    private static class PrimaryKeyBuilder
    extends UniqueConstraintBuilder {
        private PrimaryKeyBuilder(DatabaseRelationDefinition relation, String name) {
            super(relation, name);
        }

        @Override
        public FunctionalDependency.Builder addDeterminant(int determinantIndex) {
            Attribute attribute = this.relation.getAttribute(determinantIndex);
            if (attribute.isNullable()) {
                throw new IllegalArgumentException("Nullable attribute " + attribute + " cannot be in a PK");
            }
            this.builder.add((Object)attribute);
            return this;
        }

        @Override
        public FunctionalDependency.Builder addDeterminant(QuotedID determinantId) throws AttributeNotFoundException {
            Attribute attribute = this.relation.getAttribute(determinantId);
            if (attribute.isNullable()) {
                throw new IllegalArgumentException("Nullable attribute " + attribute + " cannot be in a PK");
            }
            this.builder.add((Object)attribute);
            return this;
        }

        @Override
        public void build() {
            ImmutableList attributes = this.builder.build();
            if (attributes.isEmpty()) {
                throw new IllegalArgumentException("PK cannot have no attributes");
            }
            this.relation.addFunctionalDependency(new UniqueConstraintImpl(this.name, true, attributes));
        }
    }

    private static class UniqueConstraintBuilder
    implements FunctionalDependency.Builder {
        protected final ImmutableList.Builder<Attribute> builder = ImmutableList.builder();
        protected final DatabaseRelationDefinition relation;
        protected final String name;

        private UniqueConstraintBuilder(DatabaseRelationDefinition relation, String name) {
            this.relation = relation;
            this.name = name;
        }

        @Override
        public FunctionalDependency.Builder addDeterminant(int determinantIndex) {
            this.builder.add((Object)this.relation.getAttribute(determinantIndex));
            return this;
        }

        @Override
        public FunctionalDependency.Builder addDeterminant(QuotedID determinantId) throws AttributeNotFoundException {
            this.builder.add((Object)this.relation.getAttribute(determinantId));
            return this;
        }

        @Override
        public FunctionalDependency.Builder addDependent(int dependentIndex) {
            throw new IllegalArgumentException("No dependents");
        }

        @Override
        public FunctionalDependency.Builder addDependent(QuotedID dependentId) {
            throw new IllegalArgumentException("No dependents");
        }

        @Override
        public void build() {
            ImmutableList attributes = this.builder.build();
            if (attributes.isEmpty()) {
                throw new IllegalArgumentException("UC cannot have no attributes");
            }
            Optional<UniqueConstraint> pk = this.relation.getPrimaryKey();
            if (pk.isPresent() && pk.get().getAttributes().equals((Object)attributes)) {
                return;
            }
            this.relation.addFunctionalDependency(new UniqueConstraintImpl(this.name, false, attributes));
        }
    }
}

