/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.QuotedIDImpl;
import it.unibz.inf.ontop.dbschema.impl.RelationIDImpl;

public class SQLStandardQuotedIDFactory
implements QuotedIDFactory {
    public static final String QUOTATION_STRING = "\"";
    public static final String NO_QUOTATION = "";

    @Override
    public QuotedID createAttributeID(String s) {
        return this.createFromString(s);
    }

    @Override
    public RelationID createRelationID(String schema, String table) {
        return new RelationIDImpl(this.createFromString(schema), this.createFromString(table));
    }

    private QuotedID createFromString(String s) {
        if (s == null) {
            return new QuotedIDImpl(s, NO_QUOTATION);
        }
        if (s.startsWith(QUOTATION_STRING) && s.endsWith(QUOTATION_STRING)) {
            return new QuotedIDImpl(s.substring(1, s.length() - 1), QUOTATION_STRING);
        }
        return new QuotedIDImpl(s.toUpperCase(), NO_QUOTATION);
    }

    @Override
    public String getIDQuotationString() {
        return QUOTATION_STRING;
    }
}

