/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import it.unibz.inf.ontop.dbschema.QuotedID;
import java.io.IOException;

public class QuotedIDImpl
implements QuotedID {
    private final String id;
    private final String quoteString;
    private final boolean caseSensitive;
    private final int hashCode;
    public static final QuotedID EMPTY_ID = new QuotedIDImpl(null, "");

    QuotedIDImpl(String id, String quoteString) {
        this(id, quoteString, true);
    }

    QuotedIDImpl(String id, String quoteString, boolean caseSensitive) {
        this.id = id;
        this.quoteString = quoteString;
        this.caseSensitive = caseSensitive;
        this.hashCode = id != null ? id.toLowerCase().hashCode() : 0;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public String getSQLRendering() {
        return this.id != null ? this.quoteString + this.id + this.quoteString : null;
    }

    public String toString() {
        return this.getSQLRendering();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QuotedIDImpl) {
            QuotedIDImpl other = (QuotedIDImpl)obj;
            if (this.id == other.id) {
                return true;
            }
            if (this.id != null && other.id != null) {
                if (this.id.equals(other.id)) {
                    return true;
                }
                if (!this.caseSensitive || !other.caseSensitive) {
                    return this.id.toLowerCase().equals(other.id.toLowerCase());
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static class QuotedIDSerializer
    extends JsonSerializer<QuotedID> {
        public void serialize(QuotedID value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.getSQLRendering());
        }
    }
}

