/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.QuotedID;
import java.io.IOException;
import java.util.stream.Collectors;

public class ForeignKeyConstraintImpl
implements ForeignKeyConstraint {
    private final String name;
    private final ImmutableList<ForeignKeyConstraint.Component> components;
    private final DatabaseRelationDefinition relation;
    private final DatabaseRelationDefinition referencedRelation;

    public static ForeignKeyConstraint.Builder builder(String name, DatabaseRelationDefinition relation, DatabaseRelationDefinition referencedRelation) {
        return new BuilderImpl(name, relation, referencedRelation);
    }

    private ForeignKeyConstraintImpl(String name, ImmutableList<ForeignKeyConstraint.Component> components) {
        this.name = name;
        this.components = components;
        this.relation = (DatabaseRelationDefinition)((ForeignKeyConstraint.Component)components.get(0)).getAttribute().getRelation();
        this.referencedRelation = (DatabaseRelationDefinition)((ForeignKeyConstraint.Component)components.get(0)).getReferencedAttribute().getRelation();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImmutableList<ForeignKeyConstraint.Component> getComponents() {
        return this.components;
    }

    @Override
    public DatabaseRelationDefinition getReferencedRelation() {
        return this.referencedRelation;
    }

    @Override
    public DatabaseRelationDefinition getRelation() {
        return this.relation;
    }

    public String toString() {
        return "ALTER TABLE " + this.relation.getID().getSQLRendering() + " ADD CONSTRAINT " + this.name + " FOREIGN KEY (" + this.components.stream().map(c -> c.getAttribute().getID().toString()).collect(Collectors.joining(", ")) + ") REFERENCES " + this.referencedRelation.getID().getSQLRendering() + " (" + this.components.stream().map(c -> c.getReferencedAttribute().getID().toString()).collect(Collectors.joining(", ")) + ")";
    }

    public static class ForeignKeyConstraintSerializer
    extends JsonSerializer<ForeignKeyConstraintImpl> {
        public void serialize(ForeignKeyConstraintImpl value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("name", value.getName());
            gen.writeFieldName("from");
            gen.writeStartObject();
            gen.writeStringField("relation", value.relation.getID().getSQLRendering());
            gen.writeArrayFieldStart("columns");
            for (ForeignKeyConstraint.Component component : value.getComponents()) {
                gen.writeString(component.getAttribute().getID().getSQLRendering());
            }
            gen.writeEndArray();
            gen.writeEndObject();
            gen.writeFieldName("to");
            gen.writeStartObject();
            gen.writeStringField("relation", value.referencedRelation.getID().getSQLRendering());
            gen.writeArrayFieldStart("columns");
            for (ForeignKeyConstraint.Component component : value.getComponents()) {
                gen.writeString(component.getReferencedAttribute().getID().getSQLRendering());
            }
            gen.writeEndArray();
            gen.writeEndObject();
            gen.writeEndObject();
        }
    }

    private static final class BuilderImpl
    implements ForeignKeyConstraint.Builder {
        private final String name;
        private final ImmutableList.Builder<ForeignKeyConstraint.Component> builder = ImmutableList.builder();
        private final DatabaseRelationDefinition relation;
        private final DatabaseRelationDefinition referencedRelation;

        private BuilderImpl(String name, DatabaseRelationDefinition relation, DatabaseRelationDefinition referencedRelation) {
            this.name = name;
            this.relation = relation;
            this.referencedRelation = referencedRelation;
        }

        @Override
        public ForeignKeyConstraint.Builder add(int attributeIndex, int referencedAttributeIndex) {
            this.builder.add((Object)new ComponentImpl(this.relation.getAttribute(attributeIndex), this.referencedRelation.getAttribute(referencedAttributeIndex)));
            return this;
        }

        @Override
        public ForeignKeyConstraint.Builder add(QuotedID attributeId, QuotedID referencedAttributeId) throws AttributeNotFoundException {
            this.builder.add((Object)new ComponentImpl(this.relation.getAttribute(attributeId), this.referencedRelation.getAttribute(referencedAttributeId)));
            return this;
        }

        @Override
        public void build() {
            ImmutableList components = this.builder.build();
            if (components.isEmpty()) {
                throw new IllegalArgumentException("No attributes in a foreign key");
            }
            this.relation.addForeignKeyConstraint(new ForeignKeyConstraintImpl(this.name, components));
        }
    }

    private static final class ComponentImpl
    implements ForeignKeyConstraint.Component {
        private final Attribute attribute;
        private final Attribute referencedAttribute;

        private ComponentImpl(Attribute attribute, Attribute referencedAttribute) {
            this.attribute = attribute;
            this.referencedAttribute = referencedAttribute;
        }

        @Override
        public Attribute getAttribute() {
            return this.attribute;
        }

        @Override
        public Attribute getReferencedAttribute() {
            return this.referencedAttribute;
        }
    }
}

