/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.QuotedIDImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import java.io.IOException;

public class AttributeImpl
implements Attribute {
    private final RelationDefinition relation;
    private final QuotedID id;
    private final int index;
    private final DBTermType termType;
    private final String typeName;
    private final boolean isNullable;

    AttributeImpl(RelationDefinition relation, QuotedID id, int index, String typeName, DBTermType termType, boolean isNullable) {
        this.relation = relation;
        this.id = id;
        this.index = index;
        this.typeName = typeName;
        this.termType = termType;
        this.isNullable = isNullable;
    }

    @Override
    @JsonIgnore
    public RelationDefinition getRelation() {
        return this.relation;
    }

    @Override
    @JsonProperty(value="name")
    @JsonSerialize(using=QuotedIDImpl.QuotedIDSerializer.class)
    public QuotedID getID() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public int getIndex() {
        return this.index;
    }

    @Override
    @JsonProperty(value="isNullable")
    public boolean isNullable() {
        return this.isNullable;
    }

    @JsonProperty(value="datatype")
    public String getSQLTypeName() {
        return this.typeName;
    }

    @Override
    @JsonIgnore
    public DBTermType getTermType() {
        return this.termType;
    }

    public String toString() {
        return this.id + (this.typeName == null ? "" : " " + this.typeName) + (this.isNullable ? "" : " NOT NULL");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AttributeImpl) {
            AttributeImpl other = (AttributeImpl)obj;
            return this.id.equals(other.id) && this.relation == other.relation;
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static class AttributeSerializer
    extends JsonSerializer<Attribute> {
        public void serialize(Attribute value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.getID().getSQLRendering());
        }
    }
}

