/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionTools;
import it.unibz.inf.ontop.substitution.impl.UnifierUtilities;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Singleton
public class ImmutableUnificationTools {
    private final SubstitutionFactory substitutionFactory;
    private final ImmutableSubstitutionTools substitutionTools;
    private final UnifierUtilities unifierUtilities;

    @Inject
    private ImmutableUnificationTools(SubstitutionFactory substitutionFactory, ImmutableSubstitutionTools substitutionTools, UnifierUtilities unifierUtilities) {
        this.substitutionFactory = substitutionFactory;
        this.substitutionTools = substitutionTools;
        this.unifierUtilities = unifierUtilities;
    }

    public <T extends ImmutableTerm> Optional<ImmutableSubstitution<T>> computeMGU(ImmutableList<T> args1, ImmutableList<T> args2) {
        if (args1.size() != args2.size()) {
            throw new IllegalArgumentException("The two argument lists must have the same size");
        }
        return this.unifierUtilities.getMGU(args1, args2);
    }

    public Optional<ArgumentMapUnification> computeArgumentMapMGU(ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap1, ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap2) {
        ImmutableSet firstIndexes = argumentMap1.keySet();
        ImmutableSet secondIndexes = argumentMap2.keySet();
        Sets.SetView commonIndexes = Sets.intersection((Set)firstIndexes, (Set)secondIndexes);
        Optional<ImmutableSubstitution<ImmutableSubstitution>> unifier = this.unifierUtilities.getMGU((ImmutableList<? extends ImmutableTerm>)((ImmutableList)commonIndexes.stream().map(arg_0 -> argumentMap1.get(arg_0)).collect(ImmutableCollectors.toList())), (ImmutableList<? extends ImmutableTerm>)((ImmutableList)commonIndexes.stream().map(arg_0 -> argumentMap2.get(arg_0)).collect(ImmutableCollectors.toList())));
        return unifier.map(u -> new ArgumentMapUnification((ImmutableMap<Integer, ? extends VariableOrGroundTerm>)u.applyToArgumentMap(Sets.union((Set)firstIndexes, (Set)secondIndexes).stream().collect(ImmutableCollectors.toMap(i -> i, i -> Optional.ofNullable((VariableOrGroundTerm)argumentMap1.get(i)).orElseGet(() -> (VariableOrGroundTerm)argumentMap2.get(i))))), (ImmutableSubstitution<VariableOrGroundTerm>)u));
    }

    public Optional<ImmutableSubstitution<NonFunctionalTerm>> computeMGUS2(ImmutableSubstitution<NonFunctionalTerm> s1, ImmutableSubstitution<NonFunctionalTerm> s2) {
        return this.computeMGUS(s1, s2).map(u -> u);
    }

    public Optional<ImmutableSubstitution<ImmutableTerm>> computeMGUS(ImmutableSubstitution<? extends ImmutableTerm> substitution1, ImmutableSubstitution<? extends ImmutableTerm> substitution2) {
        if (substitution1.isEmpty()) {
            return Optional.of(substitution2);
        }
        if (substitution2.isEmpty()) {
            Optional.of(substitution1);
        }
        ImmutableList.Builder firstArgListBuilder = ImmutableList.builder();
        ImmutableList.Builder secondArgListBuilder = ImmutableList.builder();
        for (Map.Entry entry : substitution1.getImmutableMap().entrySet()) {
            firstArgListBuilder.add(entry.getKey());
            secondArgListBuilder.add(entry.getValue());
        }
        for (Map.Entry entry : substitution2.getImmutableMap().entrySet()) {
            firstArgListBuilder.add(entry.getKey());
            secondArgListBuilder.add(entry.getValue());
        }
        ImmutableList firstArgList = firstArgListBuilder.build();
        ImmutableList secondArgList = secondArgListBuilder.build();
        return this.computeMGU(firstArgList, secondArgList);
    }

    public Optional<ImmutableSubstitution<VariableOrGroundTerm>> computeAtomMGUS(ImmutableSubstitution<VariableOrGroundTerm> substitution1, ImmutableSubstitution<VariableOrGroundTerm> substitution2) {
        Optional<ImmutableSubstitution<ImmutableTerm>> optionalMGUS = this.computeMGUS(substitution1, substitution2);
        return optionalMGUS.map(this.substitutionTools::convertIntoVariableOrGroundTermSubstitution);
    }

    public Optional<ImmutableSubstitution<ImmutableTerm>> computeDirectedMGU(ImmutableTerm sourceTerm, ImmutableTerm targetTerm) {
        if (sourceTerm instanceof Variable) {
            Variable sourceVariable = (Variable)sourceTerm;
            if (targetTerm instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)targetTerm).getVariables().contains((Object)sourceVariable)) {
                return Optional.empty();
            }
            ImmutableSubstitution substitution = sourceVariable.equals(targetTerm) ? this.substitutionFactory.getSubstitution() : this.substitutionFactory.getSubstitution(ImmutableMap.of((Object)sourceVariable, (Object)targetTerm));
            return Optional.of(substitution);
        }
        if (sourceTerm instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm sourceFunctionalTerm = (ImmutableFunctionalTerm)sourceTerm;
            if (targetTerm instanceof Variable) {
                Variable targetVariable = (Variable)targetTerm;
                if (sourceFunctionalTerm.getVariables().contains((Object)targetVariable)) {
                    return Optional.empty();
                }
                ImmutableSubstitution substitution = this.substitutionFactory.getSubstitution(ImmutableMap.of((Object)targetVariable, (Object)sourceTerm));
                return Optional.of(substitution);
            }
            if (targetTerm instanceof ImmutableFunctionalTerm) {
                return this.computeDirectedMGUOfTwoFunctionalTerms((ImmutableFunctionalTerm)sourceTerm, (ImmutableFunctionalTerm)targetTerm);
            }
            return Optional.empty();
        }
        if (sourceTerm instanceof Constant) {
            if (targetTerm instanceof Variable) {
                Variable targetVariable = (Variable)targetTerm;
                ImmutableSubstitution substitution = this.substitutionFactory.getSubstitution(ImmutableMap.of((Object)targetVariable, (Object)sourceTerm));
                return Optional.of(substitution);
            }
            if (sourceTerm.equals(targetTerm)) {
                return Optional.of(this.substitutionFactory.getSubstitution());
            }
            return Optional.empty();
        }
        throw new RuntimeException("Unexpected term: " + sourceTerm + " (" + sourceTerm.getClass() + ")");
    }

    private Optional<ImmutableSubstitution<ImmutableTerm>> computeDirectedMGUOfTwoFunctionalTerms(ImmutableFunctionalTerm sourceTerm, ImmutableFunctionalTerm targetTerm) {
        if (!sourceTerm.getFunctionSymbol().equals(targetTerm.getFunctionSymbol())) {
            return Optional.empty();
        }
        ImmutableList<? extends ImmutableTerm> sourceChildren = sourceTerm.getTerms();
        ImmutableList<? extends ImmutableTerm> targetChildren = targetTerm.getTerms();
        int childNb = sourceChildren.size();
        if (targetChildren.size() != childNb) {
            return Optional.empty();
        }
        ImmutableList.Builder pairBuilder = ImmutableList.builder();
        for (int i = 0; i < childNb; ++i) {
            Optional<ImmutableSubstitution<ImmutableTerm>> optionalChildTermUnifier = this.computeDirectedMGU((ImmutableTerm)sourceChildren.get(i), (ImmutableTerm)targetChildren.get(i));
            if (!optionalChildTermUnifier.isPresent()) {
                return Optional.empty();
            }
            pairBuilder.addAll(this.convertIntoPairs(optionalChildTermUnifier.get()));
        }
        return this.unifyPairs((ImmutableList<TermPair>)pairBuilder.build());
    }

    private Optional<ImmutableSubstitution<ImmutableTerm>> unifyPairs(ImmutableList<TermPair> originalPairs) {
        LinkedList<TermPair> allPairs = new LinkedList<TermPair>((Collection<TermPair>)originalPairs);
        LinkedList<TermPair> pairsToVisit = new LinkedList<TermPair>((Collection<TermPair>)originalPairs);
        try {
            while (!pairsToVisit.isEmpty()) {
                TermPair currentPair = (TermPair)pairsToVisit.poll();
                if (currentPair.canBeRemoved()) continue;
                ImmutableSubstitution<ImmutableTerm> substitution = currentPair.getSubstitution();
                ArrayList<TermPair> additionalPairs = new ArrayList<TermPair>();
                Iterator it = allPairs.iterator();
                while (it.hasNext()) {
                    TermPair pairToUpdate = (TermPair)it.next();
                    if (pairToUpdate == currentPair) continue;
                    additionalPairs.addAll((Collection<TermPair>)pairToUpdate.applySubstitution(substitution));
                    if (!pairToUpdate.canBeRemoved()) continue;
                    it.remove();
                }
                allPairs.addAll(additionalPairs);
                pairsToVisit.addAll(additionalPairs);
            }
            return Optional.of(this.convertPairs2Substitution(allPairs));
        }
        catch (UnificationException e) {
            return Optional.empty();
        }
    }

    private ImmutableList<TermPair> convertIntoPairs(ImmutableSubstitution<? extends ImmutableTerm> substitution) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Map.Entry entry : substitution.getImmutableMap().entrySet()) {
            listBuilder.add((Object)new TermPair((Variable)entry.getKey(), (ImmutableTerm)entry.getValue(), this.substitutionFactory, this));
        }
        return listBuilder.build();
    }

    private ImmutableSubstitution<ImmutableTerm> convertPairs2Substitution(List<TermPair> pairs) throws UnificationException {
        HashMap<Variable, ImmutableTerm> substitutionMap = new HashMap<Variable, ImmutableTerm>();
        for (TermPair pair : pairs) {
            Variable leftVariable = pair.getLeftVariable();
            ImmutableTerm rightTerm = pair.getRightTerm();
            if (!substitutionMap.containsKey(leftVariable)) {
                substitutionMap.put(leftVariable, rightTerm);
                continue;
            }
            if (((ImmutableTerm)substitutionMap.get(leftVariable)).equals(rightTerm)) continue;
            throw new UnificationException();
        }
        return this.substitutionFactory.getSubstitution(ImmutableMap.copyOf(substitutionMap));
    }

    public static class ArgumentMapUnification {
        public final ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap;
        public final ImmutableSubstitution<VariableOrGroundTerm> substitution;

        public ArgumentMapUnification(ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap, ImmutableSubstitution<VariableOrGroundTerm> substitution) {
            this.argumentMap = argumentMap;
            this.substitution = substitution;
        }
    }

    private static class TermPair {
        private boolean canBeRemoved;
        private Variable leftVariable;
        private ImmutableTerm rightTerm;
        private final SubstitutionFactory substitutionFactory;
        private final ImmutableUnificationTools unificationTools;

        private TermPair(Variable variable, ImmutableTerm rightTerm, SubstitutionFactory substitutionFactory, ImmutableUnificationTools unificationTools) {
            this.leftVariable = variable;
            this.rightTerm = rightTerm;
            this.substitutionFactory = substitutionFactory;
            this.unificationTools = unificationTools;
            this.canBeRemoved = false;
        }

        public ImmutableList<TermPair> applySubstitution(ImmutableSubstitution<? extends ImmutableTerm> substitution) throws UnificationException {
            if (this.canBeRemoved) {
                return ImmutableList.of();
            }
            ImmutableTerm transformedLeftTerm = substitution.apply(this.leftVariable);
            ImmutableTerm transformedRightTerm = substitution.apply(this.rightTerm);
            if (transformedLeftTerm instanceof Variable) {
                this.leftVariable = (Variable)transformedLeftTerm;
                this.rightTerm = transformedRightTerm;
                return ImmutableList.of();
            }
            if (transformedRightTerm instanceof Variable) {
                this.leftVariable = (Variable)transformedRightTerm;
                this.rightTerm = transformedLeftTerm;
                return ImmutableList.of();
            }
            Optional<ImmutableSubstitution<ImmutableTerm>> optionalUnifier = this.unificationTools.computeDirectedMGU(transformedLeftTerm, transformedRightTerm);
            if (!optionalUnifier.isPresent()) {
                throw new UnificationException();
            }
            this.canBeRemoved = true;
            this.leftVariable = null;
            this.rightTerm = null;
            return this.unificationTools.convertIntoPairs(optionalUnifier.get());
        }

        public ImmutableSubstitution<ImmutableTerm> getSubstitution() {
            if (this.canBeRemoved) {
                return this.substitutionFactory.getSubstitution();
            }
            return this.substitutionFactory.getSubstitution(ImmutableMap.of((Object)this.leftVariable, (Object)this.rightTerm));
        }

        boolean canBeRemoved() {
            return this.canBeRemoved;
        }

        Variable getLeftVariable() {
            return this.leftVariable;
        }

        ImmutableTerm getRightTerm() {
            return this.rightTerm;
        }
    }

    private static class UnificationException
    extends Exception {
        private UnificationException() {
        }
    }
}

