/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.LanguageTag;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.AbstractRDFDatatype;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import java.util.Optional;

public class LangDatatype
extends AbstractRDFDatatype {
    private final LanguageTag langTag;
    private final TermTypeAncestry parentAncestry;
    private final TypeFactory typeFactory;

    private LangDatatype(LanguageTag langTag, TermTypeAncestry parentAncestry, TypeFactory typeFactory) {
        super(RDF.LANGSTRING, parentAncestry, DBTypeFactory::getDBStringType);
        this.langTag = langTag;
        this.parentAncestry = parentAncestry;
        this.typeFactory = typeFactory;
    }

    static RDFDatatype createLangDatatype(LanguageTag langTag, TermTypeAncestry parentAncestry, TypeFactory typeFactory) {
        return new LangDatatype(langTag, parentAncestry, typeFactory);
    }

    @Override
    public TermType getCommonDenominator(TermType otherTermType) {
        RDFDatatype otherDatatype;
        Optional<LanguageTag> otherLanguageTag;
        if (otherTermType instanceof RDFDatatype && (otherLanguageTag = (otherDatatype = (RDFDatatype)otherTermType).getLanguageTag()).isPresent()) {
            return this.getCommonDenominator(otherLanguageTag.get());
        }
        return super.getCommonDenominator(otherTermType);
    }

    private TermType getCommonDenominator(LanguageTag otherLanguageTag) {
        return this.langTag.getCommonDenominator(otherLanguageTag).map(newLangTag -> newLangTag.equals(this.langTag) ? this : new LangDatatype((LanguageTag)newLangTag, this.parentAncestry, this.typeFactory)).orElseGet(this.typeFactory::getXsdStringDatatype);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof RDFDatatype) {
            RDFDatatype otherType = (RDFDatatype)other;
            return otherType.getLanguageTag().filter(this.langTag::equals).isPresent();
        }
        return false;
    }

    @Override
    public String toString() {
        return "@" + this.langTag.getFullString();
    }

    @Override
    public Optional<LanguageTag> getLanguageTag() {
        return Optional.of(this.langTag);
    }
}

