/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.node.JoinOrFilterNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.CompositeQueryNodeImpl;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionTools;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;

public abstract class JoinOrFilterNodeImpl
extends CompositeQueryNodeImpl
implements JoinOrFilterNode {
    private Optional<ImmutableExpression> optionalFilterCondition;
    private final TermNullabilityEvaluator nullabilityEvaluator;
    protected final TermFactory termFactory;
    protected final TypeFactory typeFactory;
    protected final SubstitutionFactory substitutionFactory;
    protected final ImmutableUnificationTools unificationTools;
    protected final ImmutableSubstitutionTools substitutionTools;

    protected JoinOrFilterNodeImpl(Optional<ImmutableExpression> optionalFilterCondition, TermNullabilityEvaluator nullabilityEvaluator, TermFactory termFactory, IntermediateQueryFactory iqFactory, TypeFactory typeFactory, SubstitutionFactory substitutionFactory, ImmutableUnificationTools unificationTools, ImmutableSubstitutionTools substitutionTools) {
        super(substitutionFactory, iqFactory);
        this.optionalFilterCondition = optionalFilterCondition;
        this.nullabilityEvaluator = nullabilityEvaluator;
        this.termFactory = termFactory;
        this.typeFactory = typeFactory;
        this.substitutionFactory = substitutionFactory;
        this.unificationTools = unificationTools;
        this.substitutionTools = substitutionTools;
    }

    @Override
    public Optional<ImmutableExpression> getOptionalFilterCondition() {
        return this.optionalFilterCondition;
    }

    protected String getOptionalFilterString() {
        if (this.optionalFilterCondition.isPresent()) {
            return " " + this.optionalFilterCondition.get().toString();
        }
        return "";
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        if (this.optionalFilterCondition.isPresent()) {
            return this.optionalFilterCondition.get().getVariables();
        }
        return ImmutableSet.of();
    }

    protected boolean isFilteringNullValue(Variable variable) {
        return this.getOptionalFilterCondition().filter(e -> this.nullabilityEvaluator.isFilteringNullValue((ImmutableExpression)e, variable)).isPresent();
    }

    protected TermNullabilityEvaluator getNullabilityEvaluator() {
        return this.nullabilityEvaluator;
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return this.getLocalVariables();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return ImmutableSet.of();
    }

    protected void checkExpression(ImmutableExpression expression, ImmutableList<IQTree> children) throws InvalidIntermediateQueryException {
        ImmutableSet childrenVariables = (ImmutableSet)children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet());
        ImmutableSet unboundVariables = (ImmutableSet)expression.getVariableStream().filter(v -> !childrenVariables.contains(v)).collect(ImmutableCollectors.toSet());
        if (!unboundVariables.isEmpty()) {
            throw new InvalidIntermediateQueryException("Expression " + expression + " of " + expression + " uses unbound variables (" + unboundVariables + ").\n" + this);
        }
    }

    protected ImmutableSet<Variable> computeNotInternallyRequiredVariables(ImmutableList<IQTree> children) {
        ImmutableSet<Variable> conditionVariables = this.getLocallyRequiredVariables();
        ImmutableSet notInternallyRequiredByAtLeastAChild = (ImmutableSet)children.stream().flatMap(c -> c.getNotInternallyRequiredVariables().stream()).collect(ImmutableCollectors.toSet());
        if (notInternallyRequiredByAtLeastAChild.isEmpty()) {
            return notInternallyRequiredByAtLeastAChild;
        }
        ImmutableMultiset childVariableMultiset = (ImmutableMultiset)children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toMultiset());
        return (ImmutableSet)childVariableMultiset.entrySet().stream().filter(e -> e.getCount() == 1).map(Multiset.Entry::getElement).filter(arg_0 -> ((ImmutableSet)notInternallyRequiredByAtLeastAChild).contains(arg_0)).filter(v -> !conditionVariables.contains(v)).collect(ImmutableCollectors.toSet());
    }

    protected boolean isDistinct(IQTree tree, ImmutableList<IQTree> children) {
        if (children.stream().allMatch(IQTree::isDistinct)) {
            return true;
        }
        ImmutableSet<ImmutableSet<Variable>> constraints = tree.inferUniqueConstraints();
        if (constraints.isEmpty()) {
            return false;
        }
        VariableNullability variableNullability = tree.getVariableNullability();
        return constraints.stream().anyMatch(c -> c.stream().noneMatch(variableNullability::isPossiblyNullable));
    }
}

