/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.node.DummyVariableNullability;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.ConstructionNodeTools;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterNodeImpl;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.FilterNormalizer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionTools;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;

public class FilterNodeImpl
extends JoinOrFilterNodeImpl
implements FilterNode {
    private static final String FILTER_NODE_STR = "FILTER";
    private final ConstructionNodeTools constructionNodeTools;
    private final ConditionSimplifier conditionSimplifier;
    private final CoreUtilsFactory coreUtilsFactory;
    private final FilterNormalizer normalizer;
    private final JoinOrFilterVariableNullabilityTools variableNullabilityTools;

    @AssistedInject
    private FilterNodeImpl(@Assisted ImmutableExpression filterCondition, TermNullabilityEvaluator nullabilityEvaluator, TermFactory termFactory, TypeFactory typeFactory, SubstitutionFactory substitutionFactory, ImmutableUnificationTools unificationTools, ImmutableSubstitutionTools substitutionTools, IntermediateQueryFactory iqFactory, ConstructionNodeTools constructionNodeTools, ConditionSimplifier conditionSimplifier, CoreUtilsFactory coreUtilsFactory, FilterNormalizer normalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools) {
        super(Optional.of(filterCondition), nullabilityEvaluator, termFactory, iqFactory, typeFactory, substitutionFactory, unificationTools, substitutionTools);
        this.constructionNodeTools = constructionNodeTools;
        this.conditionSimplifier = conditionSimplifier;
        this.coreUtilsFactory = coreUtilsFactory;
        this.normalizer = normalizer;
        this.variableNullabilityTools = variableNullabilityTools;
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public FilterNode clone() {
        return this.iqFactory.createFilterNode(this.getFilterCondition());
    }

    @Override
    public FilterNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableExpression getFilterCondition() {
        return this.getOptionalFilterCondition().get();
    }

    @Override
    public FilterNode changeFilterCondition(ImmutableExpression newFilterCondition) {
        return this.iqFactory.createFilterNode(newFilterCondition);
    }

    @Override
    public boolean isVariableNullable(IntermediateQuery query, Variable variable) {
        if (this.isFilteringNullValue(variable)) {
            return false;
        }
        return query.getFirstChild(this).map(c -> c.isVariableNullable(query, variable)).orElseThrow(() -> new InvalidIntermediateQueryException("A filter node must have a child"));
    }

    @Override
    public VariableNullability getVariableNullability(IQTree child) {
        return this.variableNullabilityTools.updateWithFilter(this.getFilterCondition(), child.getVariableNullability().getNullableGroups(), child.getVariables());
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, IQTree child, VariableGenerator variableGenerator) {
        IQTree newChild = child.liftIncompatibleDefinitions(variable, variableGenerator);
        QueryNode newChildRoot = newChild.getRootNode();
        if (newChildRoot instanceof UnionNode && ((UnionNode)newChildRoot).hasAChildWithLiftableDefinition(variable, newChild.getChildren())) {
            UnionNode unionNode = (UnionNode)newChildRoot;
            ImmutableList<IQTree> grandChildren = newChild.getChildren();
            ImmutableList newChildren = (ImmutableList)grandChildren.stream().map(c -> this.iqFactory.createUnaryIQTree(this, (IQTree)c)).collect(ImmutableCollectors.toList());
            return this.iqFactory.createNaryIQTree(unionNode, (ImmutableList<IQTree>)newChildren);
        }
        return this.iqFactory.createUnaryIQTree(this, newChild);
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, IQTree child) {
        return this.propagateDownCondition(child, Optional.of(constraint));
    }

    private IQTree propagateDownCondition(IQTree child, Optional<ImmutableExpression> initialConstraint) {
        try {
            VariableNullability childVariableNullability = child.getVariableNullability();
            ConditionSimplifier.ExpressionAndSubstitution conditionSimplificationResults = this.conditionSimplifier.simplifyCondition(this.getFilterCondition(), childVariableNullability);
            Optional<ImmutableExpression> downConstraint = this.conditionSimplifier.computeDownConstraint(initialConstraint, conditionSimplificationResults, childVariableNullability);
            IQTree newChild = Optional.of(conditionSimplificationResults.getSubstitution()).filter(s -> !s.isEmpty()).map(s -> child.applyDescendingSubstitution((ImmutableSubstitution<? extends VariableOrGroundTerm>)s, downConstraint)).orElseGet(() -> downConstraint.map(child::propagateDownConstraint).orElse(child));
            IQTree filterLevelTree = conditionSimplificationResults.getOptionalExpression().map(e -> e.equals(this.getFilterCondition()) ? this : this.iqFactory.createFilterNode((ImmutableExpression)e)).map(filterNode -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)filterNode, newChild)).orElse(newChild);
            return Optional.of(conditionSimplificationResults.getSubstitution()).filter(s -> !s.isEmpty()).map(s -> s).map(s -> this.iqFactory.createConstructionNode(child.getVariables(), (ImmutableSubstitution<ImmutableTerm>)s)).map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, filterLevelTree)).orElse(filterLevelTree);
        }
        catch (UnsatisfiableConditionException e2) {
            return this.iqFactory.createEmptyNode(child.getVariables());
        }
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, IQTree child) {
        return transformer.transformFilter(tree, this, child);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, IQTree child) {
        return visitor.visitFilter(this, child);
    }

    @Override
    public void validateNode(IQTree child) throws InvalidIntermediateQueryException {
        this.checkExpression(this.getFilterCondition(), (ImmutableList<IQTree>)ImmutableList.of((Object)child));
    }

    @Override
    public ImmutableSet<ImmutableSubstitution<NonVariableTerm>> getPossibleVariableDefinitions(IQTree child) {
        return child.getPossibleVariableDefinitions();
    }

    @Override
    public IQTree removeDistincts(IQTree child, IQProperties iqProperties) {
        IQTree newChild = child.removeDistincts();
        IQProperties newProperties = newChild.equals(child) ? iqProperties.declareDistinctRemovalWithoutEffect() : iqProperties.declareDistinctRemovalWithEffect();
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this, newChild, newProperties);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(IQTree child) {
        return child.inferUniqueConstraints();
    }

    @Override
    public ImmutableSet<Variable> computeNotInternallyRequiredVariables(IQTree child) {
        return this.computeNotInternallyRequiredVariables((ImmutableList<IQTree>)ImmutableList.of((Object)child));
    }

    @Override
    public boolean isConstructed(Variable variable, IQTree child) {
        return child.isConstructed(variable);
    }

    @Override
    public boolean isDistinct(IQTree tree, IQTree child) {
        return this.isDistinct(tree, (ImmutableList<IQTree>)ImmutableList.of((Object)child));
    }

    @Override
    public boolean isSyntacticallyEquivalentTo(QueryNode node) {
        return node instanceof FilterNode && ((FilterNode)node).getFilterCondition().equals(this.getFilterCondition());
    }

    @Override
    public ImmutableSet<Variable> getRequiredVariables(IntermediateQuery query) {
        return this.getLocallyRequiredVariables();
    }

    @Override
    public boolean isEquivalentTo(QueryNode queryNode) {
        return queryNode instanceof FilterNode && this.getFilterCondition().equals(((FilterNode)queryNode).getFilterCondition());
    }

    public String toString() {
        return FILTER_NODE_STR + this.getOptionalFilterString();
    }

    @Override
    public IQTree normalizeForOptimization(IQTree initialChild, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        return this.normalizer.normalizeForOptimization(this, initialChild, variableGenerator, currentIQProperties);
    }

    @Override
    public IQTree applyDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree child) {
        ImmutableExpression unoptimizedExpression = descendingSubstitution.applyToBooleanExpression(this.getFilterCondition());
        ImmutableSet<Variable> newlyProjectedVariables = this.constructionNodeTools.computeNewProjectedVariables(descendingSubstitution, child.getVariables());
        DummyVariableNullability dummyVariableNullability = this.coreUtilsFactory.createDummyVariableNullability(newlyProjectedVariables.stream());
        try {
            ConditionSimplifier.ExpressionAndSubstitution expressionAndSubstitution = this.conditionSimplifier.simplifyCondition(unoptimizedExpression, dummyVariableNullability);
            Optional<ImmutableExpression> downConstraint = this.conditionSimplifier.computeDownConstraint(constraint, expressionAndSubstitution, dummyVariableNullability);
            ImmutableSubstitution<VariableOrGroundTerm> downSubstitution = descendingSubstitution.composeWith2(expressionAndSubstitution.getSubstitution());
            IQTree newChild = child.applyDescendingSubstitution(downSubstitution, downConstraint);
            IQTree filterLevelTree = expressionAndSubstitution.getOptionalExpression().map(this.iqFactory::createFilterNode).map(n -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, newChild)).orElse(newChild);
            return expressionAndSubstitution.getSubstitution().isEmpty() ? filterLevelTree : this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode(newlyProjectedVariables, expressionAndSubstitution.getSubstitution()), filterLevelTree);
        }
        catch (UnsatisfiableConditionException e) {
            return this.iqFactory.createEmptyNode(newlyProjectedVariables);
        }
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree child) {
        FilterNode newFilterNode = this.iqFactory.createFilterNode(descendingSubstitution.applyToBooleanExpression(this.getFilterCondition()));
        return this.iqFactory.createUnaryIQTree(newFilterNode, child.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution));
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveVar2VarSubstitution renamingSubstitution, IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.applyFreshRenaming(renamingSubstitution);
        ImmutableExpression newCondition = renamingSubstitution.applyToBooleanExpression(this.getFilterCondition());
        FilterNodeImpl newFilterNode = newCondition.equals(this.getFilterCondition()) ? this : this.iqFactory.createFilterNode(newCondition);
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newFilterNode, newChild, newTreeCache);
    }
}

