/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.LeafIQTreeImpl;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ExtensionalDataNodeImpl
extends LeafIQTreeImpl
implements ExtensionalDataNode {
    private static final String EXTENSIONAL_NODE_STR = "EXTENSIONAL";
    private final RelationDefinition relationDefinition;
    private final ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap;
    @Nullable
    private ImmutableSet<Variable> variables;
    @Nullable
    private ImmutableSet<Variable> notInternallyRequiredVariables;
    @Nullable
    private VariableNullability variableNullability;
    @Nullable
    private ImmutableSet<ImmutableSet<Variable>> uniqueConstraints;
    @Nullable
    private Boolean isDistinct;
    private final CoreUtilsFactory coreUtilsFactory;

    @AssistedInject
    private ExtensionalDataNodeImpl(@Assisted RelationDefinition relationDefinition, @Assisted ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, CoreUtilsFactory coreUtilsFactory) {
        super(iqTreeTools, iqFactory);
        this.coreUtilsFactory = coreUtilsFactory;
        this.relationDefinition = relationDefinition;
        this.argumentMap = argumentMap;
    }

    @AssistedInject
    private ExtensionalDataNodeImpl(@Assisted RelationDefinition relationDefinition, @Assisted ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap, @Assisted VariableNullability variableNullability, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, CoreUtilsFactory coreUtilsFactory) {
        super(iqTreeTools, iqFactory);
        this.coreUtilsFactory = coreUtilsFactory;
        this.relationDefinition = relationDefinition;
        this.argumentMap = argumentMap;
        this.variableNullability = variableNullability;
    }

    @Override
    public RelationDefinition getRelationDefinition() {
        return this.relationDefinition;
    }

    @Override
    public ImmutableMap<Integer, ? extends VariableOrGroundTerm> getArgumentMap() {
        return this.argumentMap;
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExtensionalDataNode clone() {
        return this.iqFactory.createExtensionalDataNode(this.relationDefinition, this.argumentMap);
    }

    @Override
    public ExtensionalDataNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution) {
        ImmutableMap<Integer, VariableOrGroundTerm> newArguments = descendingSubstitution.applyToArgumentMap(this.argumentMap);
        return this.iqFactory.createExtensionalDataNode(this.relationDefinition, newArguments);
    }

    @Override
    public boolean isVariableNullable(IntermediateQuery query, Variable variable) {
        if (!this.getVariables().contains((Object)variable)) {
            throw new IllegalArgumentException("The variable " + variable + " is not projected by " + this);
        }
        return this.argumentMap.entrySet().stream().filter(e -> ((VariableOrGroundTerm)e.getValue()).equals(variable)).map(e -> (Integer)e.getKey() + 1).map(this.relationDefinition::getAttribute).allMatch(Attribute::isNullable);
    }

    @Override
    public IQTree acceptTransformer(IQTreeVisitingTransformer transformer) {
        return transformer.transformExtensionalData(this);
    }

    @Override
    public synchronized boolean isDistinct() {
        if (this.isDistinct == null) {
            this.isDistinct = this.relationDefinition.getUniqueConstraints().stream().map(FunctionalDependency::getDeterminants).anyMatch(this::areDeterminantsPresentAndNotNull);
        }
        return this.isDistinct;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areDeterminantsPresentAndNotNull(ImmutableSet<Attribute> determinants) {
        ImmutableList arguments = (ImmutableList)determinants.stream().map(a -> Optional.ofNullable(this.argumentMap.get((Object)(a.getIndex() - 1)))).collect(ImmutableCollectors.toList());
        VariableNullability variableNullability = this.getVariableNullability();
        if (!arguments.stream().allMatch(Optional::isPresent)) return false;
        if (!arguments.stream().map(Optional::get).filter(t -> t instanceof Variable).map(v -> (Variable)v).noneMatch(variableNullability::isPossiblyNullable)) return false;
        return true;
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor) {
        return visitor.visitExtensionalData(this);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveVar2VarSubstitution freshRenamingSubstitution) {
        ImmutableMap<Integer, VariableOrGroundTerm> newArgumentMap = freshRenamingSubstitution.applyToArgumentMap(this.argumentMap);
        return this.variableNullability == null ? this.iqFactory.createExtensionalDataNode(this.relationDefinition, newArgumentMap) : this.iqFactory.createExtensionalDataNode(this.relationDefinition, newArgumentMap, this.variableNullability.applyFreshRenaming(freshRenamingSubstitution));
    }

    @Override
    public synchronized VariableNullability getVariableNullability() {
        if (this.variableNullability == null) {
            ImmutableMultiset argMultiset = ImmutableMultiset.copyOf((Iterable)this.argumentMap.values());
            ImmutableSet nullableGroups = (ImmutableSet)this.argumentMap.entrySet().stream().filter(e -> e.getValue() instanceof Variable).filter(e -> this.relationDefinition.getAttribute((Integer)e.getKey() + 1).isNullable()).map(Map.Entry::getValue).map(a -> (Variable)a).filter(a -> argMultiset.count(a) < 2).map(ImmutableSet::of).collect(ImmutableCollectors.toSet());
            this.variableNullability = this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, this.getVariables());
        }
        return this.variableNullability;
    }

    @Override
    public void validate() throws InvalidIntermediateQueryException {
    }

    @Override
    public synchronized ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints() {
        if (this.uniqueConstraints == null) {
            this.uniqueConstraints = (ImmutableSet)this.relationDefinition.getUniqueConstraints().stream().map(this::convertUniqueConstraint).filter(Optional::isPresent).map(Optional::get).collect(ImmutableCollectors.toSet());
        }
        return this.uniqueConstraints;
    }

    private Optional<ImmutableSet<Variable>> convertUniqueConstraint(UniqueConstraint uniqueConstraint) {
        ImmutableList arguments = (ImmutableList)uniqueConstraint.getDeterminants().stream().map(a -> Optional.ofNullable(this.argumentMap.get((Object)(a.getIndex() - 1)))).collect(ImmutableCollectors.toList());
        if (!arguments.stream().allMatch(Optional::isPresent)) {
            return Optional.empty();
        }
        return Optional.of(arguments.stream().map(Optional::get).filter(t -> t instanceof Variable).map(v -> (Variable)v).collect(ImmutableCollectors.toSet()));
    }

    @Override
    public synchronized ImmutableSet<Variable> getNotInternallyRequiredVariables() {
        if (this.notInternallyRequiredVariables == null) {
            ImmutableMultiset multiset = (ImmutableMultiset)this.argumentMap.values().stream().filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toMultiset());
            this.notInternallyRequiredVariables = (ImmutableSet)multiset.entrySet().stream().filter(e -> e.getCount() == 1).map(Multiset.Entry::getElement).collect(ImmutableCollectors.toSet());
        }
        return this.notInternallyRequiredVariables;
    }

    @Override
    public boolean isSyntacticallyEquivalentTo(QueryNode node) {
        return node instanceof ExtensionalDataNode && ((ExtensionalDataNode)node).getRelationDefinition().equals(this.relationDefinition) && ((ExtensionalDataNode)node).getArgumentMap().equals(this.argumentMap);
    }

    @Override
    public boolean isEquivalentTo(QueryNode queryNode) {
        return this.isSyntacticallyEquivalentTo(queryNode);
    }

    public String toString() {
        return String.format("%s %s(%s)", EXTENSIONAL_NODE_STR, this.relationDefinition.getAtomPredicate().getName(), this.argumentMap.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.joining(",")));
    }

    @Override
    public ImmutableSet<Variable> getVariables() {
        return this.getLocalVariables();
    }

    @Override
    public synchronized ImmutableSet<Variable> getLocalVariables() {
        if (this.variables == null) {
            this.variables = (ImmutableSet)this.argumentMap.values().stream().filter(Variable.class::isInstance).map(Variable.class::cast).collect(ImmutableCollectors.toSet());
        }
        return this.variables;
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return this.getLocalVariables();
    }

    @Override
    public ImmutableSet<Variable> getRequiredVariables(IntermediateQuery query) {
        return this.getLocallyRequiredVariables();
    }

    @Override
    public ImmutableSet<Variable> getKnownVariables() {
        return this.getLocalVariables();
    }

    @Override
    public boolean isDeclaredAsEmpty() {
        return false;
    }
}

