/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelConfiguration;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.impl.OntopModelModule;
import it.unibz.inf.ontop.injection.impl.OntopModelSettingsImpl;
import it.unibz.inf.ontop.iq.executor.ProposalExecutor;
import it.unibz.inf.ontop.iq.proposal.QueryOptimizationProposal;
import it.unibz.inf.ontop.iq.tools.ExecutorRegistry;
import it.unibz.inf.ontop.iq.tools.impl.StandardExecutorRegistry;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.RDF;

public class OntopModelConfigurationImpl
implements OntopModelConfiguration {
    private final OntopModelConfigurationOptions options;
    @Nullable
    private final Supplier<Injector> injectorSupplier;
    private final OntopModelSettings settings;
    @Nullable
    private ExecutorRegistry executorRegistry;
    @Nullable
    private Injector injector;

    protected OntopModelConfigurationImpl(@Nonnull OntopModelSettings settings, @Nonnull OntopModelConfigurationOptions options) {
        this.settings = settings;
        this.options = options;
        this.executorRegistry = null;
        this.injector = null;
        this.injectorSupplier = null;
    }

    protected OntopModelConfigurationImpl(@Nonnull OntopModelSettings settings, @Nonnull OntopModelConfigurationOptions options, @Nonnull Supplier<Injector> injectorSupplier) {
        this.settings = settings;
        this.options = options;
        this.injectorSupplier = injectorSupplier;
        this.executorRegistry = null;
        this.injector = null;
    }

    @Override
    public ExecutorRegistry getExecutorRegistry() {
        if (this.executorRegistry == null) {
            this.executorRegistry = new StandardExecutorRegistry(this.getInjector(), this.generateOptimizationConfigurationMap());
        }
        return this.executorRegistry;
    }

    @Override
    public final Injector getInjector() {
        if (this.injector == null) {
            if (this.injectorSupplier != null) {
                this.injector = this.injectorSupplier.get();
            } else {
                HashSet moduleClasses = new HashSet();
                ImmutableList modules = (ImmutableList)this.buildGuiceModules().filter(m -> moduleClasses.add(m.getClass())).collect(ImmutableCollectors.toList());
                this.injector = Guice.createInjector((Iterable)modules);
            }
        }
        return this.injector;
    }

    protected ImmutableMap<Class<? extends QueryOptimizationProposal>, Class<? extends ProposalExecutor>> generateOptimizationConfigurationMap() {
        return ImmutableMap.of();
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.of(new OntopModelModule(this));
    }

    @Override
    public void validate() throws InvalidOntopConfigurationException {
    }

    @Override
    public IntermediateQueryFactory getIQFactory() {
        return (IntermediateQueryFactory)this.getInjector().getInstance(IntermediateQueryFactory.class);
    }

    @Override
    public AtomFactory getAtomFactory() {
        return (AtomFactory)this.getInjector().getInstance(AtomFactory.class);
    }

    @Override
    public TermFactory getTermFactory() {
        return (TermFactory)this.getInjector().getInstance(TermFactory.class);
    }

    @Override
    public TypeFactory getTypeFactory() {
        return (TypeFactory)this.getInjector().getInstance(TypeFactory.class);
    }

    @Override
    public RDF getRdfFactory() {
        return (RDF)this.getInjector().getInstance(RDF.class);
    }

    @Override
    public OntopModelSettings getSettings() {
        return this.settings;
    }

    public static File extractPropertyFile(String propertyFilePath) {
        try {
            URI fileURI = new URI(propertyFilePath);
            String scheme = fileURI.getScheme();
            if (scheme == null) {
                return new File(fileURI.getPath());
            }
            if (scheme.equals("file")) {
                return new File(fileURI);
            }
            throw new InvalidOntopConfigurationException("Currently only local property files are supported.");
        }
        catch (URISyntaxException e) {
            throw new InvalidOntopConfigurationException("Invalid property file path: " + e.getMessage());
        }
    }

    public static Properties extractProperties(File propertyFile) throws InvalidOntopConfigurationException {
        try {
            Properties p = new Properties();
            p.load(new FileReader(propertyFile));
            return p;
        }
        catch (IOException e) {
            throw new InvalidOntopConfigurationException("Cannot reach the property file: " + propertyFile);
        }
    }

    public static final class BuilderImpl<B extends OntopModelConfiguration.Builder<B>>
    extends DefaultOntopModelBuilderFragment<B>
    implements OntopModelConfiguration.Builder<B> {
        @Override
        public final OntopModelConfiguration build() {
            Properties p = this.generateProperties();
            return new OntopModelConfigurationImpl(new OntopModelSettingsImpl(p), this.generateModelOptions());
        }
    }

    protected static class DefaultOntopModelBuilderFragment<B extends OntopModelConfiguration.Builder<B>>
    implements OntopModelConfiguration.OntopModelBuilderFragment<B> {
        private final B builder;
        private Optional<Boolean> testMode = Optional.empty();
        private Optional<Properties> inputProperties = Optional.empty();

        protected DefaultOntopModelBuilderFragment(B builder) {
            this.builder = builder;
        }

        private DefaultOntopModelBuilderFragment() {
            this.builder = (OntopModelConfiguration.Builder)((Object)this);
        }

        @Override
        public final B properties(@Nonnull Properties properties) {
            this.inputProperties = Optional.of(properties);
            return this.builder;
        }

        @Override
        public final B propertyFile(String propertyFilePath) {
            return this.propertyFile(OntopModelConfigurationImpl.extractPropertyFile(propertyFilePath));
        }

        @Override
        public final B propertyFile(File propertyFile) {
            return this.properties(OntopModelConfigurationImpl.extractProperties(propertyFile));
        }

        @Override
        public B enableTestMode() {
            this.testMode = Optional.of(true);
            return this.builder;
        }

        protected Properties generateProperties() {
            Properties properties = new Properties();
            this.inputProperties.ifPresent(properties::putAll);
            this.testMode.ifPresent(isEnabled -> properties.put("ontop.testMode", isEnabled));
            return properties;
        }

        protected final OntopModelConfigurationOptions generateModelOptions() {
            return new OntopModelConfigurationOptions();
        }
    }

    public static class OntopModelConfigurationOptions {
    }
}

