package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.*;
import it.unibz.inf.ontop.utils.ImmutableCollectors;


public class ImmutableMetadataProvider extends ImmutableMetadataLookup implements MetadataProvider {

    private final DBParameters dbParameters;
    private final ImmutableList<RelationID> relationIds;

    ImmutableMetadataProvider(DBParameters dbParameters, ImmutableMap<RelationID, DatabaseRelationDefinition> map) {
        super(dbParameters.getQuotedIDFactory(), map);
        this.dbParameters = dbParameters;
        this.relationIds = getRelations().stream()
                .map(DatabaseRelationDefinition::getID)
                .collect(ImmutableCollectors.toList());
    }

    @Override
    public DBParameters getDBParameters() { return dbParameters; }

    @Override
    public ImmutableList<RelationID> getRelationIDs()  { return relationIds; }

    @Override
    public void insertIntegrityConstraints(DatabaseRelationDefinition relation, MetadataLookup metadataLookup) {
        // NO-OP
    }
}
