/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.common.base.Joiner;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.Function;
import it.unibz.inf.ontop.model.term.Term;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.impl.FunctionalTermImpl;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.impl.SingletonSubstitution;
import it.unibz.inf.ontop.substitution.impl.SubstitutionUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubstitutionImpl
implements Substitution {
    private final Map<Variable, Term> map;
    private final TermFactory termFactory;

    public SubstitutionImpl(TermFactory termFactory) {
        this.termFactory = termFactory;
        this.map = new HashMap<Variable, Term>();
    }

    public SubstitutionImpl(Map<Variable, Term> substitutionMap, TermFactory termFactory) {
        this.termFactory = termFactory;
        this.map = substitutionMap;
    }

    @Override
    public Term get(Variable var) {
        return this.map.get(var);
    }

    @Override
    public Map<Variable, Term> getMap() {
        return this.map;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Deprecated
    public Set<Variable> keySet() {
        return this.map.keySet();
    }

    public String toString() {
        return Joiner.on((String)", ").withKeyValueSeparator("/").join(this.map);
    }

    @Override
    public boolean composeTerms(Term term1, Term term2) {
        if (term1 instanceof Function && term2 instanceof Function) {
            return this.composeFunctions((Function)term1, (Function)term2);
        }
        Substitution s = SubstitutionImpl.createUnifier(term1, term2, this.termFactory);
        if (s == null) {
            return false;
        }
        if (s.isEmpty()) {
            return true;
        }
        SingletonSubstitution substitution = (SingletonSubstitution)s;
        ArrayList<Variable> forRemoval = new ArrayList<Variable>();
        for (Map.Entry<Variable, Term> entry : this.map.entrySet()) {
            FunctionalTermImpl fclone;
            boolean innerchanges;
            Variable v = entry.getKey();
            Term t = entry.getValue();
            if (substitution.getVariable().equals(t)) {
                if (v.equals(substitution.getTerm())) {
                    forRemoval.add(v);
                    continue;
                }
                this.map.put(v, substitution.getTerm());
                continue;
            }
            if (!(t instanceof FunctionalTermImpl) || !(innerchanges = SubstitutionImpl.applySingletonSubstitution(fclone = (FunctionalTermImpl)t.clone(), substitution))) continue;
            this.map.put(v, fclone);
        }
        this.map.keySet().removeAll(forRemoval);
        this.map.put(substitution.getVariable(), substitution.getTerm());
        return true;
    }

    private static boolean applySingletonSubstitution(Function functionalTerm, SingletonSubstitution substitution) {
        List<Term> innerTerms = functionalTerm.getTerms();
        boolean innerchanges = false;
        for (int i = 0; i < innerTerms.size(); ++i) {
            Term innerTerm = innerTerms.get(i);
            if (innerTerm instanceof Function) {
                boolean newChange = SubstitutionImpl.applySingletonSubstitution((Function)innerTerm, substitution);
                innerchanges = innerchanges || newChange;
                continue;
            }
            if (!substitution.getVariable().equals(innerTerm)) continue;
            functionalTerm.getTerms().set(i, substitution.getTerm());
            innerchanges = true;
        }
        return innerchanges;
    }

    @Override
    public boolean composeFunctions(Function first, Function second) {
        if (first.getArity() != second.getArity() || !first.getFunctionSymbol().equals(second.getFunctionSymbol())) {
            return false;
        }
        Function firstAtom = (Function)first.clone();
        Function secondAtom = (Function)second.clone();
        int arity = first.getArity();
        for (int termidx = 0; termidx < arity; ++termidx) {
            Term term2;
            Term term1 = firstAtom.getTerm(termidx);
            if (!this.composeTerms(term1, term2 = secondAtom.getTerm(termidx))) {
                return false;
            }
            SubstitutionUtilities.applySubstitution(firstAtom, this, termidx + 1);
            SubstitutionUtilities.applySubstitution(secondAtom, this, termidx + 1);
        }
        return true;
    }

    private static Substitution createUnifier(Term term1, Term term2, TermFactory termFactory) {
        Term t2;
        Variable t1;
        if (!(term1 instanceof Variable) && !(term2 instanceof Variable)) {
            if (term1 instanceof FunctionalTermImpl || term1 instanceof Constant) {
                if (term1.equals(term2)) {
                    return new SubstitutionImpl(termFactory);
                }
                return null;
            }
            throw new RuntimeException("Exception comparing two terms, unknown term class. Terms: " + term1 + ", " + term2 + " Classes: " + term1.getClass() + ", " + term2.getClass());
        }
        if (term1 instanceof Variable) {
            t1 = (Variable)term1;
            t2 = term2;
        } else {
            t1 = (Variable)term2;
            t2 = term1;
        }
        if (t2 instanceof Variable) {
            if (t1.equals(t2)) {
                return new SubstitutionImpl(termFactory);
            }
            return new SingletonSubstitution(t1, t2);
        }
        if (t2 instanceof Constant) {
            return new SingletonSubstitution(t1, t2);
        }
        if (t2 instanceof Function) {
            Function fterm = (Function)t2;
            if (fterm.containsTerm(t1)) {
                return null;
            }
            return new SingletonSubstitution(t1, t2);
        }
        throw new RuntimeException("Unsupported unification case: " + term1 + " " + term2);
    }
}

