/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.Term;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.impl.ImmutabilityTools;
import it.unibz.inf.ontop.model.term.impl.PredicateImpl;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionTools;
import it.unibz.inf.ontop.substitution.impl.UnifierUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Singleton
public class ImmutableUnificationTools {
    private final SubstitutionFactory substitutionFactory;
    private final ImmutableSubstitutionTools substitutionTools;
    private final UnifierUtilities unifierUtilities;
    private final ImmutabilityTools immutabilityTools;

    @Inject
    private ImmutableUnificationTools(SubstitutionFactory substitutionFactory, ImmutableSubstitutionTools substitutionTools, UnifierUtilities unifierUtilities, ImmutabilityTools immutabilityTools) {
        this.substitutionFactory = substitutionFactory;
        this.substitutionTools = substitutionTools;
        this.unifierUtilities = unifierUtilities;
        this.immutabilityTools = immutabilityTools;
    }

    public <T extends ImmutableTerm> Optional<ImmutableSubstitution<T>> computeMGU(ImmutableList<T> args1, ImmutableList<T> args2) {
        if (args1.size() != args2.size()) {
            throw new IllegalArgumentException("The two argument lists must have the same size");
        }
        TemporaryFunctionSymbol functionSymbol = new TemporaryFunctionSymbol(args1.size());
        Substitution mutableSubstitution = this.unifierUtilities.getMGU(this.immutabilityTools.convertToMutableFunction(functionSymbol, args1), this.immutabilityTools.convertToMutableFunction(functionSymbol, args2));
        if (mutableSubstitution == null) {
            return Optional.empty();
        }
        return Optional.of(this.substitutionTools.convertMutableSubstitution(mutableSubstitution)).map(s -> s);
    }

    public Optional<ImmutableSubstitution<VariableOrGroundTerm>> computeAtomMGU(DataAtom atom1, DataAtom atom2) {
        Substitution mutableSubstitution = this.unifierUtilities.getMGU(this.immutabilityTools.convertToMutableFunction(atom1), this.immutabilityTools.convertToMutableFunction(atom2));
        if (mutableSubstitution == null) {
            return Optional.empty();
        }
        ImmutableMap.Builder substitutionMapBuilder = ImmutableMap.builder();
        for (Map.Entry<Variable, Term> entry : mutableSubstitution.getMap().entrySet()) {
            VariableOrGroundTerm value = this.immutabilityTools.convertIntoVariableOrGroundTerm(entry.getValue());
            substitutionMapBuilder.put((Object)entry.getKey(), (Object)value);
        }
        ImmutableSubstitution immutableSubstitution = this.substitutionFactory.getSubstitution(substitutionMapBuilder.build());
        return Optional.of(immutableSubstitution);
    }

    public Optional<ImmutableSubstitution<NonFunctionalTerm>> computeMGUS2(ImmutableSubstitution<NonFunctionalTerm> s1, ImmutableSubstitution<NonFunctionalTerm> s2) {
        return this.computeMGUS(s1, s2).map(u -> u);
    }

    public Optional<ImmutableSubstitution<ImmutableTerm>> computeMGUS(ImmutableSubstitution<? extends ImmutableTerm> substitution1, ImmutableSubstitution<? extends ImmutableTerm> substitution2) {
        ImmutableList.Builder firstArgListBuilder = ImmutableList.builder();
        ImmutableList.Builder secondArgListBuilder = ImmutableList.builder();
        for (Map.Entry entry : substitution1.getImmutableMap().entrySet()) {
            firstArgListBuilder.add(entry.getKey());
            secondArgListBuilder.add(entry.getValue());
        }
        for (Map.Entry entry : substitution2.getImmutableMap().entrySet()) {
            firstArgListBuilder.add(entry.getKey());
            secondArgListBuilder.add(entry.getValue());
        }
        ImmutableList firstArgList = firstArgListBuilder.build();
        ImmutableList secondArgList = secondArgListBuilder.build();
        return this.computeMGU(firstArgList, secondArgList);
    }

    public Optional<ImmutableSubstitution<VariableOrGroundTerm>> computeAtomMGUS(ImmutableSubstitution<VariableOrGroundTerm> substitution1, ImmutableSubstitution<VariableOrGroundTerm> substitution2) {
        Optional<ImmutableSubstitution<ImmutableTerm>> optionalMGUS = this.computeMGUS(substitution1, substitution2);
        return optionalMGUS.map(this.substitutionTools::convertIntoVariableOrGroundTermSubstitution);
    }

    public Optional<ImmutableSubstitution<ImmutableTerm>> computeDirectedMGU(ImmutableTerm sourceTerm, ImmutableTerm targetTerm) {
        if (sourceTerm instanceof Variable) {
            Variable sourceVariable = (Variable)sourceTerm;
            if (targetTerm instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)targetTerm).getVariables().contains((Object)sourceVariable)) {
                return Optional.empty();
            }
            ImmutableSubstitution substitution = sourceVariable.equals(targetTerm) ? this.substitutionFactory.getSubstitution() : this.substitutionFactory.getSubstitution(ImmutableMap.of((Object)sourceVariable, (Object)targetTerm));
            return Optional.of(substitution);
        }
        if (sourceTerm instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm sourceFunctionalTerm = (ImmutableFunctionalTerm)sourceTerm;
            if (targetTerm instanceof Variable) {
                Variable targetVariable = (Variable)targetTerm;
                if (sourceFunctionalTerm.getVariables().contains((Object)targetVariable)) {
                    return Optional.empty();
                }
                ImmutableSubstitution substitution = this.substitutionFactory.getSubstitution(ImmutableMap.of((Object)targetVariable, (Object)sourceTerm));
                return Optional.of(substitution);
            }
            if (targetTerm instanceof ImmutableFunctionalTerm) {
                return this.computeDirectedMGUOfTwoFunctionalTerms((ImmutableFunctionalTerm)sourceTerm, (ImmutableFunctionalTerm)targetTerm);
            }
            return Optional.empty();
        }
        if (sourceTerm instanceof Constant) {
            if (targetTerm instanceof Variable) {
                Variable targetVariable = (Variable)targetTerm;
                ImmutableSubstitution substitution = this.substitutionFactory.getSubstitution(ImmutableMap.of((Object)targetVariable, (Object)sourceTerm));
                return Optional.of(substitution);
            }
            if (sourceTerm.equals(targetTerm)) {
                return Optional.of(this.substitutionFactory.getSubstitution());
            }
            return Optional.empty();
        }
        throw new RuntimeException("Unexpected term: " + sourceTerm + " (" + sourceTerm.getClass() + ")");
    }

    private Optional<ImmutableSubstitution<ImmutableTerm>> computeDirectedMGUOfTwoFunctionalTerms(ImmutableFunctionalTerm sourceTerm, ImmutableFunctionalTerm targetTerm) {
        if (!sourceTerm.getFunctionSymbol().equals(targetTerm.getFunctionSymbol())) {
            return Optional.empty();
        }
        ImmutableList<? extends ImmutableTerm> sourceChildren = sourceTerm.getTerms();
        ImmutableList<? extends ImmutableTerm> targetChildren = targetTerm.getTerms();
        int childNb = sourceChildren.size();
        if (targetChildren.size() != childNb) {
            return Optional.empty();
        }
        ImmutableList.Builder pairBuilder = ImmutableList.builder();
        for (int i = 0; i < childNb; ++i) {
            Optional<ImmutableSubstitution<ImmutableTerm>> optionalChildTermUnifier = this.computeDirectedMGU((ImmutableTerm)sourceChildren.get(i), (ImmutableTerm)targetChildren.get(i));
            if (!optionalChildTermUnifier.isPresent()) {
                return Optional.empty();
            }
            pairBuilder.addAll(this.convertIntoPairs(optionalChildTermUnifier.get()));
        }
        return this.unifyPairs((ImmutableList<TermPair>)pairBuilder.build());
    }

    private Optional<ImmutableSubstitution<ImmutableTerm>> unifyPairs(ImmutableList<TermPair> originalPairs) {
        LinkedList<TermPair> allPairs = new LinkedList<TermPair>((Collection<TermPair>)originalPairs);
        LinkedList<TermPair> pairsToVisit = new LinkedList<TermPair>((Collection<TermPair>)originalPairs);
        try {
            while (!pairsToVisit.isEmpty()) {
                TermPair currentPair = (TermPair)pairsToVisit.poll();
                if (currentPair.canBeRemoved()) continue;
                ImmutableSubstitution<ImmutableTerm> substitution = currentPair.getSubstitution();
                ArrayList<TermPair> additionalPairs = new ArrayList<TermPair>();
                Iterator it = allPairs.iterator();
                while (it.hasNext()) {
                    TermPair pairToUpdate = (TermPair)it.next();
                    if (pairToUpdate == currentPair) continue;
                    additionalPairs.addAll((Collection<TermPair>)pairToUpdate.applySubstitution(substitution));
                    if (!pairToUpdate.canBeRemoved()) continue;
                    it.remove();
                }
                allPairs.addAll(additionalPairs);
                pairsToVisit.addAll(additionalPairs);
            }
            return Optional.of(this.convertPairs2Substitution(allPairs));
        }
        catch (UnificationException e) {
            return Optional.empty();
        }
    }

    private ImmutableList<TermPair> convertIntoPairs(ImmutableSubstitution<? extends ImmutableTerm> substitution) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Map.Entry entry : substitution.getImmutableMap().entrySet()) {
            listBuilder.add((Object)new TermPair((Variable)entry.getKey(), (ImmutableTerm)entry.getValue(), this.substitutionFactory, this));
        }
        return listBuilder.build();
    }

    private ImmutableSubstitution<ImmutableTerm> convertPairs2Substitution(List<TermPair> pairs) throws UnificationException {
        HashMap<Variable, ImmutableTerm> substitutionMap = new HashMap<Variable, ImmutableTerm>();
        for (TermPair pair : pairs) {
            Variable leftVariable = pair.getLeftVariable();
            ImmutableTerm rightTerm = pair.getRightTerm();
            if (!substitutionMap.containsKey(leftVariable)) {
                substitutionMap.put(leftVariable, rightTerm);
                continue;
            }
            if (((ImmutableTerm)substitutionMap.get(leftVariable)).equals(rightTerm)) continue;
            throw new UnificationException();
        }
        return this.substitutionFactory.getSubstitution(ImmutableMap.copyOf(substitutionMap));
    }

    private static class TemporaryFunctionSymbol
    extends PredicateImpl {
        private TemporaryFunctionSymbol(int arity) {
            super("pred", arity);
        }
    }

    private static class TermPair {
        private boolean canBeRemoved;
        private Variable leftVariable;
        private ImmutableTerm rightTerm;
        private final SubstitutionFactory substitutionFactory;
        private final ImmutableUnificationTools unificationTools;

        private TermPair(Variable variable, ImmutableTerm rightTerm, SubstitutionFactory substitutionFactory, ImmutableUnificationTools unificationTools) {
            this.leftVariable = variable;
            this.rightTerm = rightTerm;
            this.substitutionFactory = substitutionFactory;
            this.unificationTools = unificationTools;
            this.canBeRemoved = false;
        }

        public ImmutableList<TermPair> applySubstitution(ImmutableSubstitution<? extends ImmutableTerm> substitution) throws UnificationException {
            if (this.canBeRemoved) {
                return ImmutableList.of();
            }
            ImmutableTerm transformedLeftTerm = substitution.apply(this.leftVariable);
            ImmutableTerm transformedRightTerm = substitution.apply(this.rightTerm);
            if (transformedLeftTerm instanceof Variable) {
                this.leftVariable = (Variable)transformedLeftTerm;
                this.rightTerm = transformedRightTerm;
                return ImmutableList.of();
            }
            if (transformedRightTerm instanceof Variable) {
                this.leftVariable = (Variable)transformedRightTerm;
                this.rightTerm = transformedLeftTerm;
                return ImmutableList.of();
            }
            Optional<ImmutableSubstitution<ImmutableTerm>> optionalUnifier = this.unificationTools.computeDirectedMGU(transformedLeftTerm, transformedRightTerm);
            if (!optionalUnifier.isPresent()) {
                throw new UnificationException();
            }
            this.canBeRemoved = true;
            this.leftVariable = null;
            this.rightTerm = null;
            return this.unificationTools.convertIntoPairs(optionalUnifier.get());
        }

        public ImmutableSubstitution<ImmutableTerm> getSubstitution() {
            if (this.canBeRemoved) {
                return this.substitutionFactory.getSubstitution();
            }
            return this.substitutionFactory.getSubstitution(ImmutableMap.of((Object)this.leftVariable, (Object)this.rightTerm));
        }

        boolean canBeRemoved() {
            return this.canBeRemoved;
        }

        Variable getLeftVariable() {
            return this.leftVariable;
        }

        ImmutableTerm getRightTerm() {
            return this.rightTerm;
        }
    }

    private static class UnificationException
    extends Exception {
        private UnificationException() {
        }
    }
}

