/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.Var2VarSubstitution;
import it.unibz.inf.ontop.substitution.impl.AbstractImmutableSubstitutionImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;

public class ImmutableSubstitutionImpl<T extends ImmutableTerm>
extends AbstractImmutableSubstitutionImpl<T> {
    private final ImmutableMap<Variable, T> map;

    protected ImmutableSubstitutionImpl(ImmutableMap<Variable, ? extends T> substitutionMap, AtomFactory atomFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(atomFactory, termFactory, substitutionFactory);
        this.map = substitutionMap;
        if (substitutionMap.entrySet().stream().anyMatch(e -> ((Variable)e.getKey()).equals(e.getValue()))) {
            throw new IllegalArgumentException("Please do not insert entries like t/t in your substitution (for efficiency reasons)\n. Substitution: " + substitutionMap);
        }
    }

    @Override
    public T get(Variable var) {
        return (T)((ImmutableTerm)this.map.get((Object)var));
    }

    @Override
    public ImmutableMap<Variable, T> getImmutableMap() {
        return this.map;
    }

    @Override
    public boolean isDefining(Variable variable) {
        return this.map.containsKey((Object)variable);
    }

    @Override
    public ImmutableSet<Variable> getDomain() {
        return this.map.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public ImmutableTerm applyToVariable(Variable variable) {
        ImmutableTerm v = (ImmutableTerm)this.map.get((Object)variable);
        return v == null ? variable : v;
    }

    @Override
    public Var2VarSubstitution getVar2VarFragment() {
        ImmutableMap<Variable, Variable> newMap = this.map.entrySet().stream().filter(e -> e.getValue() instanceof Variable).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (Variable)e.getValue()));
        return this.substitutionFactory.getVar2VarSubstitution(newMap);
    }

    @Override
    public ImmutableSubstitution<GroundTerm> getGroundTermFragment() {
        ImmutableMap<Variable, GroundTerm> newMap = this.map.entrySet().stream().filter(e -> e.getValue() instanceof GroundTerm).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (GroundTerm)e.getValue()));
        return this.substitutionFactory.getSubstitution(newMap);
    }

    public String toString() {
        return Joiner.on((String)", ").withKeyValueSeparator("/").join(this.map);
    }

    @Override
    protected ImmutableSubstitution<T> constructNewSubstitution(ImmutableMap<Variable, T> map) {
        return this.substitutionFactory.getSubstitution(map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ImmutableSubstitution && this.map.equals(((ImmutableSubstitution)o).getImmutableMap());
    }
}

