/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.impl.AbstractNonNullConstant;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class RDFLiteralConstantImpl
extends AbstractNonNullConstant
implements RDFLiteralConstant {
    private static final long serialVersionUID = 8031338451909170400L;
    private final String value;
    private final String string;
    private final RDFDatatype termType;

    protected RDFLiteralConstantImpl(@Nonnull String value, @Nonnull RDFDatatype type) {
        this.value = value;
        this.termType = type;
        String suffix = type.getIRI().equals((Object)XSD.STRING) ? "" : "^^" + type.toString();
        this.string = "\"" + value + "\"" + suffix;
    }

    protected RDFLiteralConstantImpl(@Nonnull String value, @Nonnull String language, TypeFactory typeFactory) {
        this.value = value;
        String l = language.toLowerCase();
        this.termType = typeFactory.getLangTermType(l);
        this.string = "\"" + value + "@" + l + "\"";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RDFLiteralConstantImpl)) {
            return false;
        }
        RDFLiteralConstantImpl value2 = (RDFLiteralConstantImpl)obj;
        return this.hashCode() == value2.hashCode();
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public RDFLiteralConstant clone() {
        return this;
    }

    @Override
    public boolean isGround() {
        return true;
    }

    @Override
    public Stream<Variable> getVariableStream() {
        return Stream.of(new Variable[0]);
    }

    @Override
    public IncrementalEvaluation evaluateStrictEq(ImmutableTerm otherTerm, VariableNullability variableNullability) {
        if (otherTerm instanceof RDFLiteralConstant) {
            return this.equals(otherTerm) ? IncrementalEvaluation.declareIsTrue() : IncrementalEvaluation.declareIsFalse();
        }
        if (otherTerm instanceof Constant) {
            return ((Constant)otherTerm).isNull() ? IncrementalEvaluation.declareIsNull() : IncrementalEvaluation.declareIsFalse();
        }
        return otherTerm.evaluateStrictEq(this, variableNullability);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public RDFDatatype getType() {
        return this.termType;
    }

    public String toString() {
        return this.string;
    }
}

