/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBAndFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBOrFunctionSymbol;
import it.unibz.inf.ontop.model.term.impl.ImmutableFunctionalTermImpl;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class ImmutableExpressionImpl
extends ImmutableFunctionalTermImpl
implements ImmutableExpression {
    private final TermFactory termFactory;

    protected ImmutableExpressionImpl(TermFactory termFactory, BooleanFunctionSymbol functor, ImmutableTerm ... terms) {
        super((FunctionSymbol)functor, termFactory, terms);
        this.termFactory = termFactory;
    }

    protected ImmutableExpressionImpl(BooleanFunctionSymbol functor, ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory) {
        super((FunctionSymbol)functor, terms, termFactory);
        this.termFactory = termFactory;
    }

    @Override
    public ImmutableExpressionImpl clone() {
        return this;
    }

    @Override
    public BooleanFunctionSymbol getFunctionSymbol() {
        return (BooleanFunctionSymbol)super.getFunctionSymbol();
    }

    @Override
    public Stream<ImmutableExpression> flattenAND() {
        if (this.getFunctionSymbol() instanceof DBAndFunctionSymbol) {
            return this.getTerms().stream().map(t -> (ImmutableExpression)t).distinct();
        }
        return Stream.of(this);
    }

    @Override
    public Stream<ImmutableExpression> flattenOR() {
        if (this.getFunctionSymbol() instanceof DBOrFunctionSymbol) {
            return this.getTerms().stream().map(t -> (ImmutableExpression)t).distinct();
        }
        return Stream.of(this);
    }

    @Override
    public ImmutableExpression.Evaluation evaluate(VariableNullability variableNullability) {
        ImmutableTerm newTerm = this.simplify(variableNullability);
        return this.convertTermToEvaluation(newTerm, true);
    }

    @Override
    public ImmutableExpression.Evaluation evaluate2VL(VariableNullability variableNullability) {
        ImmutableTerm newTerm = this.simplify2VL(variableNullability);
        return this.convertTermToEvaluation(newTerm, false);
    }

    private ImmutableExpression.Evaluation convertTermToEvaluation(ImmutableTerm newTerm, boolean use3VL) {
        if (newTerm instanceof ImmutableExpression) {
            return this.termFactory.getEvaluation((ImmutableExpression)newTerm);
        }
        if (newTerm.equals(this.termFactory.getDBBooleanConstant(true))) {
            return this.termFactory.getPositiveEvaluation();
        }
        if (newTerm.equals(this.termFactory.getDBBooleanConstant(false))) {
            return this.termFactory.getNegativeEvaluation();
        }
        if (newTerm.equals(this.termFactory.getNullConstant())) {
            return use3VL ? this.termFactory.getNullEvaluation() : this.termFactory.getNegativeEvaluation();
        }
        if (newTerm instanceof NonFunctionalTerm) {
            return this.termFactory.getEvaluation(this.termFactory.getIsTrue((NonFunctionalTerm)newTerm));
        }
        throw new IncorrectExpressionSimplificationBugException(this, newTerm);
    }

    @Override
    public IncrementalEvaluation evaluate(VariableNullability variableNullability, boolean isExpressionNew) {
        return this.evaluate(variableNullability).getEvaluationResult(this, isExpressionNew);
    }

    @Override
    public IncrementalEvaluation evaluate2VL(VariableNullability variableNullability, boolean isExpressionNew) {
        return this.evaluate2VL(variableNullability).getEvaluationResult(this, isExpressionNew);
    }

    @Override
    public ImmutableTerm simplify2VL(VariableNullability variableNullability) {
        return this.getFunctionSymbol().simplify2VL(this.getTerms(), this.termFactory, variableNullability);
    }

    @Override
    public ImmutableExpression negate(TermFactory termFactory) {
        BooleanFunctionSymbol functionSymbol = this.getFunctionSymbol();
        if (functionSymbol.blocksNegation()) {
            return termFactory.getDBNot(this);
        }
        return functionSymbol.negate(this.getTerms(), termFactory);
    }

    private static class IncorrectExpressionSimplificationBugException
    extends OntopInternalBugException {
        protected IncorrectExpressionSimplificationBugException(ImmutableExpression expression, ImmutableTerm resultingTerm) {
            super(String.format("Incorrect simplication of %s: led to %s", expression, resultingTerm));
        }
    }

    protected static class ValueEvaluationImpl
    implements ImmutableExpression.Evaluation {
        private final ImmutableExpression.Evaluation.BooleanValue value;
        private final Constant constant;

        protected ValueEvaluationImpl(ImmutableExpression.Evaluation.BooleanValue value, Constant constant) {
            this.value = value;
            this.constant = constant;
        }

        @Override
        public Optional<ImmutableExpression> getExpression() {
            return Optional.empty();
        }

        @Override
        public Optional<ImmutableExpression.Evaluation.BooleanValue> getValue() {
            return Optional.of(this.value);
        }

        @Override
        public ImmutableTerm getTerm() {
            return this.constant;
        }

        @Override
        public IncrementalEvaluation getEvaluationResult(ImmutableExpression originalExpression, boolean wasExpressionAlreadyNew) {
            switch (this.value) {
                case TRUE: {
                    return IncrementalEvaluation.declareIsTrue();
                }
                case FALSE: {
                    return IncrementalEvaluation.declareIsFalse();
                }
            }
            return IncrementalEvaluation.declareIsNull();
        }
    }

    protected static class ExpressionEvaluationImpl
    implements ImmutableExpression.Evaluation {
        @Nonnull
        private final ImmutableExpression expression;

        protected ExpressionEvaluationImpl(@Nonnull ImmutableExpression expression) {
            this.expression = expression;
        }

        @Override
        public Optional<ImmutableExpression> getExpression() {
            return Optional.of(this.expression);
        }

        @Override
        public Optional<ImmutableExpression.Evaluation.BooleanValue> getValue() {
            return Optional.empty();
        }

        @Override
        public ImmutableTerm getTerm() {
            return this.expression;
        }

        @Override
        public IncrementalEvaluation getEvaluationResult(ImmutableExpression originalExpression, boolean wasExpressionAlreadyNew) {
            return wasExpressionAlreadyNew || !originalExpression.equals(this.expression) ? IncrementalEvaluation.declareSimplifiedExpression(this.expression) : IncrementalEvaluation.declareSameExpression();
        }
    }
}

