/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.Expression;
import it.unibz.inf.ontop.model.term.Function;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Term;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.impl.GroundTermTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

public class ImmutabilityTools {
    private final TermFactory termFactory;

    @Inject
    public ImmutabilityTools(TermFactory termFactory) {
        this.termFactory = termFactory;
    }

    public ImmutableTerm convertIntoImmutableTerm(Term term) {
        if (term instanceof Function) {
            if (term instanceof Expression) {
                Expression expression = (Expression)term;
                return this.termFactory.getImmutableExpression(expression);
            }
            Function functionalTerm = (Function)term;
            if (functionalTerm.getFunctionSymbol() instanceof FunctionSymbol) {
                return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)functionalTerm.getFunctionSymbol(), this.convertTerms(functionalTerm));
            }
            throw new NotAFunctionSymbolException(term + " is not using a FunctionSymbol but a " + functionalTerm.getFunctionSymbol().getClass());
        }
        return (ImmutableTerm)((Object)term);
    }

    public VariableOrGroundTerm convertIntoVariableOrGroundTerm(Term term) {
        if (term instanceof Variable) {
            return (Variable)term;
        }
        if (GroundTermTools.isGroundTerm(term)) {
            return GroundTermTools.castIntoGroundTerm(term, this.termFactory);
        }
        throw new IllegalArgumentException("Not a variable nor a ground term: " + term);
    }

    public static VariableOrGroundTerm convertIntoVariableOrGroundTerm(ImmutableTerm term) {
        if (term instanceof Variable) {
            return (Variable)term;
        }
        if (term.isGround()) {
            return (GroundTerm)term;
        }
        throw new IllegalArgumentException("Not a variable nor a ground term: " + term);
    }

    public Function convertToMutableFunction(ImmutableFunctionalTerm functionalTerm) {
        return this.convertToMutableFunction(functionalTerm.getFunctionSymbol(), functionalTerm.getTerms());
    }

    public Function convertToMutableFunction(DataAtom dataAtom) {
        return this.convertToMutableFunction((it.unibz.inf.ontop.model.term.functionsymbol.Predicate)dataAtom.getPredicate(), (ImmutableList<? extends ImmutableTerm>)dataAtom.getArguments());
    }

    public Function convertToMutableFunction(it.unibz.inf.ontop.model.term.functionsymbol.Predicate predicateOrFunctionSymbol, ImmutableList<? extends ImmutableTerm> terms) {
        return this.termFactory.getFunction(predicateOrFunctionSymbol, this.convertToMutableTerms(terms));
    }

    private List<Term> convertToMutableTerms(ImmutableList<? extends ImmutableTerm> terms) {
        ArrayList<Term> mutableList = new ArrayList<Term>();
        for (ImmutableTerm nextTerm : terms) {
            if (nextTerm instanceof ImmutableFunctionalTerm) {
                ImmutableFunctionalTerm term2Change = (ImmutableFunctionalTerm)nextTerm;
                Function newTerm = this.convertToMutableFunction(term2Change);
                mutableList.add(newTerm);
                continue;
            }
            mutableList.add((Term)((Object)nextTerm));
        }
        return mutableList;
    }

    public Term convertToMutableTerm(ImmutableTerm term) {
        if (term instanceof Variable) {
            return (Term)((Object)term);
        }
        if (term instanceof Constant) {
            return (Term)((Object)term);
        }
        return this.convertToMutableFunction((ImmutableFunctionalTerm)term);
    }

    public Expression convertToMutableBooleanExpression(ImmutableExpression booleanExpression) {
        BooleanFunctionSymbol pred = booleanExpression.getFunctionSymbol();
        return this.termFactory.getExpression(pred, this.convertToMutableTerms(booleanExpression.getTerms()));
    }

    public ImmutableSet<ImmutableExpression> retainVar2VarEqualityConjuncts(ImmutableExpression expression) {
        return this.filterOuterMostConjuncts(e -> e.isVar2VarEquality(), expression);
    }

    public ImmutableSet<ImmutableExpression> discardVar2VarEqualityConjuncts(ImmutableExpression expression) {
        return this.filterOuterMostConjuncts(e -> !e.isVar2VarEquality(), expression);
    }

    private ImmutableSet<ImmutableExpression> filterOuterMostConjuncts(Predicate<ImmutableExpression> filterMethod, ImmutableExpression expression) {
        ImmutableSet conjuncts = (ImmutableSet)expression.flattenAND().collect(ImmutableCollectors.toSet());
        if (conjuncts.size() > 1) {
            ImmutableList filteredConjuncts = (ImmutableList)conjuncts.stream().filter(filterMethod).collect(ImmutableCollectors.toList());
            switch (filteredConjuncts.size()) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of((Object)filteredConjuncts.iterator().next());
                }
            }
            return ImmutableSet.copyOf((Collection)filteredConjuncts);
        }
        return filterMethod.test(expression) ? ImmutableSet.of((Object)expression) : ImmutableSet.of();
    }

    private ImmutableList<ImmutableTerm> convertTerms(Function functionalTermToClone) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Term term : functionalTermToClone.getTerms()) {
            builder.add((Object)this.convertIntoImmutableTerm(term));
        }
        return builder.build();
    }

    private static class NotAFunctionSymbolException
    extends MinorOntopInternalBugException {
        private NotAFunctionSymbolException(String message) {
            super(message);
        }
    }
}

