/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.impl.AbstractNonNullConstant;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;

public class IRIConstantImpl
extends AbstractNonNullConstant
implements IRIConstant {
    private final int identifier;
    private final IRI iri;
    private final ObjectRDFType type;

    protected IRIConstantImpl(IRI iri, TypeFactory typeFactory) {
        this.iri = iri;
        this.identifier = iri.hashCode();
        this.type = typeFactory.getIRITermType();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IRIConstantImpl)) {
            return false;
        }
        IRIConstantImpl uri2 = (IRIConstantImpl)obj;
        return this.identifier == uri2.identifier;
    }

    public int hashCode() {
        return this.identifier;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public IRIConstant clone() {
        return this;
    }

    @Override
    public boolean isGround() {
        return true;
    }

    @Override
    public Stream<Variable> getVariableStream() {
        return Stream.of(new Variable[0]);
    }

    public String toString() {
        return "<" + this.iri.getIRIString() + ">";
    }

    @Override
    public ObjectRDFType getType() {
        return this.type;
    }

    @Override
    public IncrementalEvaluation evaluateStrictEq(ImmutableTerm otherTerm, VariableNullability variableNullability) {
        if (otherTerm instanceof Constant) {
            if (((Constant)otherTerm).isNull()) {
                return IncrementalEvaluation.declareIsNull();
            }
            return this.equals(otherTerm) ? IncrementalEvaluation.declareIsTrue() : IncrementalEvaluation.declareIsFalse();
        }
        return otherTerm.evaluateStrictEq(this, variableNullability);
    }

    @Override
    @Deprecated
    public String getValue() {
        return this.iri.getIRIString();
    }
}

