/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.Function;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.Term;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.impl.GroundFunctionalTermImpl;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class GroundTermTools {
    public static ImmutableList<GroundTerm> castIntoGroundTerms(List<? extends Term> terms, TermFactory termFactory) throws NonGroundTermException {
        ImmutableList.Builder termBuilder = ImmutableList.builder();
        for (Term term : terms) {
            termBuilder.add((Object)GroundTermTools.castIntoGroundTerm(term, termFactory));
        }
        return termBuilder.build();
    }

    public static GroundTerm castIntoGroundTerm(Term term, TermFactory termFactory) throws NonGroundTermException {
        if (term instanceof GroundTerm) {
            return (GroundTerm)((Object)term);
        }
        if (term instanceof Function) {
            Function functionalTerm = (Function)term;
            FunctionSymbol functionSymbol = Optional.of(functionalTerm.getFunctionSymbol()).filter(p -> p instanceof FunctionSymbol).map(p -> (FunctionSymbol)p).orElseThrow(() -> new NonGroundTermException(term + "is not using a function symbol but a" + functionalTerm.getFunctionSymbol().getClass()));
            return new GroundFunctionalTermImpl(GroundTermTools.castIntoGroundTerms(functionalTerm.getTerms(), termFactory), functionSymbol, termFactory);
        }
        throw new NonGroundTermException(term + " is not a ground term");
    }

    public static boolean isGroundTerm(Term term) {
        if (term instanceof Function) {
            return ((Function)term).getVariables().isEmpty();
        }
        return term instanceof Constant;
    }

    public static boolean areGroundTerms(Collection<? extends ImmutableTerm> terms) {
        for (ImmutableTerm immutableTerm : terms) {
            if (immutableTerm.isGround()) continue;
            return false;
        }
        return true;
    }

    public static void checkNonGroundTermConstraint(NonGroundFunctionalTerm term) throws IllegalArgumentException {
        if (term.getVariables().isEmpty()) {
            throw new IllegalArgumentException("A NonGroundFunctionalTerm must contain at least one variable: " + term);
        }
    }

    public static class NonGroundTermException
    extends RuntimeException {
        protected NonGroundTermException(String message) {
            super(message);
        }
    }
}

