/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import it.unibz.inf.ontop.datalog.EventGeneratingList;
import it.unibz.inf.ontop.datalog.ListenableFunction;
import it.unibz.inf.ontop.datalog.impl.EventGeneratingLinkedList;
import it.unibz.inf.ontop.model.term.Function;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.Term;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.Predicate;
import it.unibz.inf.ontop.model.term.impl.AbstractFunctionalTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FunctionalTermImpl
extends AbstractFunctionalTerm
implements ListenableFunction {
    private static final long serialVersionUID = 2832481815465364535L;
    private EventGeneratingList<Term> terms;
    private int identifier = -1;
    private boolean rehash = true;
    private String string = null;

    protected FunctionalTermImpl(Predicate functor, Term ... terms) {
        super(functor);
        EventGeneratingLinkedList<Term> eventlist = new EventGeneratingLinkedList<Term>();
        Collections.addAll(eventlist, terms);
        this.terms = eventlist;
        this.registerListeners(eventlist);
    }

    protected FunctionalTermImpl(Predicate functor, List<Term> terms) {
        super(functor);
        EventGeneratingLinkedList<Term> eventlist = new EventGeneratingLinkedList<Term>();
        eventlist.addAll(terms);
        this.terms = eventlist;
        this.registerListeners(eventlist);
    }

    private void registerListeners(EventGeneratingList<? extends Term> functions) {
        functions.addListener(this);
        for (Object e : functions) {
            if (!(e instanceof Function)) continue;
            if (e instanceof ListenableFunction) {
                ListenableFunction f = (ListenableFunction)e;
                List list = f.getTerms();
                list.addListener(this);
                this.registerListeners((EventGeneratingList<? extends Term>)list);
                continue;
            }
            if (e instanceof ImmutableFunctionalTerm) continue;
            throw new IllegalArgumentException("Unknown type of function: not listenable nor immutable:  " + e);
        }
    }

    public int hashCode() {
        if (this.rehash) {
            this.string = this.toString();
            this.identifier = this.string.hashCode();
            this.rehash = false;
        }
        return this.identifier;
    }

    @Override
    public void setPredicate(Predicate predicate) {
        super.setPredicate(predicate);
        this.listChanged();
    }

    @Override
    public EventGeneratingList<Term> getTerms() {
        return this.terms;
    }

    @Override
    public Function clone() {
        ArrayList<Term> copyTerms = new ArrayList<Term>(this.terms.size());
        for (Term term : this.terms) {
            copyTerms.add(term.clone());
        }
        FunctionalTermImpl clone = new FunctionalTermImpl(this.getFunctionSymbol(), copyTerms);
        clone.identifier = this.identifier;
        clone.string = this.string;
        clone.rehash = this.rehash;
        return clone;
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = super.toString();
        }
        return this.string;
    }

    @Override
    public void listChanged() {
        this.rehash = true;
        this.string = null;
    }

    @Override
    public Term getTerm(int index) {
        return (Term)this.terms.get(index);
    }

    @Override
    public void setTerm(int index, Term newTerm) {
        this.listChanged();
        this.terms.set(index, newTerm);
    }

    @Override
    public void updateTerms(List<Term> newterms) {
        List innertermlist;
        ListenableFunction function;
        for (Term term : this.terms) {
            if (!(term instanceof Function)) continue;
            if (term instanceof ListenableFunction) {
                function = (ListenableFunction)term;
                innertermlist = function.getTerms();
                innertermlist.removeListener(this);
                continue;
            }
            if (term instanceof ImmutableFunctionalTerm) continue;
            throw new IllegalArgumentException("Unknown type of function: not listenable nor immutable:  " + term);
        }
        this.terms.clear();
        this.terms.addAll(newterms);
        for (Term term : this.terms) {
            if (!(term instanceof Function)) continue;
            if (term instanceof ListenableFunction) {
                function = (ListenableFunction)term;
                innertermlist = function.getTerms();
                innertermlist.addListener(this);
                continue;
            }
            if (term instanceof ImmutableFunctionalTerm) continue;
            throw new IllegalArgumentException("Unknown type of function: not listenable nor immutable:  " + term);
        }
        this.listChanged();
    }

    @Override
    public boolean isDataFunction() {
        return !this.isOperation() && !this.isDataTypeFunction();
    }

    @Override
    public boolean isOperation() {
        return this.getFunctionSymbol() instanceof FunctionSymbol;
    }

    @Override
    public boolean isDataTypeFunction() {
        return false;
    }
}

