/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import it.unibz.inf.ontop.model.term.Function;
import it.unibz.inf.ontop.model.term.Term;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.Predicate;
import it.unibz.inf.ontop.model.term.impl.TermUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractFunctionalTerm
implements Function {
    private Predicate functor;

    protected AbstractFunctionalTerm(Predicate functor) {
        this.functor = functor;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Function)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    @Override
    public int getArity() {
        return this.functor.getArity();
    }

    @Override
    public Predicate getFunctionSymbol() {
        return this.functor;
    }

    @Override
    public void setPredicate(Predicate predicate) {
        this.functor = predicate;
    }

    @Override
    public Set<Variable> getVariables() {
        HashSet<Variable> variables = new HashSet<Variable>();
        for (Term t : this.getTerms()) {
            TermUtils.addReferencedVariablesTo(variables, t);
        }
        return variables;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.functor.toString());
        sb.append("(");
        boolean separator = false;
        for (Term innerTerm : this.getTerms()) {
            if (separator) {
                sb.append(",");
            }
            sb.append(innerTerm.toString());
            separator = true;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean containsTerm(Term t) {
        List<Term> terms = this.getTerms();
        for (int i = 0; i < terms.size(); ++i) {
            Term t2 = terms.get(i);
            if (!t2.equals(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Function clone() {
        throw new RuntimeException("MUST be implemented by concrete sub-classes. Added because required by the compiler");
    }

    @Override
    public boolean isDataFunction() {
        return !this.isOperation() && !this.isDataTypeFunction();
    }

    @Override
    public boolean isOperation() {
        return this.functor instanceof FunctionSymbol;
    }

    @Override
    @Deprecated
    public boolean isDataTypeFunction() {
        return false;
    }
}

