/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.request.DefinitionPushDownRequest;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonConstantTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.InequalityLabel;
import it.unibz.inf.ontop.model.term.functionsymbol.SPARQLAggregationFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.UnaryNumericSPARQLAggregationFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class SumLikeSPARQLAggregationFunctionSymbolImpl
extends UnaryNumericSPARQLAggregationFunctionSymbolImpl {
    public SumLikeSPARQLAggregationFunctionSymbolImpl(String name, String officialName, boolean isDistinct, RDFTermType rootRdfTermType, String defaultAggVariableName) {
        super(name, officialName, isDistinct, rootRdfTermType, defaultAggVariableName);
    }

    @Override
    protected SPARQLAggregationFunctionSymbol.AggregationSimplification decomposeMultityped(ImmutableTerm subTerm, ImmutableSet<RDFTermType> subTermPossibleTypes, boolean hasGroupBy, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        ImmutableTerm subTermLexicalTerm = this.extractLexicalTerm(subTerm, termFactory);
        ImmutableTerm subTermTypeTerm = this.extractRDFTermTypeTerm(subTerm, termFactory);
        ImmutableMultimap<ConcreteNumericRDFDatatype, ConcreteNumericRDFDatatype> numericTypeMultimap = subTermPossibleTypes.stream().filter(t -> t instanceof ConcreteNumericRDFDatatype).map(t -> (ConcreteNumericRDFDatatype)t).collect(ImmutableCollectors.toMultimap(t -> t.getCommonPropagatedOrSubstitutedType((ConcreteNumericRDFDatatype)t), t -> t));
        ImmutableSet<RDFTermType> nonNumericTypes = this.extractNonNumericTypes(subTermPossibleTypes);
        ImmutableMap<ConcreteNumericRDFDatatype, Variable> numericSubVarMap = numericTypeMultimap.keySet().stream().collect(ImmutableCollectors.toMap(e -> e, e -> variableGenerator.generateNewVariable("num")));
        Optional<Variable> optionalIncompatibleSubVariable = nonNumericTypes.isEmpty() ? Optional.empty() : Optional.of(variableGenerator.generateNewVariable("nonNum"));
        ImmutableSet<DefinitionPushDownRequest> pushDownRequests = this.computeRequests(subTermLexicalTerm, subTermTypeTerm, numericTypeMultimap, nonNumericTypes, numericSubVarMap, optionalIncompatibleSubVariable, variableNullability, termFactory);
        ImmutableMap<ConcreteNumericRDFDatatype, Variable> numericAggregateVarMap = numericTypeMultimap.keySet().stream().collect(ImmutableCollectors.toMap(e -> e, e -> variableGenerator.generateNewVariable("agg")));
        Optional<Variable> optionalIncompatibleCountVariable = optionalIncompatibleSubVariable.map(v -> variableGenerator.generateNewVariable("nonNumCount"));
        ImmutableMap<Variable, ImmutableFunctionalTerm> substitutionMap = this.computeSubstitutionMap(numericAggregateVarMap, numericSubVarMap, optionalIncompatibleCountVariable, optionalIncompatibleSubVariable, termFactory);
        ImmutableFunctionalTerm liftableTerm = this.computeLiftableTerm(numericAggregateVarMap, optionalIncompatibleCountVariable, termFactory);
        return SPARQLAggregationFunctionSymbol.AggregationSimplification.create(termFactory.getFunctionalTermDecomposition(liftableTerm, substitutionMap), pushDownRequests);
    }

    private ImmutableSet<DefinitionPushDownRequest> computeRequests(ImmutableTerm subTermLexicalTerm, ImmutableTerm subTermTypeTerm, ImmutableMultimap<ConcreteNumericRDFDatatype, ConcreteNumericRDFDatatype> numericTypeMultimap, ImmutableSet<RDFTermType> nonNumericTypes, ImmutableMap<ConcreteNumericRDFDatatype, Variable> numericSubTermVarMap, Optional<Variable> optionalIncompatibleVariable, VariableNullability variableNullability, TermFactory termFactory) {
        Stream<DefinitionPushDownRequest> numericPushDownRequestStream = numericTypeMultimap.asMap().entrySet().stream().map(e -> this.createNumericRequest((ConcreteNumericRDFDatatype)e.getKey(), (Collection)e.getValue(), (Variable)numericSubTermVarMap.get(e.getKey()), subTermLexicalTerm, subTermTypeTerm, variableNullability, termFactory));
        return (ImmutableSet)Stream.concat(numericPushDownRequestStream, optionalIncompatibleVariable.map(v -> this.createNonNumericRequest(subTermTypeTerm, (Variable)v, nonNumericTypes, termFactory)).map(Stream::of).orElseGet(Stream::empty)).collect(ImmutableCollectors.toSet());
    }

    private DefinitionPushDownRequest createNumericRequest(ConcreteNumericRDFDatatype mainNumericType, Collection<ConcreteNumericRDFDatatype> usedTypes, Variable numericVariable, ImmutableTerm subTermLexicalTerm, ImmutableTerm subTermTypeTerm, VariableNullability variableNullability, TermFactory termFactory) {
        ImmutableTerm definition = termFactory.getConversionFromRDFLexical2DB(subTermLexicalTerm, mainNumericType).simplify(variableNullability);
        ImmutableExpression condition = termFactory.getDisjunction(usedTypes.stream().map(t -> termFactory.getStrictEquality(subTermTypeTerm, termFactory.getRDFTermTypeConstant((RDFTermType)t), new ImmutableTerm[0]))).orElseThrow(() -> new MinorOntopInternalBugException("At least one type was expected"));
        return DefinitionPushDownRequest.create(numericVariable, definition, condition);
    }

    private ImmutableMap<Variable, ImmutableFunctionalTerm> computeSubstitutionMap(ImmutableMap<ConcreteNumericRDFDatatype, Variable> numericAggregateVarMap, ImmutableMap<ConcreteNumericRDFDatatype, Variable> numericSubTermVarMap, Optional<Variable> optionalIncompatibleCountVariable, Optional<Variable> optionalIncompatibleSubVariable, TermFactory termFactory) {
        Stream<Map.Entry> numericAggregationStream = numericAggregateVarMap.entrySet().stream().map(e -> Maps.immutableEntry(e.getValue(), (Object)this.createAggregate((ConcreteNumericRDFDatatype)e.getKey(), (ImmutableTerm)numericSubTermVarMap.get(e.getKey()), termFactory)));
        Stream incompatibleEntryStream = optionalIncompatibleCountVariable.map(v -> Maps.immutableEntry((Object)v, (Object)termFactory.getDBCount((ImmutableTerm)optionalIncompatibleSubVariable.get(), false))).map(Stream::of).orElseGet(Stream::empty);
        return Stream.concat(numericAggregationStream, incompatibleEntryStream).collect(ImmutableCollectors.toMap());
    }

    private ImmutableFunctionalTerm computeLiftableTerm(ImmutableMap<ConcreteNumericRDFDatatype, Variable> numericAggregateVarMap, Optional<Variable> optionalIncompatibleCountVariable, TermFactory termFactory) {
        ImmutableList orderedTypes = (ImmutableList)numericAggregateVarMap.keySet().stream().sorted((t1, t2) -> t1.getCommonPropagatedOrSubstitutedType((ConcreteNumericRDFDatatype)t2).equals(t2) ? 1 : -1).collect(ImmutableCollectors.toList());
        ImmutableList orderedVariables = (ImmutableList)orderedTypes.stream().map(arg_0 -> numericAggregateVarMap.get(arg_0)).collect(ImmutableCollectors.toList());
        int nbTypes = numericAggregateVarMap.size();
        Stream<Map.Entry> numericLexicalWhenPairs = IntStream.range(0, nbTypes).boxed().map(i -> this.computeCombiningPair((int)i, (ImmutableList<ConcreteNumericRDFDatatype>)orderedTypes, (ImmutableList<Variable>)orderedVariables, termFactory));
        DBConstant zero = termFactory.getDBIntegerConstant(0);
        Optional<Map.Entry> incompatibleWhenPair = optionalIncompatibleCountVariable.map(v -> termFactory.getDBNumericInequality(InequalityLabel.GT, (ImmutableTerm)v, zero)).map(c -> Maps.immutableEntry((Object)c, (Object)termFactory.getNullConstant()));
        ImmutableFunctionalTerm lexicalTerm = termFactory.getDBCase(Stream.concat(incompatibleWhenPair.map(Stream::of).orElseGet(Stream::empty), numericLexicalWhenPairs), termFactory.getDBStringConstant("0"), true);
        Stream<Map.Entry> numericTypeWhenPairs = IntStream.range(0, nbTypes).boxed().map(i -> this.computeTypingPair((int)i, (ImmutableList<ConcreteNumericRDFDatatype>)orderedTypes, (ImmutableList<Variable>)orderedVariables, termFactory));
        ImmutableFunctionalTerm typeTerm = termFactory.getDBCase(Stream.concat(incompatibleWhenPair.map(Stream::of).orElseGet(Stream::empty), numericTypeWhenPairs), termFactory.getRDFTermTypeConstant(termFactory.getTypeFactory().getXsdIntegerDatatype()), true);
        return termFactory.getRDFFunctionalTerm(lexicalTerm, typeTerm);
    }

    private Map.Entry<ImmutableExpression, ? extends ImmutableTerm> computeCombiningPair(int index, ImmutableList<ConcreteNumericRDFDatatype> orderedTypes, ImmutableList<Variable> orderedVariables, TermFactory termFactory) {
        ConcreteNumericRDFDatatype currentType = (ConcreteNumericRDFDatatype)orderedTypes.get(index);
        Variable currentVariable = (Variable)orderedVariables.get(index);
        ImmutableExpression condition = termFactory.getDBIsNotNull(currentVariable);
        ImmutableFunctionalTerm thenValue = termFactory.getConversion2RDFLexical(this.combineWithFollowingAggregates(index, orderedVariables, termFactory, true), currentType);
        return Maps.immutableEntry((Object)condition, (Object)thenValue);
    }

    private Map.Entry<ImmutableExpression, ? extends ImmutableTerm> computeTypingPair(int index, ImmutableList<ConcreteNumericRDFDatatype> orderedTypes, ImmutableList<Variable> orderedVariables, TermFactory termFactory) {
        ConcreteNumericRDFDatatype currentType = (ConcreteNumericRDFDatatype)orderedTypes.get(index);
        Variable currentVariable = (Variable)orderedVariables.get(index);
        ImmutableExpression condition = termFactory.getDBIsNotNull(currentVariable);
        RDFTermTypeConstant thenValue = termFactory.getRDFTermTypeConstant(currentType);
        return Maps.immutableEntry((Object)condition, (Object)thenValue);
    }

    protected ImmutableTerm combineWithFollowingAggregates(int index, ImmutableList<Variable> orderedVariables, TermFactory termFactory, boolean isTop) {
        Variable currentTerm;
        Variable currentVariable = (Variable)orderedVariables.get(index);
        NonConstantTerm nonConstantTerm = currentTerm = isTop ? currentVariable : termFactory.getDBCoalesce(currentVariable, this.getNeutralElement(termFactory), new ImmutableTerm[0]);
        if (index == orderedVariables.size() - 1) {
            return currentTerm;
        }
        return this.combineAggregates(currentTerm, this.combineWithFollowingAggregates(index + 1, orderedVariables, termFactory, false), termFactory);
    }

    protected abstract ImmutableTerm combineAggregates(ImmutableTerm var1, ImmutableTerm var2, TermFactory var3);

    protected abstract ImmutableTerm getNeutralElement(TermFactory var1);
}

