/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ReduciblePositiveAritySPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.vocabulary.XPathFunction;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ReplaceSPARQLFunctionSymbolImpl
extends ReduciblePositiveAritySPARQLFunctionSymbolImpl {
    private final RDFDatatype xsdStringType;

    protected ReplaceSPARQLFunctionSymbolImpl(int arity, RDFDatatype xsdStringType) {
        super("SP_REPLACE_" + arity, XPathFunction.REPLACE, (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).boxed().map(i -> xsdStringType).collect(ImmutableCollectors.toList())));
        this.xsdStringType = xsdStringType;
        if (arity < 3 || arity > 4) {
            throw new IllegalArgumentException("The arity of REPLACE must be 3 or 4");
        }
    }

    @Override
    protected ImmutableTerm computeLexicalTerm(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, ImmutableTerm returnedTypeTerm) {
        return this.getArity() == 3 ? termFactory.getDBRegexpReplace((ImmutableTerm)subLexicalTerms.get(0), (ImmutableTerm)subLexicalTerms.get(1), (ImmutableTerm)subLexicalTerms.get(2)) : termFactory.getDBRegexpReplace((ImmutableTerm)subLexicalTerms.get(0), (ImmutableTerm)subLexicalTerms.get(1), (ImmutableTerm)subLexicalTerms.get(2), (ImmutableTerm)subLexicalTerms.get(3));
    }

    @Override
    protected ImmutableTerm computeTypeTerm(ImmutableList<? extends ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return (ImmutableTerm)typeTerms.get(0);
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return ((ImmutableTerm)terms.get(0)).inferType().filter(i -> i.getTermType().map(t -> t.isA(this.xsdStringType)).orElse(false));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    protected ImmutableExpression.Evaluation evaluateInputTypeError(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, VariableNullability variableNullability) {
        RDFTermTypeConstant xsdStringConstant = termFactory.getRDFTermTypeConstant(this.xsdStringType);
        Stream<ImmutableExpression> conditionStream = Stream.concat(Stream.of(termFactory.getIsAExpression((ImmutableTerm)typeTerms.get(0), this.xsdStringType)), typeTerms.stream().skip(1L).map(t -> termFactory.getStrictEquality((ImmutableTerm)t, xsdStringConstant, new ImmutableTerm[0])));
        return termFactory.getConjunction(conditionStream).get().evaluate(variableNullability);
    }
}

