/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.LanguageTag;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import java.util.Optional;

public class LangTagFunctionSymbolImpl
extends FunctionSymbolImpl {
    private final DBTermType dbStringType;

    protected LangTagFunctionSymbolImpl(MetaRDFTermType metaRDFTermType, DBTermType dbStringType) {
        super("LANG_TAG", (ImmutableList<TermType>)ImmutableList.of((Object)metaRDFTermType));
        this.dbStringType = dbStringType;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return true;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.dbStringType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm newTerm = (ImmutableTerm)newTerms.get(0);
        if (newTerm instanceof RDFTermTypeConstant) {
            RDFTermType termType = ((RDFTermTypeConstant)newTerm).getRDFTermType();
            return Optional.of(termType).filter(t -> t instanceof RDFDatatype).map(t -> ((RDFDatatype)t).getLanguageTag().map(LanguageTag::getFullString).orElse("")).map(s -> termFactory.getDBStringConstant((String)s)).orElseGet(termFactory::getNullConstant);
        }
        if (newTerm instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)newTerm).getFunctionSymbol() instanceof RDFTermTypeFunctionSymbol) {
            ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)newTerm;
            RDFTermTypeFunctionSymbol functionSymbol = (RDFTermTypeFunctionSymbol)functionalTerm.getFunctionSymbol();
            return functionSymbol.lift(functionalTerm.getTerms(), c -> Optional.of(c).map(RDFTermTypeConstant::getRDFTermType).filter(t -> t instanceof RDFDatatype).map(t -> ((RDFDatatype)t).getLanguageTag().map(LanguageTag::getFullString).orElse("")).map(s -> termFactory.getDBStringConstant((String)s)).orElseGet(termFactory::getNullConstant), termFactory);
        }
        return super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability);
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }
}

