/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.tools.TypeConstantDictionary;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIfThenFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class AbstractCommonDenominatorFunctionSymbol
extends FunctionSymbolImpl {
    private final MetaRDFTermType metaRDFTermType;

    public AbstractCommonDenominatorFunctionSymbol(String functionSymbolName, int arity, MetaRDFTermType metaRDFTermType) {
        super(functionSymbolName, (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).boxed().map(i -> metaRDFTermType).collect(ImmutableCollectors.toList())));
        this.metaRDFTermType = metaRDFTermType;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.metaRDFTermType));
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return true;
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return newTerms.stream().filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBIfThenFunctionSymbol).findAny().map(t -> ((DBIfThenFunctionSymbol)t.getFunctionSymbol()).pushDownRegularFunctionalTerm(termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)newTerms), newTerms.indexOf(t), termFactory)).map(t -> t.simplify(variableNullability)).orElseGet(() -> super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability));
    }

    protected ImmutableTerm simplifyUsingMagicNumbers(ImmutableList<ImmutableFunctionalTerm> otherTerms, Optional<RDFTermTypeConstant> optionalMergedTypeConstant, TermFactory termFactory) {
        ImmutableList subTerms = (ImmutableList)otherTerms.stream().map(t -> t.getTerm(0)).collect(ImmutableCollectors.toList());
        if (!subTerms.stream().allMatch(t -> t instanceof Variable)) {
            throw new MinorOntopInternalBugException("Was expecting RDF term type functional terms to have a variable as argument\n" + otherTerms);
        }
        ImmutableList subVariables = subTerms;
        ImmutableSet<ImmutableList<RDFTermTypeConstant>> possibleCombinations = this.extractPossibleCombinations(otherTerms);
        TypeConstantDictionary dictionary = otherTerms.stream().map(t -> ((RDFTermTypeFunctionSymbol)t.getFunctionSymbol()).getDictionary()).findFirst().orElseThrow(() -> new IllegalArgumentException("otherTerms must be non-empty"));
        ImmutableMap validCombinations = possibleCombinations.stream().map(l -> this.evaluateCombination((ImmutableList<RDFTermTypeConstant>)l, optionalMergedTypeConstant, termFactory).map(r -> Maps.immutableEntry((Object)l, (Object)r))).filter(Optional::isPresent).map(Optional::get).collect(ImmutableCollectors.toMap());
        if (validCombinations.isEmpty()) {
            return termFactory.getNullConstant();
        }
        ImmutableFunctionalTerm caseTerm = termFactory.getDBCaseElseNull(validCombinations.entrySet().stream().map(e -> Maps.immutableEntry((Object)this.convertIntoConjunction((ImmutableList<RDFTermTypeConstant>)((ImmutableList)e.getKey()), (ImmutableList<Variable>)subVariables, dictionary, termFactory), (Object)dictionary.convert((RDFTermTypeConstant)e.getValue()))), false);
        return termFactory.getRDFTermTypeFunctionalTerm(caseTerm, dictionary, (ImmutableSet<RDFTermTypeConstant>)ImmutableSet.copyOf((Collection)validCombinations.values()), true);
    }

    private ImmutableSet<ImmutableList<RDFTermTypeConstant>> extractPossibleCombinations(ImmutableList<ImmutableFunctionalTerm> terms) {
        if (terms.isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableFunctionalTerm firstTerm = (ImmutableFunctionalTerm)terms.get(0);
        RDFTermTypeFunctionSymbol functionSymbol = (RDFTermTypeFunctionSymbol)firstTerm.getFunctionSymbol();
        ImmutableList followingTerms = terms.subList(1, terms.size());
        if (followingTerms.isEmpty()) {
            return (ImmutableSet)functionSymbol.getConversionMap().values().stream().map(ImmutableList::of).collect(ImmutableCollectors.toSet());
        }
        ImmutableSet<ImmutableList<RDFTermTypeConstant>> otherCombinations = this.extractPossibleCombinations((ImmutableList<ImmutableFunctionalTerm>)followingTerms);
        return (ImmutableSet)functionSymbol.getConversionMap().values().stream().flatMap(v1 -> otherCombinations.stream().map(c -> (ImmutableList)Stream.concat(Stream.of(v1), c.stream()).collect(ImmutableCollectors.toList()))).collect(ImmutableCollectors.toSet());
    }

    private ImmutableExpression convertIntoConjunction(ImmutableList<RDFTermTypeConstant> constants, ImmutableList<Variable> subVariables, TypeConstantDictionary dictionary, TermFactory termFactory) {
        return termFactory.getConjunction(IntStream.range(0, constants.size()).boxed().map(i -> termFactory.getStrictEquality((ImmutableTerm)subVariables.get(i.intValue()), dictionary.convert((RDFTermTypeConstant)constants.get(i.intValue())), new ImmutableTerm[0]))).orElseThrow(() -> new MinorOntopInternalBugException("Unexpected empty stream"));
    }

    protected abstract Optional<RDFTermTypeConstant> evaluateCombination(ImmutableList<RDFTermTypeConstant> var1, Optional<RDFTermTypeConstant> var2, TermFactory var3);

    @Override
    protected boolean enableIfElseNullLifting() {
        return true;
    }
}

