/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBBooleanFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public abstract class AbstractOrNullFunctionSymbol
extends DBBooleanFunctionSymbolImpl {
    private final boolean possibleBoolean;

    protected AbstractOrNullFunctionSymbol(@Nonnull String name, int arity, DBTermType dbBooleanTermType, boolean possibleBoolean) {
        super(name, (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).boxed().map(i -> dbBooleanTermType).collect(ImmutableCollectors.toList())), dbBooleanTermType);
        this.possibleBoolean = possibleBoolean;
        if (arity <= 0) {
            throw new IllegalArgumentException("Arity must be >= 1");
        }
    }

    @Override
    public boolean blocksNegation() {
        return true;
    }

    @Override
    public ImmutableExpression negate(ImmutableList<? extends ImmutableTerm> subTerms, TermFactory termFactory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        DBConstant possibleBooleanConstant = termFactory.getDBBooleanConstant(this.possibleBoolean);
        if (newTerms.stream().anyMatch(possibleBooleanConstant::equals)) {
            return possibleBooleanConstant;
        }
        ImmutableList remainingExpressions = (ImmutableList)newTerms.stream().filter(t -> t instanceof ImmutableExpression).map(t -> (ImmutableExpression)t).collect(ImmutableCollectors.toList());
        return remainingExpressions.isEmpty() ? termFactory.getNullConstant() : termFactory.getImmutableExpression((BooleanFunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)remainingExpressions);
    }

    @Override
    protected boolean tolerateNulls() {
        return true;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return true;
    }

    @Override
    public ImmutableTerm simplify2VL(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        if (this.possibleBoolean) {
            return termFactory.getDisjunction(terms).simplify2VL(variableNullability);
        }
        return termFactory.getDBBooleanConstant(false);
    }

    @Override
    protected ImmutableList<? extends ImmutableTerm> transformIntoRegularArguments(ImmutableList<? extends NonFunctionalTerm> arguments, TermFactory termFactory) {
        return (ImmutableList)arguments.stream().map(termFactory::getIsTrue).collect(ImmutableCollectors.toList());
    }
}

