/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.atom.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.QuadPredicate;
import it.unibz.inf.ontop.model.atom.TriplePredicate;
import it.unibz.inf.ontop.model.atom.impl.AtomPredicateImpl;
import it.unibz.inf.ontop.model.atom.impl.DataAtomImpl;
import it.unibz.inf.ontop.model.atom.impl.DistinctVariableOnlyDataAtomImpl;
import it.unibz.inf.ontop.model.atom.impl.QuadPredicateImpl;
import it.unibz.inf.ontop.model.atom.impl.TriplePredicateImpl;
import it.unibz.inf.ontop.model.term.Function;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.Term;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.Predicate;
import it.unibz.inf.ontop.model.term.impl.ImmutabilityTools;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.stream.IntStream;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;

public class AtomFactoryImpl
implements AtomFactory {
    private final TriplePredicate triplePredicate;
    private final QuadPredicate quadPredicate;
    private final TermFactory termFactory;
    private final TypeFactory typeFactory;
    private final ImmutabilityTools immutabilityTools;

    @Inject
    private AtomFactoryImpl(TermFactory termFactory, TypeFactory typeFactory, RDF rdfFactory, ImmutabilityTools immutabilityTools) {
        this.termFactory = termFactory;
        this.typeFactory = typeFactory;
        this.immutabilityTools = immutabilityTools;
        RDFTermTypeConstant iriType = termFactory.getRDFTermTypeConstant(typeFactory.getIRITermType());
        this.triplePredicate = new TriplePredicateImpl((ImmutableList<TermType>)ImmutableList.of((Object)typeFactory.getAbstractObjectRDFType(), (Object)typeFactory.getIRITermType(), (Object)typeFactory.getAbstractRDFTermType()), iriType, rdfFactory);
        this.quadPredicate = new QuadPredicateImpl((ImmutableList<TermType>)ImmutableList.of((Object)typeFactory.getAbstractObjectRDFType(), (Object)typeFactory.getIRITermType(), (Object)typeFactory.getAbstractRDFTermType(), (Object)typeFactory.getIRITermType()), iriType, rdfFactory);
    }

    @Override
    public AtomPredicate getRDFAnswerPredicate(int arity) {
        ImmutableList defaultBaseTypes = (ImmutableList)IntStream.range(0, arity).boxed().map(i -> this.typeFactory.getAbstractRDFTermType()).collect(ImmutableCollectors.toList());
        return new AtomPredicateImpl("ans1", (ImmutableList<TermType>)defaultBaseTypes);
    }

    @Override
    public <P extends AtomPredicate> DataAtom<P> getDataAtom(P predicate, ImmutableList<? extends VariableOrGroundTerm> arguments) {
        return new DataAtomImpl<P>(predicate, arguments);
    }

    @Override
    public <P extends AtomPredicate> DataAtom<P> getDataAtom(P predicate, VariableOrGroundTerm ... terms) {
        return this.getDataAtom(predicate, (ImmutableList<? extends VariableOrGroundTerm>)ImmutableList.copyOf((Object[])terms));
    }

    @Override
    public DistinctVariableOnlyDataAtom getDistinctVariableOnlyDataAtom(AtomPredicate predicate, ImmutableList<Variable> arguments) {
        return new DistinctVariableOnlyDataAtomImpl(predicate, arguments);
    }

    @Override
    public DistinctVariableOnlyDataAtom getDistinctVariableOnlyDataAtom(AtomPredicate predicate, Variable ... arguments) {
        return this.getDistinctVariableOnlyDataAtom(predicate, (ImmutableList<Variable>)ImmutableList.copyOf((Object[])arguments));
    }

    @Override
    public Function getMutableTripleAtom(Term subject, Term property, Term object) {
        return this.termFactory.getFunction((Predicate)this.triplePredicate, subject, property, object);
    }

    @Override
    public Function getMutableTripleBodyAtom(Term subject, IRI propertyIRI, Term object) {
        return this.getMutableTripleHeadAtom(subject, propertyIRI, object);
    }

    @Override
    public Function getMutableTripleBodyAtom(Term subject, IRI classIRI) {
        return this.getMutableTripleHeadAtom(subject, classIRI);
    }

    @Override
    public Function getMutableTripleHeadAtom(Term subject, IRI propertyIRI, Term object) {
        return this.getMutableTripleAtom(subject, this.convertIRIIntoConstant(propertyIRI), object);
    }

    @Override
    public Function getMutableTripleHeadAtom(Term subject, IRI classIRI) {
        return this.getMutableTripleAtom(subject, this.convertIRIIntoConstant(it.unibz.inf.ontop.model.vocabulary.RDF.TYPE), this.convertIRIIntoConstant(classIRI));
    }

    private IRIConstant convertIRIIntoConstant(IRI iri) {
        return this.termFactory.getConstantIRI(iri);
    }

    @Override
    public DistinctVariableOnlyDataAtom getDistinctTripleAtom(Variable subject, Variable property, Variable object) {
        return this.getDistinctVariableOnlyDataAtom((AtomPredicate)this.triplePredicate, subject, property, object);
    }

    @Override
    public DataAtom<AtomPredicate> getIntensionalTripleAtom(VariableOrGroundTerm subject, VariableOrGroundTerm property, VariableOrGroundTerm object) {
        return this.getDataAtom(this.triplePredicate, subject, property, object);
    }

    @Override
    public DataAtom<AtomPredicate> getIntensionalTripleAtom(VariableOrGroundTerm subject, IRI propertyIRI, VariableOrGroundTerm object) {
        return this.getIntensionalTripleAtom(subject, this.convertIRIIntoConstant(propertyIRI), object);
    }

    @Override
    public DataAtom<AtomPredicate> getIntensionalTripleAtom(VariableOrGroundTerm subject, IRI classIRI) {
        return this.getIntensionalTripleAtom(subject, it.unibz.inf.ontop.model.vocabulary.RDF.TYPE, (VariableOrGroundTerm)this.convertIRIIntoConstant(classIRI));
    }

    @Override
    public DistinctVariableOnlyDataAtom getDistinctQuadAtom(Variable subject, Variable property, Variable object, Variable namedGraph) {
        return this.getDistinctVariableOnlyDataAtom((AtomPredicate)this.quadPredicate, subject, property, object, namedGraph);
    }
}

