/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.transform.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.NotFilterableNullVariableException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.IntermediateQueryBuilder;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinLikeNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.transform.FilterNullableVariableQueryTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Stream;

@Singleton
public class FilterNullableVariableQueryTransformerImpl
implements FilterNullableVariableQueryTransformer {
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;
    private final CoreUtilsFactory coreUtilsFactory;

    @Inject
    private FilterNullableVariableQueryTransformerImpl(IntermediateQueryFactory iqFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory, CoreUtilsFactory coreUtilsFactory) {
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
        this.coreUtilsFactory = coreUtilsFactory;
    }

    @Override
    public IntermediateQuery transform(IntermediateQuery query) throws NotFilterableNullVariableException {
        QueryNode rootNode = query.getRootNode();
        ImmutableList nullableProjectedVariables = (ImmutableList)query.getProjectionAtom().getVariables().stream().filter(v -> rootNode.isVariableNullable(query, (Variable)v)).collect(ImmutableCollectors.toList());
        if (nullableProjectedVariables.isEmpty()) {
            return query;
        }
        ImmutableExpression filterCondition = this.extractFilteringCondition(query, rootNode, (ImmutableList<Variable>)nullableProjectedVariables);
        return this.constructQuery(query, rootNode, filterCondition);
    }

    private ImmutableExpression extractFilteringCondition(IntermediateQuery query, QueryNode rootNode, ImmutableList<Variable> nullableProjectedVariables) throws NotFilterableNullVariableException {
        ImmutableSubstitution topSubstitution = Optional.of(rootNode).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).map(ConstructionNode::getSubstitution).orElseGet(this.substitutionFactory::getSubstitution);
        Stream<ImmutableExpression> filteringExpressionStream = nullableProjectedVariables.stream().map(v -> Optional.ofNullable(topSubstitution.get((Variable)v)).orElse((Variable)v)).map(this.termFactory::getDBIsNotNull).distinct();
        ImmutableExpression nonOptimizedExpression = this.termFactory.getConjunction(filteringExpressionStream).orElseThrow(() -> new IllegalArgumentException("Is nullableProjectedVariables empty? After foldingthere should be one expression"));
        IncrementalEvaluation evaluationResult = nonOptimizedExpression.evaluate2VL(this.coreUtilsFactory.createDummyVariableNullability(nonOptimizedExpression), false);
        switch (evaluationResult.getStatus()) {
            case SAME_EXPRESSION: {
                return nonOptimizedExpression;
            }
            case SIMPLIFIED_EXPRESSION: {
                return evaluationResult.getNewExpression().get();
            }
            case IS_NULL: 
            case IS_FALSE: {
                throw new NotFilterableNullVariableException(query, nonOptimizedExpression);
            }
        }
        throw new UnexpectedTrueExpressionException(nonOptimizedExpression);
    }

    private IntermediateQuery constructQuery(IntermediateQuery query, QueryNode rootNode, ImmutableExpression filterCondition) {
        IntermediateQueryBuilder queryBuilder = query.newBuilder();
        queryBuilder.init(query.getProjectionAtom(), rootNode);
        QueryNode formerRootChild = query.getFirstChild(rootNode).orElseThrow(() -> new InvalidIntermediateQueryException("The root node does not have a child while it has some child variables."));
        LinkedList<QueryNode> parentQueue = new LinkedList<QueryNode>();
        if (formerRootChild instanceof FilterNode) {
            FilterNode newFilterNode = this.iqFactory.createFilterNode(this.termFactory.getConjunction(((FilterNode)formerRootChild).getFilterCondition(), filterCondition));
            queryBuilder.addChild(rootNode, newFilterNode);
            query.getChildren(formerRootChild).forEach(c -> {
                queryBuilder.addChild(newFilterNode, (QueryNode)c);
                parentQueue.add((QueryNode)c);
            });
        } else if (formerRootChild instanceof InnerJoinNode) {
            InnerJoinNode formerJoinNode = (InnerJoinNode)formerRootChild;
            ImmutableExpression newJoiningCondition = formerJoinNode.getOptionalFilterCondition().map(e -> this.termFactory.getConjunction((ImmutableExpression)e, filterCondition)).orElse(filterCondition);
            InnerJoinLikeNode newJoinNode = formerJoinNode.changeOptionalFilterCondition((Optional)Optional.of(newJoiningCondition));
            queryBuilder.addChild(rootNode, newJoinNode);
            query.getChildren(formerJoinNode).forEach(arg_0 -> FilterNullableVariableQueryTransformerImpl.lambda$constructQuery$8(queryBuilder, (InnerJoinNode)newJoinNode, parentQueue, arg_0));
        } else {
            FilterNode filterNode = this.iqFactory.createFilterNode(filterCondition);
            queryBuilder.addChild(rootNode, filterNode);
            queryBuilder.addChild(filterNode, formerRootChild);
            parentQueue.add(formerRootChild);
        }
        while (!parentQueue.isEmpty()) {
            QueryNode parentNode = (QueryNode)parentQueue.poll();
            query.getChildren(parentNode).forEach(c -> {
                queryBuilder.addChild(parentNode, (QueryNode)c, query.getOptionalPosition(parentNode, (QueryNode)c));
                parentQueue.add((QueryNode)c);
            });
        }
        return queryBuilder.build();
    }

    private static /* synthetic */ void lambda$constructQuery$8(IntermediateQueryBuilder queryBuilder, InnerJoinNode newJoinNode, Queue parentQueue, QueryNode c) {
        queryBuilder.addChild(newJoinNode, c);
        parentQueue.add(c);
    }

    private static class UnexpectedTrueExpressionException
    extends OntopInternalBugException {
        private UnexpectedTrueExpressionException(ImmutableExpression expression) {
            super("Bad expression produced: " + expression + ". It should not be evaluated as true");
        }
    }
}

