/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.CommutativeJoinNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.LeftJoinNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.impl.JoinLikeChildBindingLifter;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@Singleton
public class LeftJoinNormalizerImpl
implements LeftJoinNormalizer {
    private static final int MAX_ITERATIONS = 10000;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;
    private final IntermediateQueryFactory iqFactory;
    private final ConditionSimplifier conditionSimplifier;
    private final JoinLikeChildBindingLifter bindingLifter;
    private final JoinOrFilterVariableNullabilityTools variableNullabilityTools;

    @Inject
    private LeftJoinNormalizerImpl(SubstitutionFactory substitutionFactory, TermFactory termFactory, IntermediateQueryFactory iqFactory, ConditionSimplifier conditionSimplifier, JoinLikeChildBindingLifter bindingLifter, JoinOrFilterVariableNullabilityTools variableNullabilityTools) {
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
        this.iqFactory = iqFactory;
        this.conditionSimplifier = conditionSimplifier;
        this.bindingLifter = bindingLifter;
        this.variableNullabilityTools = variableNullabilityTools;
    }

    @Override
    public IQTree normalizeForOptimization(LeftJoinNode ljNode, IQTree initialLeftChild, IQTree initialRightChild, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        ImmutableSet projectedVariables = (ImmutableSet)Stream.of(initialLeftChild, initialRightChild).flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet());
        LJNormalizationState state = new LJNormalizationState((ImmutableSet<Variable>)projectedVariables, initialLeftChild, initialRightChild, ljNode.getOptionalFilterCondition(), variableGenerator);
        if ((state = state.liftLeftChild()).isEmpty()) {
            return state.createNormalizedTree(currentIQProperties);
        }
        for (int i = 0; i < 10000; ++i) {
            LJNormalizationState newState = state.optimizeLeftJoinCondition().liftRightChild().liftLeftChild();
            if (state.equals(newState)) {
                return state.createNormalizedTree(currentIQProperties);
            }
            state = newState;
        }
        throw new MinorOntopInternalBugException("LJ.normalizeForOptimization() did not converge after 10000");
    }

    private static class RightProvenance {
        public final Variable variable;
        public final Optional<ConstructionNode> constructionNode;

        private RightProvenance(Variable provenanceVariable, ConstructionNode constructionNode) {
            this.variable = provenanceVariable;
            this.constructionNode = Optional.of(constructionNode);
        }

        private RightProvenance(Variable rightProvenanceVariable) {
            this.variable = rightProvenanceVariable;
            this.constructionNode = Optional.empty();
        }
    }

    private class LJNormalizationState {
        private final IQTree leftChild;
        private final IQTree rightChild;
        private final VariableGenerator variableGenerator;
        private final Optional<ImmutableExpression> ljCondition;
        private final ImmutableList<UnaryOperatorNode> ancestors;
        private final ImmutableSet<Variable> projectedVariables;

        private LJNormalizationState(ImmutableSet<Variable> projectedVariables, IQTree leftChild, IQTree rightChild, Optional<ImmutableExpression> ljCondition, ImmutableList<UnaryOperatorNode> ancestors, VariableGenerator variableGenerator) {
            this.projectedVariables = projectedVariables;
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.ljCondition = ljCondition;
            this.ancestors = ancestors;
            this.variableGenerator = variableGenerator;
        }

        protected LJNormalizationState(ImmutableSet<Variable> projectedVariables, IQTree initialLeftChild, IQTree initialRightChild, Optional<ImmutableExpression> ljCondition, VariableGenerator variableGenerator) {
            this(projectedVariables, initialLeftChild, initialRightChild, ljCondition, (ImmutableList<UnaryOperatorNode>)ImmutableList.of(), variableGenerator);
        }

        private LJNormalizationState updateConditionAndRightChild(Optional<ImmutableExpression> newLJCondition, IQTree newRightChild) {
            if (this.ljCondition.equals(newLJCondition) && this.rightChild.equals(newRightChild)) {
                return this;
            }
            return new LJNormalizationState(this.projectedVariables, this.leftChild, newRightChild, newLJCondition, this.ancestors, this.variableGenerator);
        }

        private LJNormalizationState updateParentConditionRightChild(UnaryOperatorNode newParent, Optional<ImmutableExpression> newLJCondition, IQTree newRightChild) {
            return this.updateParentConditionChildren(newParent, newLJCondition, this.leftChild, newRightChild);
        }

        private LJNormalizationState updateParentConditionChildren(UnaryOperatorNode newParent, Optional<ImmutableExpression> newLJCondition, IQTree newLeftChild, IQTree newRightChild) {
            ImmutableList newAncestors = ImmutableList.builder().add((Object)newParent).addAll(this.ancestors).build();
            return new LJNormalizationState(this.projectedVariables, newLeftChild, newRightChild, newLJCondition, (ImmutableList<UnaryOperatorNode>)newAncestors, this.variableGenerator);
        }

        private LJNormalizationState updateAncestorsConditionChildren(ImmutableList<UnaryOperatorNode> additionalAncestors, Optional<ImmutableExpression> newLJCondition, IQTree newLeftChild, IQTree newRightChild) {
            ImmutableList newAncestors = ImmutableList.builder().addAll(additionalAncestors).addAll(this.ancestors).build();
            return new LJNormalizationState(this.projectedVariables, newLeftChild, newRightChild, newLJCondition, (ImmutableList<UnaryOperatorNode>)newAncestors, this.variableGenerator);
        }

        private LJNormalizationState updateLeftChild(IQTree newLeftChild) {
            return new LJNormalizationState(this.projectedVariables, newLeftChild, this.rightChild, this.ljCondition, this.ancestors, this.variableGenerator);
        }

        public LJNormalizationState liftLeftChild() {
            IQTree liftedLeftChild = this.leftChild.normalizeForOptimization(this.variableGenerator);
            QueryNode leftRootNode = liftedLeftChild.getRootNode();
            if (leftRootNode instanceof ConstructionNode) {
                return this.liftLeftConstruction((UnaryIQTree)liftedLeftChild);
            }
            if (leftRootNode instanceof DistinctNode) {
                return this.liftLeftDistinct((UnaryIQTree)liftedLeftChild);
            }
            if (leftRootNode instanceof FilterNode) {
                return this.liftLeftFilterNode((UnaryIQTree)liftedLeftChild);
            }
            if (leftRootNode instanceof CommutativeJoinNode) {
                return this.liftLeftCommutativeJoin(liftedLeftChild);
            }
            if (liftedLeftChild.isDeclaredAsEmpty()) {
                return new LJNormalizationState(this.projectedVariables, liftedLeftChild, LeftJoinNormalizerImpl.this.iqFactory.createEmptyNode(this.rightChild.getVariables()), Optional.empty(), this.ancestors, this.variableGenerator);
            }
            return this.updateLeftChild(liftedLeftChild);
        }

        private LJNormalizationState liftLeftConstruction(UnaryIQTree liftedLeftChild) {
            ConstructionNode leftConstructionNode = (ConstructionNode)liftedLeftChild.getRootNode();
            IQTree leftGrandChild = liftedLeftChild.getChild();
            try {
                ImmutableList children = ImmutableList.of((Object)liftedLeftChild, (Object)this.rightChild);
                return LeftJoinNormalizerImpl.this.bindingLifter.liftRegularChildBinding(leftConstructionNode, 0, leftGrandChild, (ImmutableList<IQTree>)children, leftGrandChild.getVariables(), this.ljCondition, this.variableGenerator, LeftJoinNormalizerImpl.this.variableNullabilityTools.getChildrenVariableNullability((ImmutableList<IQTree>)children), this::applyLeftChildBindingLift).liftLeftChild();
            }
            catch (UnsatisfiableConditionException e) {
                EmptyNode newRightChild = LeftJoinNormalizerImpl.this.iqFactory.createEmptyNode(this.rightChild.getVariables());
                ConstructionNode newParentConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union(leftConstructionNode.getVariables(), newRightChild.getVariables()).immutableCopy(), leftConstructionNode.getSubstitution());
                return this.updateParentConditionChildren(newParentConstructionNode, Optional.empty(), leftGrandChild, newRightChild);
            }
        }

        private LJNormalizationState liftLeftDistinct(UnaryIQTree liftedLeftChild) {
            DistinctNode distinctNode = (DistinctNode)liftedLeftChild.getRootNode();
            if (this.rightChild.isDistinct()) {
                IQTree newRightChild = this.rightChild.removeDistincts();
                IQTree newLeftChild = liftedLeftChild.getChild();
                return this.updateParentConditionChildren(distinctNode, this.ljCondition, newLeftChild, newRightChild).liftLeftChild();
            }
            return this.updateLeftChild(liftedLeftChild);
        }

        private Optional<LJNormalizationState> tryToLiftRightDistinct(UnaryIQTree liftedRightChild) {
            DistinctNode distinctNode = (DistinctNode)liftedRightChild.getRootNode();
            if (this.leftChild.isDistinct()) {
                IQTree newLeftChild = this.leftChild.removeDistincts();
                IQTree newRightChild = liftedRightChild.getChild();
                return Optional.of(this.updateParentConditionChildren(distinctNode, this.ljCondition, newLeftChild, newRightChild));
            }
            return Optional.empty();
        }

        private LJNormalizationState liftLeftFilterNode(UnaryIQTree liftedLeftChild) {
            FilterNode filterNode = (FilterNode)liftedLeftChild.getRootNode();
            return this.updateParentConditionChildren(filterNode, this.ljCondition, liftedLeftChild.getChild(), this.rightChild);
        }

        private LJNormalizationState liftLeftCommutativeJoin(IQTree liftedLeftChild) {
            CommutativeJoinNode joinNode = (CommutativeJoinNode)liftedLeftChild.getRootNode();
            Optional<ImmutableExpression> filterCondition = joinNode.getOptionalFilterCondition();
            if (filterCondition.isPresent()) {
                FilterNode newParent = LeftJoinNormalizerImpl.this.iqFactory.createFilterNode(filterCondition.get());
                NaryIQTree newLeftChild = LeftJoinNormalizerImpl.this.iqFactory.createNaryIQTree((NaryOperatorNode)((Object)joinNode.changeOptionalFilterCondition(Optional.empty())), liftedLeftChild.getChildren());
                return this.updateParentConditionChildren(newParent, this.ljCondition, newLeftChild, this.rightChild);
            }
            return this.updateLeftChild(liftedLeftChild);
        }

        private LJNormalizationState liftRightFilter(UnaryIQTree liftedRightChild) {
            FilterNode filterNode = (FilterNode)liftedRightChild.getRootNode();
            ImmutableExpression newLJCondition = this.ljCondition.map(c -> LeftJoinNormalizerImpl.this.termFactory.getConjunction((ImmutableExpression)c, filterNode.getFilterCondition())).orElseGet(filterNode::getFilterCondition);
            return this.updateConditionAndRightChild(Optional.of(newLJCondition), liftedRightChild.getChild());
        }

        private Optional<LJNormalizationState> tryToLiftRightCommutativeJoin(IQTree liftedRightChild) {
            CommutativeJoinNode joinNode = (CommutativeJoinNode)liftedRightChild.getRootNode();
            Optional<ImmutableExpression> filterCondition = joinNode.getOptionalFilterCondition();
            if (filterCondition.isPresent()) {
                ImmutableExpression condition = filterCondition.get();
                ImmutableExpression newLJCondition = this.ljCondition.map(c -> LeftJoinNormalizerImpl.this.termFactory.getConjunction((ImmutableExpression)c, condition)).orElse(condition);
                NaryIQTree newRightChild = LeftJoinNormalizerImpl.this.iqFactory.createNaryIQTree((NaryOperatorNode)((Object)joinNode.changeOptionalFilterCondition(Optional.empty())), liftedRightChild.getChildren());
                return Optional.of(this.updateConditionAndRightChild(Optional.of(newLJCondition), newRightChild));
            }
            return Optional.empty();
        }

        private LJNormalizationState applyLeftChildBindingLift(ImmutableList<IQTree> children, IQTree leftGrandChild, int leftChildPosition, Optional<ImmutableExpression> ljCondition, ImmutableSubstitution<ImmutableTerm> naiveAscendingSubstitution, ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution) {
            if (children.size() != 2) {
                throw new MinorOntopInternalBugException("Two children were expected, not " + children);
            }
            IQTree initialRightChild = (IQTree)children.get(1);
            ImmutableSet leftVariables = Sets.union(((IQTree)children.get(0)).getVariables(), leftGrandChild.getVariables()).immutableCopy();
            IQTree rightSubTree = initialRightChild.applyDescendingSubstitution(descendingSubstitution, ljCondition);
            Optional<RightProvenance> rightProvenance = this.createProvenanceElements(rightSubTree, naiveAscendingSubstitution, (ImmutableSet<Variable>)leftVariables, rightSubTree.getVariables(), this.variableGenerator);
            ImmutableSubstitution<ImmutableTerm> ascendingSubstitution = this.makeRightSpecificDefsProvenanceDependent(naiveAscendingSubstitution, rightProvenance.map(p -> p.variable), (ImmutableSet<Variable>)leftVariables);
            IQTree newRightChild = rightProvenance.flatMap(p -> p.constructionNode).map(n -> LeftJoinNormalizerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, rightSubTree)).orElse(rightSubTree);
            ImmutableSet parentVariables = (ImmutableSet)children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet());
            ConstructionNode parentConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)parentVariables, ascendingSubstitution);
            return this.updateParentConditionChildren(parentConstructionNode, ljCondition, leftGrandChild, newRightChild);
        }

        private ImmutableSubstitution<ImmutableTerm> makeRightSpecificDefsProvenanceDependent(ImmutableSubstitution<ImmutableTerm> ascendingSubstitution, Optional<Variable> defaultProvenanceVariable, ImmutableSet<Variable> leftVariables) {
            return LeftJoinNormalizerImpl.this.substitutionFactory.getSubstitution(ascendingSubstitution.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> leftVariables.contains(e.getKey()) || this.isNullWhenRightIsRejected((ImmutableTerm)e.getValue(), leftVariables) ? (ImmutableTerm)e.getValue() : this.transformRightSubstitutionValue((ImmutableTerm)e.getValue(), leftVariables, defaultProvenanceVariable))));
        }

        public boolean equals(Object o) {
            if (!(o instanceof LJNormalizationState)) {
                return false;
            }
            LJNormalizationState other = (LJNormalizationState)o;
            return this.leftChild.isEquivalentTo(other.leftChild) && this.rightChild.isEquivalentTo(other.rightChild) && this.ljCondition.equals(other.ljCondition) && this.ancestors.size() == other.ancestors.size() && IntStream.range(0, this.ancestors.size()).allMatch(i -> ((UnaryOperatorNode)this.ancestors.get(i)).isEquivalentTo((QueryNode)other.ancestors.get(i)));
        }

        private LJNormalizationState optimizeLeftJoinCondition() {
            if (!this.ljCondition.isPresent()) {
                return this;
            }
            ImmutableSet<Variable> leftVariables = this.leftChild.getVariables();
            try {
                ConditionSimplifier.ExpressionAndSubstitution simplificationResults = LeftJoinNormalizerImpl.this.conditionSimplifier.simplifyCondition(this.ljCondition, leftVariables, LeftJoinNormalizerImpl.this.variableNullabilityTools.getChildrenVariableNullability((ImmutableList<IQTree>)ImmutableList.of((Object)this.leftChild, (Object)this.rightChild)));
                ImmutableSubstitution<NonFunctionalTerm> downSubstitution = this.selectDownSubstitution(simplificationResults.getSubstitution(), this.rightChild.getVariables());
                if (downSubstitution.isEmpty()) {
                    return this.updateConditionAndRightChild(simplificationResults.getOptionalExpression(), this.rightChild);
                }
                IQTree updatedRightChild = this.rightChild.applyDescendingSubstitution(downSubstitution, simplificationResults.getOptionalExpression());
                Optional<RightProvenance> rightProvenance = this.createProvenanceElements(updatedRightChild, downSubstitution, leftVariables, updatedRightChild.getVariables(), this.variableGenerator);
                IQTree newRightChild = rightProvenance.flatMap(p -> p.constructionNode).map(n -> LeftJoinNormalizerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, updatedRightChild)).orElse(updatedRightChild);
                ImmutableSubstitution<ImmutableTerm> newAscendingSubstitution = this.computeLiftableSubstitution(downSubstitution, rightProvenance.map(p -> p.variable), leftVariables);
                ConstructionNode newParentConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union(this.leftChild.getVariables(), this.rightChild.getVariables()).immutableCopy(), newAscendingSubstitution);
                return this.updateParentConditionChildren(newParentConstructionNode, simplificationResults.getOptionalExpression(), this.leftChild, newRightChild);
            }
            catch (UnsatisfiableConditionException e) {
                return this.updateConditionAndRightChild(Optional.empty(), LeftJoinNormalizerImpl.this.iqFactory.createEmptyNode(this.rightChild.getVariables()));
            }
        }

        private LJNormalizationState liftRightChild() {
            IQTree liftedRightChild = this.rightChild.normalizeForOptimization(this.variableGenerator);
            return this.tryToLiftRightChild(liftedRightChild).orElseGet(() -> this.updateConditionAndRightChild(this.ljCondition.filter(c -> !liftedRightChild.isDeclaredAsEmpty()), liftedRightChild));
        }

        private Optional<LJNormalizationState> tryToLiftRightChild(IQTree liftedRightChild) {
            QueryNode rightRootNode = liftedRightChild.getRootNode();
            if (rightRootNode instanceof ConstructionNode) {
                ConstructionNode rightConstructionNode = (ConstructionNode)liftedRightChild.getRootNode();
                IQTree rightGrandChild = ((UnaryIQTree)liftedRightChild).getChild();
                ImmutableSubstitution<ImmutableTerm> rightSubstitution = rightConstructionNode.getSubstitution();
                return this.tryToLiftRightConstruction(rightConstructionNode.getChildVariables(), rightGrandChild, rightSubstitution);
            }
            if (rightRootNode instanceof DistinctNode) {
                return this.tryToLiftRightDistinct((UnaryIQTree)liftedRightChild);
            }
            if (rightRootNode instanceof FilterNode) {
                return Optional.of(this.liftRightFilter((UnaryIQTree)liftedRightChild));
            }
            if (rightRootNode instanceof CommutativeJoinNode) {
                return this.tryToLiftRightCommutativeJoin(liftedRightChild);
            }
            return Optional.empty();
        }

        private Optional<LJNormalizationState> tryToLiftRightConstruction(ImmutableSet<Variable> rightChildRequiredVariables, IQTree rightGrandChild, ImmutableSubstitution<ImmutableTerm> rightSubstitution) {
            ImmutableSet<Variable> leftVariables = this.leftChild.getVariables();
            if (rightSubstitution.isEmpty()) {
                ConstructionNode newParent = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union(leftVariables, this.rightChild.getVariables()).immutableCopy());
                return Optional.of(this.updateParentConditionRightChild(newParent, this.ljCondition, rightGrandChild));
            }
            Optional<Map.Entry<Variable, Constant>> excludedEntry = this.extractExcludedEntry(rightSubstitution);
            ImmutableSubstitution<ImmutableTerm> selectedSubstitution = excludedEntry.map(excluded -> rightSubstitution.getImmutableMap().entrySet().stream().filter(e -> !e.equals(excluded)).collect(ImmutableCollectors.toMap())).map(LeftJoinNormalizerImpl.this.substitutionFactory::getSubstitution).orElse(rightSubstitution);
            if (selectedSubstitution.isEmpty()) {
                return this.liftRightGrandChildWithProvenance(excludedEntry.orElseThrow(() -> new MinorOntopInternalBugException("An entry was expected")), rightChildRequiredVariables, rightGrandChild);
            }
            Optional<ImmutableExpression> notOptimizedLJCondition = this.applyRightSubstitutionToLJCondition(this.ljCondition, selectedSubstitution, leftVariables);
            Optional rightProvenance = excludedEntry.map(e -> this.createProvenanceElements((Map.Entry<Variable, Constant>)e, rightGrandChild, rightChildRequiredVariables)).orElseGet(() -> this.createProvenanceElements(rightGrandChild, selectedSubstitution, leftVariables, rightChildRequiredVariables, this.variableGenerator));
            IQTree newRightChild = rightProvenance.flatMap(p -> p.constructionNode).map(n -> LeftJoinNormalizerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, rightGrandChild)).orElse(rightGrandChild);
            ImmutableSubstitution<ImmutableTerm> liftableSubstitution = this.computeLiftableSubstitution(selectedSubstitution, rightProvenance.map(e -> e.variable), leftVariables);
            ConstructionNode newParentNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union(this.leftChild.getVariables(), this.rightChild.getVariables()).immutableCopy(), liftableSubstitution);
            return Optional.of(this.updateParentConditionRightChild(newParentNode, notOptimizedLJCondition, newRightChild));
        }

        private Optional<LJNormalizationState> liftRightGrandChildWithProvenance(Map.Entry<Variable, Constant> provenanceEntry, ImmutableSet<Variable> rightChildRequiredVariables, IQTree rightGrandChild) {
            QueryNode grandChildNode = rightGrandChild.getRootNode();
            Optional<ConstructionNode> optionalProjectingAwayParent = Optional.of(this.rightChild.getVariables()).filter(rvs -> !rightChildRequiredVariables.equals(rightGrandChild.getVariables())).map(rvs -> Sets.union(this.leftChild.getVariables(), (Set)rvs).immutableCopy()).map(LeftJoinNormalizerImpl.this.iqFactory::createConstructionNode);
            if (grandChildNode instanceof DistinctNode) {
                if (this.leftChild.isDistinct()) {
                    IQTree newLeftChild = this.leftChild.removeDistincts();
                    IQTree newRightChild = this.createNewRightChildWithProvenance(provenanceEntry, ((UnaryIQTree)rightGrandChild).getChild(), rightGrandChild.getVariables());
                    ImmutableList additionalAncestors = optionalProjectingAwayParent.map(p -> ImmutableList.of((Object)((DistinctNode)grandChildNode), (Object)p)).orElseGet(() -> ImmutableList.of((Object)((DistinctNode)grandChildNode)));
                    return Optional.of(this.updateAncestorsConditionChildren((ImmutableList<UnaryOperatorNode>)additionalAncestors, this.ljCondition, newLeftChild, newRightChild));
                }
                return Optional.empty();
            }
            if (grandChildNode instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)grandChildNode;
                ImmutableExpression filterCondition = filterNode.getFilterCondition();
                ImmutableExpression newLJCondition = this.ljCondition.map(c -> LeftJoinNormalizerImpl.this.termFactory.getConjunction((ImmutableExpression)c, filterCondition)).orElse(filterCondition);
                ImmutableSet childVariablesToProject = Sets.union(rightChildRequiredVariables, filterCondition.getVariables()).immutableCopy();
                IQTree newRightChild = this.createNewRightChildWithProvenance(provenanceEntry, ((UnaryIQTree)rightGrandChild).getChild(), (ImmutableSet<Variable>)childVariablesToProject);
                return Optional.of(optionalProjectingAwayParent.map(p -> this.updateParentConditionRightChild((UnaryOperatorNode)p, Optional.of(newLJCondition), newRightChild)).orElseGet(() -> this.updateConditionAndRightChild(Optional.of(newLJCondition), newRightChild)));
            }
            if (grandChildNode instanceof CommutativeJoinNode) {
                CommutativeJoinNode joinNode = (CommutativeJoinNode)grandChildNode;
                Optional<ImmutableExpression> filterCondition = joinNode.getOptionalFilterCondition();
                if (filterCondition.isPresent()) {
                    ImmutableExpression condition = filterCondition.get();
                    ImmutableExpression newLJCondition = this.ljCondition.map(c -> LeftJoinNormalizerImpl.this.termFactory.getConjunction((ImmutableExpression)c, condition)).orElse(condition);
                    NaryIQTree newRightGrandChild = LeftJoinNormalizerImpl.this.iqFactory.createNaryIQTree((NaryOperatorNode)((Object)joinNode.changeOptionalFilterCondition(Optional.empty())), rightGrandChild.getChildren());
                    ImmutableSet childVariablesToProject = Sets.union(rightChildRequiredVariables, condition.getVariables()).immutableCopy();
                    IQTree newRightChild = this.createNewRightChildWithProvenance(provenanceEntry, newRightGrandChild, (ImmutableSet<Variable>)childVariablesToProject);
                    return Optional.of(optionalProjectingAwayParent.map(p -> this.updateParentConditionRightChild((UnaryOperatorNode)p, Optional.of(newLJCondition), newRightChild)).orElseGet(() -> this.updateConditionAndRightChild(Optional.of(newLJCondition), newRightChild)));
                }
                return Optional.empty();
            }
            return Optional.empty();
        }

        private IQTree createNewRightChildWithProvenance(Map.Entry<Variable, Constant> provenanceEntry, IQTree child, ImmutableSet<Variable> childVariablesToProject) {
            ConstructionNode newConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union((Set)ImmutableSet.of((Object)provenanceEntry.getKey()), childVariablesToProject).immutableCopy(), LeftJoinNormalizerImpl.this.substitutionFactory.getSubstitution(provenanceEntry.getKey(), (ImmutableTerm)provenanceEntry.getValue()));
            return LeftJoinNormalizerImpl.this.iqFactory.createUnaryIQTree(newConstructionNode, child);
        }

        public boolean isEmpty() {
            return this.leftChild.isDeclaredAsEmpty();
        }

        public IQTree createNormalizedTree(IQProperties currentIQProperties) {
            IQTree ljLevelTree;
            if (this.leftChild.isDeclaredAsEmpty()) {
                return LeftJoinNormalizerImpl.this.iqFactory.createEmptyNode(this.projectedVariables);
            }
            IQProperties normalizedProperties = currentIQProperties.declareNormalizedForOptimization();
            if (this.rightChild.isDeclaredAsEmpty()) {
                ImmutableSet<Variable> leftVariables = this.leftChild.getVariables();
                ImmutableSet rightSpecificVariables = (ImmutableSet)this.rightChild.getVariables().stream().filter(v -> !leftVariables.contains(v)).collect(ImmutableCollectors.toSet());
                ConstructionNode newParentConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union(leftVariables, (Set)rightSpecificVariables).immutableCopy(), LeftJoinNormalizerImpl.this.substitutionFactory.getSubstitution(rightSpecificVariables.stream().collect(ImmutableCollectors.toMap(v -> v, v -> LeftJoinNormalizerImpl.this.termFactory.getNullConstant()))));
                ljLevelTree = LeftJoinNormalizerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newParentConstructionNode, this.leftChild, normalizedProperties);
            } else {
                ljLevelTree = this.rightChild.getRootNode() instanceof TrueNode ? this.leftChild : LeftJoinNormalizerImpl.this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)LeftJoinNormalizerImpl.this.iqFactory.createLeftJoinNode(this.ljCondition), this.leftChild, this.rightChild, normalizedProperties);
            }
            IQTree ancestorTree = this.ancestors.stream().reduce(ljLevelTree, (t, n) -> LeftJoinNormalizerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, (IQTree)t), (t1, t2) -> {
                throw new MinorOntopInternalBugException("The order must be respected");
            });
            IQTree nonNormalizedTree = ancestorTree.getVariables().equals(this.projectedVariables) ? ancestorTree : LeftJoinNormalizerImpl.this.iqFactory.createUnaryIQTree(LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode(this.projectedVariables), ancestorTree);
            return nonNormalizedTree.normalizeForOptimization(this.variableGenerator);
        }

        private ImmutableSubstitution<ImmutableTerm> computeLiftableSubstitution(ImmutableSubstitution<? extends ImmutableTerm> selectedSubstitution, Optional<Variable> rightProvenanceVariable, ImmutableSet<Variable> leftVariables) {
            ImmutableMap<Variable, ImmutableTerm> newMap = selectedSubstitution.getImmutableMap().entrySet().stream().filter(e -> !leftVariables.contains(e.getKey())).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.transformRightSubstitutionValue((ImmutableTerm)e.getValue(), leftVariables, rightProvenanceVariable)));
            return LeftJoinNormalizerImpl.this.substitutionFactory.getSubstitution(newMap);
        }

        private ImmutableTerm transformRightSubstitutionValue(ImmutableTerm value, ImmutableSet<Variable> leftVariables, Optional<Variable> defaultRightProvenanceVariable) {
            if (this.isNullWhenRightIsRejected(value, leftVariables)) {
                return value;
            }
            Variable provenanceVariable = Optional.of(value).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).flatMap(f -> f.proposeProvenanceVariables().filter(v -> !leftVariables.contains(v)).findAny()).map(Optional::of).orElse(defaultRightProvenanceVariable).orElseThrow(() -> new MinorOntopInternalBugException("A default provenance variable was needed"));
            return LeftJoinNormalizerImpl.this.termFactory.getIfElseNull(LeftJoinNormalizerImpl.this.termFactory.getDBIsNotNull(provenanceVariable), value);
        }

        private ImmutableSubstitution<NonFunctionalTerm> selectDownSubstitution(ImmutableSubstitution<NonFunctionalTerm> simplificationSubstitution, ImmutableSet<Variable> rightVariables) {
            ImmutableMap newMap = simplificationSubstitution.getImmutableMap().entrySet().stream().filter(e -> rightVariables.contains(e.getKey())).collect(ImmutableCollectors.toMap());
            return LeftJoinNormalizerImpl.this.substitutionFactory.getSubstitution(newMap);
        }

        private Optional<RightProvenance> createProvenanceElements(Map.Entry<Variable, Constant> provenanceVariableDefinition, IQTree rightTree, ImmutableSet<Variable> rightRequiredVariables) {
            Variable rightProvenanceVariable = provenanceVariableDefinition.getKey();
            ImmutableSet newRightProjectedVariables = (ImmutableSet)Stream.concat(Stream.of(rightProvenanceVariable), rightRequiredVariables.stream()).collect(ImmutableCollectors.toSet());
            ConstructionNode newRightConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)newRightProjectedVariables, LeftJoinNormalizerImpl.this.substitutionFactory.getSubstitution(rightProvenanceVariable, (ImmutableTerm)provenanceVariableDefinition.getValue()));
            return Optional.of(new RightProvenance(rightProvenanceVariable, newRightConstructionNode));
        }

        private Optional<RightProvenance> createProvenanceElements(IQTree rightTree, ImmutableSubstitution<? extends ImmutableTerm> selectedSubstitution, ImmutableSet<Variable> leftVariables, ImmutableSet<Variable> rightRequiredVariables, VariableGenerator variableGenerator) {
            if (selectedSubstitution.getImmutableMap().entrySet().stream().filter(e -> !leftVariables.contains(e.getKey())).map(Map.Entry::getValue).anyMatch(value -> this.needsAnExternalProvenanceVariable((ImmutableTerm)value, leftVariables))) {
                VariableNullability rightNullability = rightTree.getVariableNullability();
                Optional<Variable> nonNullableRightVariable = rightTree.getVariables().stream().filter(v -> !leftVariables.contains(v)).filter(v -> !rightNullability.isPossiblyNullable((Variable)v)).findFirst();
                if (nonNullableRightVariable.isPresent()) {
                    return Optional.of(new RightProvenance(nonNullableRightVariable.get()));
                }
                Variable provenanceVariable = variableGenerator.generateNewVariable();
                ImmutableSet newRightProjectedVariables = (ImmutableSet)Stream.concat(Stream.of(provenanceVariable), rightRequiredVariables.stream()).collect(ImmutableCollectors.toSet());
                ConstructionNode newRightConstructionNode = LeftJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)newRightProjectedVariables, LeftJoinNormalizerImpl.this.substitutionFactory.getSubstitution(provenanceVariable, LeftJoinNormalizerImpl.this.termFactory.getProvenanceSpecialConstant()));
                return Optional.of(new RightProvenance(provenanceVariable, newRightConstructionNode));
            }
            return Optional.empty();
        }

        private boolean needsAnExternalProvenanceVariable(ImmutableTerm immutableTerm, ImmutableSet<Variable> leftVariables) {
            if (this.isNullWhenRightIsRejected(immutableTerm, leftVariables)) {
                return false;
            }
            if (immutableTerm instanceof ImmutableFunctionalTerm) {
                return ((ImmutableFunctionalTerm)immutableTerm).proposeProvenanceVariables().allMatch(arg_0 -> leftVariables.contains(arg_0));
            }
            return true;
        }

        private boolean isNullWhenRightIsRejected(ImmutableTerm immutableTerm, ImmutableSet<Variable> leftVariables) {
            ImmutableSubstitution<Constant> nullSubstitution = LeftJoinNormalizerImpl.this.substitutionFactory.getSubstitution(immutableTerm.getVariableStream().filter(v -> !leftVariables.contains(v)).distinct().collect(ImmutableCollectors.toMap(v -> v, v -> LeftJoinNormalizerImpl.this.termFactory.getNullConstant())));
            return nullSubstitution.apply(immutableTerm).simplify().isNull();
        }

        private Optional<ImmutableExpression> applyRightSubstitutionToLJCondition(Optional<ImmutableExpression> ljCondition, ImmutableSubstitution<ImmutableTerm> selectedSubstitution, ImmutableSet<Variable> leftVariables) {
            Stream<ImmutableExpression> equalitiesToInsert = selectedSubstitution.getImmutableMap().entrySet().stream().filter(e -> leftVariables.contains(e.getKey())).map(e -> LeftJoinNormalizerImpl.this.termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue(), new ImmutableTerm[0]));
            return LeftJoinNormalizerImpl.this.termFactory.getConjunction(Stream.concat(ljCondition.map(selectedSubstitution::applyToBooleanExpression).map(Stream::of).orElseGet(Stream::empty), equalitiesToInsert));
        }

        private Optional<Map.Entry<Variable, Constant>> extractExcludedEntry(ImmutableSubstitution<ImmutableTerm> rightSubstitution) {
            DBConstant specialProvenanceConstant = LeftJoinNormalizerImpl.this.termFactory.getProvenanceSpecialConstant();
            return rightSubstitution.getImmutableMap().entrySet().stream().filter(e -> ((ImmutableTerm)e.getValue()).equals(specialProvenanceConstant)).map(e -> Maps.immutableEntry(e.getKey(), (Object)specialProvenanceConstant)).findFirst();
        }
    }
}

